/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.structure;

import hunternif.mc.impl.atlas.core.TileIdMap;
import hunternif.mc.impl.atlas.structure.StructureHandler;
import hunternif.mc.impl.atlas.util.MathUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;

public class NetherFortress {
    public static Collection<ChunkPos> bridgeX(World world, JigsawPiece element, MutableBoundingBox box) {
        HashSet<ChunkPos> matches = new HashSet<ChunkPos>();
        if (box.func_78883_b() > 16) {
            int chunkZ = MathUtil.getCenter(box).func_177952_p() >> 4;
            for (int x = box.field_78897_a; x < box.field_78893_d; x += 16) {
                matches.add(new ChunkPos(x >> 4, chunkZ));
            }
        }
        return matches;
    }

    public static Collection<ChunkPos> bridgeZ(World world, JigsawPiece element, MutableBoundingBox box) {
        HashSet<ChunkPos> matches = new HashSet<ChunkPos>();
        if (box.func_78880_d() > 16) {
            int chunkX = MathUtil.getCenter(box).func_177958_n() >> 4;
            for (int z = box.field_78896_c; z < box.field_78892_f; z += 16) {
                matches.add(new ChunkPos(chunkX, z >> 4));
            }
        }
        return matches;
    }

    public static Collection<ChunkPos> bridgeEndX(World world, JigsawPiece element, MutableBoundingBox box) {
        if (box.func_78883_b() > box.func_78880_d()) {
            return Collections.singleton(new ChunkPos(box.func_215126_f().func_177958_n() >> 4, box.func_215126_f().func_177952_p() >> 4));
        }
        return Collections.emptySet();
    }

    public static Collection<ChunkPos> bridgeEndZ(World world, JigsawPiece element, MutableBoundingBox box) {
        if (box.func_78880_d() > box.func_78883_b()) {
            return Collections.singleton(new ChunkPos(box.func_215126_f().func_177958_n() >> 4, box.func_215126_f().func_177952_p() >> 4));
        }
        return Collections.emptySet();
    }

    public static void registerPieces() {
        StructureHandler.registerTile(IStructurePieceType.field_214797_r, 40, TileIdMap.NETHER_FORTRESS_BRIDGE_PLATFORM);
        StructureHandler.registerTile(IStructurePieceType.field_214799_t, 50, TileIdMap.NETHER_FORTRESS_BRIDGE_STAIRS);
        StructureHandler.registerTile(IStructurePieceType.field_214796_q, 50, TileIdMap.NETHER_FORTRESS_CORRIDOR_NETHER_WARTS_ROOM);
        StructureHandler.registerTile(IStructurePieceType.field_214798_s, 60, TileIdMap.NETHER_FORTRESS_BRIDGE_SMALL_CROSSING);
        StructureHandler.registerTile(IStructurePieceType.field_214790_k, 70, TileIdMap.NETHER_FORTRESS_WALL);
        StructureHandler.registerTile(IStructurePieceType.field_214793_n, 70, TileIdMap.NETHER_FORTRESS_WALL);
        StructureHandler.registerTile(IStructurePieceType.field_214794_o, 70, TileIdMap.NETHER_FORTRESS_WALL);
        StructureHandler.registerTile(IStructurePieceType.field_214795_p, 70, TileIdMap.NETHER_FORTRESS_WALL);
        StructureHandler.registerTile(IStructurePieceType.field_214800_u, 70, TileIdMap.NETHER_FORTRESS_WALL);
        StructureHandler.registerTile(IStructurePieceType.field_214791_l, 70, TileIdMap.NETHER_FORTRESS_EXIT);
        StructureHandler.registerTile(IStructurePieceType.field_214786_g, 80, TileIdMap.NETHER_FORTRESS_BRIDGE_CROSSING);
        StructureHandler.registerTile(IStructurePieceType.field_214787_h, 90, TileIdMap.NETHER_BRIDGE_END_X, NetherFortress::bridgeEndX);
        StructureHandler.registerTile(IStructurePieceType.field_214787_h, 90, TileIdMap.NETHER_BRIDGE_END_Z, NetherFortress::bridgeEndZ);
        StructureHandler.registerTile(IStructurePieceType.field_214788_i, 100, TileIdMap.NETHER_BRIDGE_X, NetherFortress::bridgeX);
        StructureHandler.registerTile(IStructurePieceType.field_214788_i, 100, TileIdMap.NETHER_BRIDGE_Z, NetherFortress::bridgeZ);
    }
}

