/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.api.impl;

import hunternif.mc.api.TileAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileDataStorage;
import hunternif.mc.impl.atlas.network.packet.c2s.play.PutTileC2SPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.DeleteGlobalTileS2CPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.PutGlobalTileS2CPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.PutTileS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class TileApiImpl
implements TileAPI {
    @Override
    public void putTile(class_1937 world, int atlasID, class_2960 tile, int chunkX, int chunkZ) {
        if (tile == null) {
            Log.error("Attempted to put custom tile with null name", new Object[0]);
            return;
        }
        class_5321 dimension = world.method_27983();
        if (world.field_9236) {
            new PutTileC2SPacket(atlasID, chunkX, chunkZ, tile).send();
        } else {
            AtlasData data = AntiqueAtlasMod.tileData.getData(atlasID, world);
            data.setTile((class_5321<class_1937>)dimension, chunkX, chunkZ, tile);
            for (class_1657 syncedPlayer : data.getSyncedPlayers()) {
                new PutTileS2CPacket(atlasID, (class_5321<class_1937>)dimension, chunkX, chunkZ, tile).send((class_3222)syncedPlayer);
            }
        }
    }

    @Override
    public class_2960 getTile(class_1937 world, int atlasID, int chunkX, int chunkZ) {
        AtlasData data = AntiqueAtlasMod.tileData.getData(atlasID, world);
        return data.getWorldData((class_5321<class_1937>)world.method_27983()).getTile(chunkX, chunkZ);
    }

    @Override
    public void putGlobalTile(class_1937 world, class_2960 tileId, int chunkX, int chunkZ) {
        if (tileId == null) {
            Log.error("Attempted to put global tile with null name", new Object[0]);
            return;
        }
        if (world.field_9236) {
            Log.warn("Client attempted to put global tile", new Object[0]);
            return;
        }
        TileDataStorage data = AntiqueAtlasMod.globalTileData.getData(world);
        data.setTile(chunkX, chunkZ, tileId);
        new PutGlobalTileS2CPacket((class_5321<class_1937>)world.method_27983(), chunkX, chunkZ, tileId).send((class_3218)world);
    }

    @Override
    public class_2960 getGlobalTile(class_1937 world, int chunkX, int chunkZ) {
        TileDataStorage data = AntiqueAtlasMod.globalTileData.getData(world);
        return data.getTile(chunkX, chunkZ);
    }

    @Override
    public void deleteGlobalTile(class_1937 world, int chunkX, int chunkZ) {
        if (world.field_9236) {
            Log.warn("Client attempted to delete global tile", new Object[0]);
            return;
        }
        TileDataStorage data = AntiqueAtlasMod.globalTileData.getData(world);
        if (data.getTile(chunkX, chunkZ) != null) {
            data.removeTile(chunkX, chunkZ);
            new DeleteGlobalTileS2CPacket((class_5321<class_1937>)world.method_27983(), chunkX, chunkZ).send((class_3218)world);
        }
    }
}

