/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import com.mojang.blaze3d.systems.RenderSystem;
import hunternif.mc.api.client.AtlasClientAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.SetTileRenderer;
import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.SubTileQuartet;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.TileRenderIterator;
import hunternif.mc.impl.atlas.client.TileTextureMap;
import hunternif.mc.impl.atlas.client.gui.GuiAtlas;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.item.AntiqueAtlasItems;
import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.DimensionMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.registry.MarkerRenderInfo;
import hunternif.mc.impl.atlas.registry.MarkerType;
import hunternif.mc.impl.atlas.util.Rect;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;

@Environment(value=EnvType.CLIENT)
public class OverlayRenderer
extends class_332 {
    private static final int CHUNK_SIZE = 16;
    private static final float INNER_ELEMENTS_SCALE_FACTOR = 1.9f;
    private class_1657 player;
    private class_1937 world;

    public void drawOverlay(class_4587 matrices, class_4597 vertexConsumer, int light, class_1799 atlas) {
        if (class_310.method_1551().field_1755 instanceof GuiAtlas) {
            return;
        }
        if (class_310.method_1551().field_1687 == null || class_310.method_1551().field_1724 == null) {
            return;
        }
        this.player = class_310.method_1551().field_1724;
        this.world = class_310.method_1551().field_1687;
        if (!atlas.method_7960() && atlas.method_7909() == AntiqueAtlasItems.ATLAS.getOrNull()) {
            int atlasID = AtlasItem.getAtlasID(atlas);
            this.drawMinimap(matrices, atlasID, vertexConsumer, light);
        }
    }

    private void drawMinimap(class_4587 matrices, int atlasID, class_4597 buffer, int light) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 0.01);
        Textures.BOOK.drawWithLight(buffer, matrices, 0, 0, 465, 327, light);
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_22905(1.9f, 1.9f, 1.0f);
        this.drawTiles(buffer, matrices, atlasID, light);
        matrices.method_22904(0.0, 0.0, -0.01);
        if (AntiqueAtlasMod.CONFIG.markerSize > 0) {
            this.drawMarkers(buffer, matrices, atlasID, light);
        }
        matrices.method_22909();
        matrices.method_22904(0.0, 0.0, -0.02);
        this.drawPlayer(buffer, matrices, light);
        matrices.method_22904(0.0, 0.0, -0.01);
        Textures.BOOK_FRAME.drawWithLight(buffer, matrices, 0, 0, 465, 327, light);
        RenderSystem.disableBlend();
    }

    private void drawTiles(class_4597 buffer, class_4587 matrices, int atlasID, int light) {
        Rect iteratorScope = this.getChunkCoverage(this.player.method_19538());
        TileRenderIterator iter = AtlasClientAPI.getTileAPI().getTiles(this.world, atlasID, iteratorScope, 1);
        class_243 chunkPosition = this.player.method_19538().method_18805(0.0625, 0.0625, 0.0625);
        int shapeMiddleX = 122;
        int shapeMiddleY = 86;
        SetTileRenderer renderer = new SetTileRenderer(buffer, matrices, AntiqueAtlasMod.CONFIG.tileSize / 2, light);
        while (iter.hasNext()) {
            SubTileQuartet subtiles = iter.next();
            for (SubTile subtile : subtiles) {
                if (subtile == null || subtile.tile == null) continue;
                float relativeChunkPositionX = (float)((double)subtile.x / 2.0 + (double)iteratorScope.minX - chunkPosition.field_1352);
                float relativeChunkPositionY = (float)((double)subtile.y / 2.0 + (double)iteratorScope.minY - chunkPosition.field_1350);
                renderer.addTileCorner(TileTextureMap.instance().getTexture(subtile).getTexture(), shapeMiddleX + (int)Math.floor(relativeChunkPositionX * (float)AntiqueAtlasMod.CONFIG.tileSize), shapeMiddleY + (int)Math.floor(relativeChunkPositionY * (float)AntiqueAtlasMod.CONFIG.tileSize), subtile.getTextureU(), subtile.getTextureV());
            }
        }
        renderer.draw();
    }

    private void drawMarkers(class_4597 buffer, class_4587 matrices, int atlasID, int light) {
        WorldData biomeData = AntiqueAtlasMod.tileData.getData(atlasID, this.world).getWorldData((class_5321<class_1937>)this.world.method_27983());
        DimensionMarkersData globalMarkersData = AntiqueAtlasMod.globalMarkersData.getData().getMarkersDataInWorld((class_5321<class_1937>)this.world.method_27983());
        this.drawMarkersData(buffer, matrices, globalMarkersData, biomeData, light);
        MarkersData markersData = AntiqueAtlasMod.markersData.getMarkersData(atlasID, (class_1937)class_310.method_1551().field_1687);
        if (markersData != null) {
            DimensionMarkersData localMarkersData = markersData.getMarkersDataInWorld((class_5321<class_1937>)this.world.method_27983());
            this.drawMarkersData(buffer, matrices, localMarkersData, biomeData, light);
        }
    }

    private void drawPlayer(class_4597 buffer, class_4587 matrices, int light) {
        matrices.method_22903();
        matrices.method_22904(232.0, 163.0, 0.0);
        matrices.method_22907(new class_1158(class_1160.field_20707, this.player.method_5791() + 180.0f, true));
        matrices.method_22904((double)(-AntiqueAtlasMod.CONFIG.playerIconWidth) / 2.0, (double)(-AntiqueAtlasMod.CONFIG.playerIconHeight) / 2.0, 0.0);
        Textures.PLAYER.drawWithLight(buffer, matrices, 0, 0, AntiqueAtlasMod.CONFIG.playerIconWidth, AntiqueAtlasMod.CONFIG.playerIconHeight, light);
        matrices.method_22909();
    }

    private void drawMarkersData(class_4597 buffer, class_4587 matrices, DimensionMarkersData markersData, WorldData biomeData, int light) {
        Rect mcchunks = this.getChunkCoverage(this.player.method_19538());
        Rect chunks = new Rect(mcchunks.minX / 8, mcchunks.minY / 8, (int)Math.ceil((float)mcchunks.maxX / 8.0f), (int)Math.ceil((float)mcchunks.maxY / 8.0f));
        int shapeMiddleX = 122;
        int shapeMiddleY = 86;
        class_243 chunkPosition = this.player.method_19538().method_18805(0.0625, 0.0625, 0.0625);
        for (int x = chunks.minX; x <= chunks.maxX; ++x) {
            for (int z = chunks.minY; z <= chunks.maxY; ++z) {
                List<Marker> markers = markersData.getMarkersAtChunk(x, z);
                if (markers == null) continue;
                for (Marker marker : markers) {
                    float relativeChunkPositionX = (float)((double)marker.getChunkX() - chunkPosition.field_1352);
                    float relativeChunkPositionY = (float)((double)marker.getChunkZ() - chunkPosition.field_1350);
                    this.renderMarker(buffer, matrices, marker, shapeMiddleX + (int)Math.floor(relativeChunkPositionX * 8.0f), shapeMiddleY + (int)Math.floor(relativeChunkPositionY * 8.0f), biomeData, light);
                }
            }
        }
    }

    private void renderMarker(class_4597 buffer, class_4587 matrices, Marker marker, int x, int y, WorldData biomeData, int light) {
        int tileHalfSize = 2;
        if (x + tileHalfSize > 240 || x - tileHalfSize < 3 || y + tileHalfSize >= 166 || y - tileHalfSize < 0) {
            return;
        }
        if (!marker.isVisibleAhead() && !biomeData.hasTileAt(marker.getChunkX(), marker.getChunkZ())) {
            return;
        }
        MarkerType type = (MarkerType)MarkerType.REGISTRY.method_10223(marker.getType());
        MarkerRenderInfo info = type.getRenderInfo(1.0, AntiqueAtlasMod.CONFIG.tileSize, 1.0);
        info.tex.drawWithLight(buffer, matrices, x - 8 + 4, y - 8 + 4, 16, 16, light);
    }

    private Rect getChunkCoverage(class_243 position) {
        int minChunkX = (int)Math.floor(position.field_1352 / 16.0 - (double)(310.0f / (4.0f * (float)AntiqueAtlasMod.CONFIG.tileSize)));
        int minChunkY = (int)Math.floor(position.field_1350 / 16.0 - (double)(218.0f / (4.0f * (float)AntiqueAtlasMod.CONFIG.tileSize)));
        int maxChunkX = (int)Math.ceil(position.field_1352 / 16.0 + (double)(310.0f / (4.0f * (float)AntiqueAtlasMod.CONFIG.tileSize)));
        int maxChunkY = (int)Math.ceil(position.field_1350 / 16.0 + (double)(218.0f / (4.0f * (float)AntiqueAtlasMod.CONFIG.tileSize)));
        return new Rect(minChunkX -= 4, minChunkY -= 3, maxChunkX += 4, maxChunkY += 2);
    }
}

