/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.client.texture.TileTexture;
import hunternif.mc.impl.atlas.resource.ResourceReloadListener;
import hunternif.mc.impl.atlas.util.Log;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

@Environment(value=EnvType.CLIENT)
public class TextureConfig
implements ResourceReloadListener<Map<class_2960, ITexture>> {
    public static final class_2960 ID = AntiqueAtlasMod.id("textures");
    private final Map<class_2960, ITexture> texture_map;

    public TextureConfig(Map<class_2960, ITexture> texture_map) {
        this.texture_map = texture_map;
    }

    @Override
    public CompletableFuture<Map<class_2960, ITexture>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<class_2960, TileTexture> textures = new HashMap<class_2960, TileTexture>();
            for (class_2960 id : manager.method_14488("textures/gui/tiles", s -> s.endsWith(".png"))) {
                try {
                    class_2960 texture_id = new class_2960(id.method_12836(), id.method_12832().replace("textures/gui/tiles/", "").replace(".png", ""));
                    textures.put(texture_id, new TileTexture(id));
                }
                catch (class_151 e) {
                    AntiqueAtlasMod.LOG.warn("Failed to read texture!", (Throwable)e);
                }
            }
            return textures;
        }, executor);
    }

    @Override
    public CompletableFuture<Void> apply(Map<class_2960, ITexture> textures, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            this.texture_map.clear();
            for (Map.Entry entry : textures.entrySet()) {
                this.texture_map.put((class_2960)entry.getKey(), (ITexture)entry.getValue());
                if (!AntiqueAtlasMod.CONFIG.resourcePackLogging) continue;
                Log.info("Loaded texture %s with path %s", entry.getKey(), ((ITexture)entry.getValue()).getTexture());
            }
        }, executor);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public Collection<class_2960> getDependencies() {
        return Collections.emptyList();
    }
}

