/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.TextureConfig;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.resource.ResourceReloadListener;
import hunternif.mc.impl.atlas.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

@Environment(value=EnvType.CLIENT)
public class TextureSetConfig
implements ResourceReloadListener<Collection<TextureSet>> {
    public static final class_2960 ID = AntiqueAtlasMod.id("texture_sets");
    private static final int VERSION = 1;
    private static final JsonParser PARSER = new JsonParser();
    private final TextureSetMap textureSetMap;

    public TextureSetConfig(TextureSetMap textureSetMap) {
        this.textureSetMap = textureSetMap;
    }

    @Override
    public CompletableFuture<Collection<TextureSet>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<class_2960, TextureSet> sets = new HashMap<class_2960, TextureSet>();
            try {
                for (class_2960 id : manager.method_14488("atlas/texture_sets", s -> s.endsWith(".json"))) {
                    class_2960 texture_id = new class_2960(id.method_12836(), id.method_12832().replace("atlas/texture_sets/", "").replace(".json", ""));
                    try {
                        class_3298 resource = manager.method_14486(id);
                        InputStream stream = resource.method_14482();
                        try (InputStreamReader reader = new InputStreamReader(stream);){
                            TextureSet set;
                            JsonObject object = PARSER.parse((Reader)reader).getAsJsonObject();
                            int version = object.getAsJsonPrimitive("version").getAsInt();
                            if (version != 1) {
                                AntiqueAtlasMod.LOG.warn("The TextureSet " + texture_id + " is in the wrong version! Skipping.");
                                continue;
                            }
                            JsonObject data = object.getAsJsonObject("data");
                            ArrayList<class_2960> textures = new ArrayList<class_2960>();
                            for (Map.Entry entry2 : data.getAsJsonObject("textures").entrySet()) {
                                for (int i = 0; i < ((JsonElement)entry2.getValue()).getAsInt(); ++i) {
                                    textures.add(new class_2960((String)entry2.getKey()));
                                }
                            }
                            class_2960[] textureArray = new class_2960[textures.size()];
                            if (!data.has("shore")) {
                                set = new TextureSet(texture_id, textures.toArray(textureArray));
                            } else {
                                JsonObject shore = data.getAsJsonObject("shore");
                                if (!shore.has("water")) {
                                    throw new RuntimeException("The `shore` entry is missing a water entry.");
                                }
                                set = new TextureSet.TextureSetShore(texture_id, new class_2960(shore.get("water").getAsString()), textures.toArray(textureArray));
                            }
                            if (data.has("stitch")) {
                                data.getAsJsonObject("stitch").entrySet().forEach(entry -> {
                                    String to;
                                    switch (to = ((JsonElement)entry.getValue()).getAsString()) {
                                        case "both": {
                                            set.stitchTo(new class_2960((String)entry.getKey()));
                                            break;
                                        }
                                        case "horizontal": {
                                            set.stitchToHorizontal(new class_2960((String)entry.getKey()));
                                            break;
                                        }
                                        case "vertical": {
                                            set.stitchToVertical(new class_2960((String)entry.getKey()));
                                            break;
                                        }
                                        default: {
                                            throw new RuntimeException("Invalid stitch value (" + to + ") for `" + (String)entry.getKey() + "`");
                                        }
                                    }
                                });
                            }
                            sets.put(texture_id, set);
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        AntiqueAtlasMod.LOG.warn("Error reading TextureSet " + texture_id + "!", (Throwable)e);
                    }
                }
            }
            catch (Throwable e) {
                Log.warn(e, "Failed to read texture sets!", new Object[0]);
            }
            return sets.values();
        }, executor);
    }

    @Override
    public CompletableFuture<Void> apply(Collection<TextureSet> sets, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (TextureSet set : sets) {
                try {
                    set.loadTextures();
                    this.textureSetMap.register(set);
                    if (!AntiqueAtlasMod.CONFIG.resourcePackLogging) continue;
                    Log.info("Loaded texture set %s with %d custom texture(s)", set.name, set.getTexturePaths().length);
                }
                catch (Throwable e) {
                    Log.error(e, "Failed to load the texture set `%s`:", set.name);
                }
            }
            for (TextureSet set : sets) {
                set.checkStitching();
                if (!(set instanceof TextureSet.TextureSetShore)) continue;
                TextureSet.TextureSetShore texture = (TextureSet.TextureSetShore)set;
                texture.loadWater();
                if (!AntiqueAtlasMod.CONFIG.resourcePackLogging) continue;
                Log.info("Loaded water texture `%s` for shore texture `%s` texture", texture.waterName, texture.name);
            }
        }, executor);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public Collection<class_2960> getDependencies() {
        return Collections.singleton(TextureConfig.ID);
    }
}

