/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetConfig;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.TileTextureMap;
import hunternif.mc.impl.atlas.core.scaning.TileHeightType;
import hunternif.mc.impl.atlas.resource.ResourceReloadListener;
import hunternif.mc.impl.atlas.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

@Environment(value=EnvType.CLIENT)
public class TileTextureConfig
implements ResourceReloadListener<Map<class_2960, class_2960>> {
    public static final class_2960 ID = AntiqueAtlasMod.id("tile_textures");
    private final TileTextureMap tileTextureMap;
    private final TextureSetMap textureSetMap;

    public TileTextureConfig(TileTextureMap biomeTextureMap, TextureSetMap textureSetMap) {
        this.tileTextureMap = biomeTextureMap;
        this.textureSetMap = textureSetMap;
    }

    @Override
    public CompletableFuture<Map<class_2960, class_2960>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<class_2960, class_2960> map = new HashMap<class_2960, class_2960>();
            try {
                for (class_2960 id : manager.method_14488("atlas/tiles", s -> s.endsWith(".json"))) {
                    class_2960 tile_id = new class_2960(id.method_12836(), id.method_12832().replace("atlas/tiles/", "").replace(".json", ""));
                    try {
                        class_3298 resource = manager.method_14486(id);
                        InputStream stream = resource.method_14482();
                        try (InputStreamReader reader = new InputStreamReader(stream);){
                            JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                            int version = object.getAsJsonPrimitive("version").getAsInt();
                            if (version == 1) {
                                class_2960 texture_set = new class_2960(object.get("texture_set").getAsString());
                                map.put(tile_id, texture_set);
                                for (TileHeightType layer : TileHeightType.values()) {
                                    map.put(class_2960.method_12829((String)(tile_id + "_" + layer.getName())), texture_set);
                                }
                                continue;
                            }
                            if (version == 2) {
                                class_2960 default_entry = TileTextureMap.DEFAULT_TEXTURE;
                                try {
                                    default_entry = new class_2960(object.getAsJsonObject("texture_sets").get("default").getAsString());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                map.put(tile_id, default_entry);
                                for (TileHeightType layer : TileHeightType.values()) {
                                    class_2960 texture_set = default_entry;
                                    try {
                                        texture_set = new class_2960(object.getAsJsonObject("texture_sets").get(layer.getName()).getAsString());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    map.put(class_2960.method_12829((String)(tile_id + "_" + layer)), texture_set);
                                }
                                continue;
                            }
                            AntiqueAtlasMod.LOG.warn("The tile " + tile_id + " is in the wrong version! Skipping.");
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        AntiqueAtlasMod.LOG.warn("Error reading tile mapping " + tile_id + "!", (Throwable)e);
                    }
                }
            }
            catch (Throwable e) {
                Log.warn(e, "Failed to read tile mappings!", new Object[0]);
            }
            return map;
        }, executor);
    }

    @Override
    public CompletableFuture<Void> apply(Map<class_2960, class_2960> tileMap, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (Map.Entry entry : tileMap.entrySet()) {
                class_2960 tile_id = (class_2960)entry.getKey();
                class_2960 texture_set = (class_2960)entry.getValue();
                TextureSet set = this.textureSetMap.getByName((class_2960)entry.getValue());
                if (set == null) {
                    AntiqueAtlasMod.LOG.error("Missing texture set `{}` for tile `{}`. Using default.", (Object)texture_set, (Object)tile_id);
                    set = this.tileTextureMap.getDefaultTexture();
                }
                this.tileTextureMap.setTexture((class_2960)entry.getKey(), set);
                if (!AntiqueAtlasMod.CONFIG.resourcePackLogging) continue;
                Log.info("Loaded tile %s with texture set %s", tile_id, set.name);
            }
        }, executor);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public Collection<class_2960> getDependencies() {
        return Collections.singleton(TextureSetConfig.ID);
    }
}

