/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import dev.architectury.injectables.annotations.ExpectPlatform;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.fabric.TileTextureMapImpl;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.core.scaning.TileHeightType;
import hunternif.mc.impl.atlas.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_6796;

@Environment(value=EnvType.CLIENT)
public class TileTextureMap {
    private static final TileTextureMap INSTANCE = new TileTextureMap();
    public static final class_2960 DEFAULT_TEXTURE = AntiqueAtlasMod.id("test");
    private final Map<class_2960, TextureSet> textureMap = new HashMap<class_2960, TextureSet>();

    public static TileTextureMap instance() {
        return INSTANCE;
    }

    public void setTexture(class_2960 tileId, TextureSet textureSet) {
        if (tileId == null) {
            return;
        }
        if (textureSet == null) {
            if (this.textureMap.remove(tileId) != null) {
                Log.warn("Removing old texture for %d", tileId);
            }
            return;
        }
        this.textureMap.put(tileId, textureSet);
    }

    public void setAllTextures(class_2960 tileId, TextureSet textureSet) {
        this.setTexture(tileId, textureSet);
        for (TileHeightType layer : TileHeightType.values()) {
            this.setTexture(class_2960.method_12829((String)(tileId + "_" + layer)), textureSet);
        }
    }

    public TextureSet getDefaultTexture() {
        return TextureSetMap.instance().getByName(DEFAULT_TEXTURE);
    }

    public void autoRegister(class_2960 id, class_5321<class_1959> biome) {
        if (biome == null || id == null) {
            Log.error("Given biome is null. Cannot autodetect a suitable texture set for that.", new Object[0]);
            return;
        }
        Optional<class_2960> texture_set = TileTextureMap.guessFittingTextureSet(biome);
        if (texture_set.isPresent()) {
            this.setAllTextures(id, TextureSetMap.instance().getByName(texture_set.get()));
            Log.info("Auto-registered standard texture set for biome %s: %s", id, texture_set.get());
        } else {
            Log.error("Failed to auto-register a standard texture set for the biome '%s'. This is most likely caused by errors in the TextureSet configurations, check your resource packs first before reporting it as an issue!", id.toString());
            this.setAllTextures(id, this.getDefaultTexture());
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Optional<class_2960> guessFittingTextureSet(class_5321<class_1959> biome) {
        return TileTextureMapImpl.guessFittingTextureSet(biome);
    }

    public static Optional<class_2960> guessFittingTextureSetFallback(class_1959 biome) {
        class_2960 texture_set = switch (biome.method_8688()) {
            default -> throw new IncompatibleClassChangeError();
            case class_1959.class_1961.field_9364 -> AntiqueAtlasMod.id("swamp");
            case class_1959.class_1961.field_9367, class_1959.class_1961.field_9369 -> {
                if (biome.method_8694() == class_1959.class_1963.field_9383) {
                    yield AntiqueAtlasMod.id("ice");
                }
                yield AntiqueAtlasMod.id("water");
            }
            case class_1959.class_1961.field_9363 -> AntiqueAtlasMod.id("shore");
            case class_1959.class_1961.field_9358 -> AntiqueAtlasMod.id("jungle");
            case class_1959.class_1961.field_9356 -> AntiqueAtlasMod.id("savanna");
            case class_1959.class_1961.field_9354 -> AntiqueAtlasMod.id("plateau_mesa");
            case class_1959.class_1961.field_9370 -> {
                if (biome.method_8694() == class_1959.class_1963.field_9383) {
                    yield AntiqueAtlasMod.id("snow_pines");
                }
                yield AntiqueAtlasMod.id("forest");
            }
            case class_1959.class_1961.field_9355 -> {
                if (biome.method_8694() == class_1959.class_1963.field_9383) {
                    yield AntiqueAtlasMod.id("snow");
                }
                yield AntiqueAtlasMod.id("plains");
            }
            case class_1959.class_1961.field_9362 -> AntiqueAtlasMod.id("ice_spikes");
            case class_1959.class_1961.field_9368 -> AntiqueAtlasMod.id("desert");
            case class_1959.class_1961.field_9361 -> AntiqueAtlasMod.id("snow");
            case class_1959.class_1961.field_9357 -> AntiqueAtlasMod.id("hills");
            case class_1959.class_1961.field_34464 -> AntiqueAtlasMod.id("mountains");
            case class_1959.class_1961.field_9360 -> {
                List features = biome.method_30970().method_30983();
                class_6796 chorus_plant_feature = (class_6796)class_5458.field_35761.method_10223(new class_2960("chorus_plant"));
                if (!$assertionsDisabled && chorus_plant_feature == null) {
                    throw new AssertionError();
                }
                boolean has_chorus_plant = features.stream().anyMatch(entries -> entries.method_40239().anyMatch(feature -> feature.comp_349() == chorus_plant_feature));
                if (has_chorus_plant) {
                    yield AntiqueAtlasMod.id("end_island_plants");
                }
                yield AntiqueAtlasMod.id("end_island");
            }
            case class_1959.class_1961.field_9365 -> AntiqueAtlasMod.id("mushroom");
            case class_1959.class_1961.field_9366 -> AntiqueAtlasMod.id("soul_sand_valley");
            case class_1959.class_1961.field_9371 -> AntiqueAtlasMod.id("end_void");
            case class_1959.class_1961.field_29217 -> {
                Log.warn("Underground biomes aren't supported yet.", new Object[0]);
                yield null;
            }
        };
        return Optional.ofNullable(texture_set);
    }

    public boolean isRegistered(class_2960 id) {
        return this.textureMap.containsKey(id);
    }

    public TextureSet getTextureSet(class_2960 tile) {
        if (tile == null) {
            return this.getDefaultTexture();
        }
        return this.textureMap.getOrDefault(tile, this.getDefaultTexture());
    }

    public ITexture getTexture(SubTile subTile) {
        return this.getTextureSet(subTile.tile).getTexture(subTile.variationNumber);
    }

    public List<class_2960> getAllTextures() {
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        for (Map.Entry<class_2960, TextureSet> entry : this.textureMap.entrySet()) {
            Arrays.stream(entry.getValue().textures).forEach(iTexture -> list.add(iTexture.getTexture()));
        }
        return list;
    }
}

