/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui.core;

import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class GuiComponent
extends class_437 {
    private GuiComponent parent = null;
    private final List<GuiComponent> children = new CopyOnWriteArrayList<GuiComponent>();
    int properWidth;
    int properHeight;
    int contentWidth;
    int contentHeight;
    private boolean sizeIsInvalid = false;
    private boolean isClipped = false;
    protected boolean isMouseOver = false;
    private boolean interceptsMouse = true;
    private boolean interceptsKeyboard = true;
    private boolean blocksScreen = false;
    private int guiX = 0;
    private int guiY = 0;
    private final HoveringTextInfo hoveringTextInfo = new HoveringTextInfo();

    public GuiComponent() {
        super((class_2561)new class_2585("component"));
    }

    public void setGuiCoords(int x, int y) {
        int dx = x - this.guiX;
        int dy = y - this.guiY;
        this.guiX = x;
        this.guiY = y;
        for (GuiComponent child : this.children) {
            child.offsetGuiCoords(dx, dy);
        }
        if (this.parent != null && (dx != 0 || dy != 0)) {
            this.parent.invalidateSize();
        }
    }

    public final void setRelativeCoords(int x, int y) {
        if (this.parent != null) {
            this.setGuiCoords(this.parent.getGuiX() + x, this.parent.getGuiY() + y);
        } else {
            this.setGuiCoords(x, y);
        }
    }

    public final void setRelativeX(int x) {
        if (this.parent != null) {
            this.setGuiCoords(this.parent.getGuiX() + x, this.guiY);
        } else {
            this.setGuiCoords(x, this.guiY);
        }
    }

    public final void setRelativeY(int y) {
        if (this.parent != null) {
            this.setGuiCoords(this.guiX, this.parent.getGuiY() + y);
        } else {
            this.setGuiCoords(this.guiX, y);
        }
    }

    public final void offsetGuiCoords(int dx, int dy) {
        this.setGuiCoords(this.guiX + dx, this.guiY + dy);
    }

    protected final void setCentered() {
        this.validateSize();
        if (this.parent == null) {
            this.setGuiCoords((this.field_22789 - this.getWidth()) / 2, (this.field_22790 - this.getHeight()) / 2);
        } else {
            this.setRelativeCoords((this.parent.getWidth() - this.getWidth()) / 2, (this.parent.getHeight() - this.getHeight()) / 2);
        }
    }

    public int getGuiX() {
        return this.guiX;
    }

    public int getGuiY() {
        return this.guiY;
    }

    int getRelativeX() {
        return this.parent == null ? this.guiX : this.guiX - this.parent.guiX;
    }

    int getRelativeY() {
        return this.parent == null ? this.guiY : this.guiY - this.parent.guiY;
    }

    public void setSize(int width, int height) {
        this.properWidth = width;
        this.properHeight = height;
        this.contentWidth = width;
        this.contentHeight = height;
        this.invalidateSize();
    }

    protected GuiComponent addChild(GuiComponent child) {
        this.doAddChild(null, child, null);
        return child;
    }

    public GuiComponent addChildInfrontOf(GuiComponent inFrontOf, GuiComponent child) {
        this.doAddChild(inFrontOf, child, null);
        return child;
    }

    protected GuiComponent addChildBehind(GuiComponent behind, GuiComponent child) {
        this.doAddChild(null, child, behind);
        return child;
    }

    private void doAddChild(GuiComponent inFrontOf, GuiComponent child, GuiComponent behind) {
        if (child == null || this.children.contains((Object)child) || this.parent == child) {
            return;
        }
        int i = this.children.indexOf((Object)inFrontOf);
        if (i == -1) {
            int j = this.children.indexOf((Object)behind);
            if (j == -1) {
                this.children.add(child);
            } else {
                this.children.add(j, child);
            }
        } else {
            this.children.add(i + 1, child);
        }
        child.parent = this;
        child.setGuiCoords(this.guiX, this.guiY);
        if (class_310.method_1551() != null) {
            child.method_25423(class_310.method_1551(), this.field_22789, this.field_22790);
        }
        this.invalidateSize();
    }

    protected GuiComponent removeChild(GuiComponent child) {
        if (child != null && this.children.contains((Object)child)) {
            child.parent = null;
            this.children.remove((Object)child);
            this.invalidateSize();
            this.onChildClosed(child);
        }
        return child;
    }

    void removeAllChildren() {
        this.children.clear();
        this.invalidateSize();
    }

    public GuiComponent getParent() {
        return this.parent;
    }

    List<GuiComponent> getChildren() {
        return this.children;
    }

    public void setInterceptMouse(boolean value) {
        this.interceptsMouse = value;
    }

    protected void setInterceptKeyboard(boolean value) {
        this.interceptsKeyboard = value;
    }

    protected void setBlocksScreen(boolean value) {
        this.blocksScreen = value;
    }

    boolean iterateInput(UiCall callMethod) {
        ListIterator<GuiComponent> iter = this.children.listIterator(this.children.size());
        while (iter.hasPrevious()) {
            GuiComponent child = iter.previous();
            if (!callMethod.call(child)) continue;
            return true;
        }
        return false;
    }

    boolean iterateMouseInput(UiCall callMethod) {
        this.isMouseOver = this.isMouseInRegion(this.getGuiX(), this.getGuiY(), this.getWidth(), this.getHeight());
        if (!this.iterateInput(c -> {
            c.isMouseOver = c.isMouseInRegion(c.getGuiX(), c.getGuiY(), c.getWidth(), c.getHeight());
            return callMethod.call(c);
        })) {
            return false;
        }
        this.isMouseOver = false;
        return true;
    }

    public boolean method_25402(double mx, double my, int mb) {
        if (!this.iterateMouseInput(c -> c.method_25402(mx, my, mb))) {
            return super.method_25402(mx, my, mb);
        }
        return true;
    }

    public boolean method_25406(double mx, double my, int mb) {
        if (!this.iterateMouseInput(c -> c.method_25406(mx, my, mb))) {
            return super.method_25406(mx, my, mb);
        }
        return true;
    }

    public boolean method_25403(double mx, double my, int mb, double mx2, double my2) {
        if (!this.iterateMouseInput(c -> c.method_25403(mx, my, mb, mx2, my2))) {
            return super.method_25402(mx, my, mb);
        }
        return true;
    }

    public boolean method_25401(double mx, double my, double dy) {
        if (!this.iterateMouseInput(c -> c.method_25401(mx, my, dy))) {
            return super.method_25401(mx, my, dy);
        }
        return true;
    }

    public void method_16014(double mx, double my) {
        if (!this.iterateMouseInput(c -> {
            c.method_16014(mx, my);
            return false;
        })) {
            super.method_16014(mx, my);
        }
    }

    public boolean method_25404(int a, int b, int c) {
        if (!this.iterateInput(cpt -> cpt.method_25404(a, b, c))) {
            return super.method_25404(a, b, c);
        }
        return true;
    }

    public boolean method_25400(char aa, int bb) {
        if (!this.iterateInput(cpt -> cpt.method_25400(aa, bb))) {
            return super.method_25400(aa, bb);
        }
        return true;
    }

    public boolean method_16803(int a, int b, int c) {
        if (!this.iterateInput(cpt -> cpt.method_16803(a, b, c))) {
            return super.method_16803(a, b, c);
        }
        return true;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float partialTick) {
        super.method_25394(matrices, mouseX, mouseY, partialTick);
        for (GuiComponent child : this.children) {
            if (child.isClipped) continue;
            child.method_25394(matrices, mouseX, mouseY, partialTick);
        }
        if (this.hoveringTextInfo.shouldDraw) {
            this.drawHoveringText2(matrices, this.hoveringTextInfo.lines, this.hoveringTextInfo.x, this.hoveringTextInfo.y, this.hoveringTextInfo.font);
            this.hoveringTextInfo.shouldDraw = false;
        }
    }

    public void method_25419() {
        for (GuiComponent child : this.children) {
            child.method_25419();
        }
        super.method_25419();
    }

    public void method_25393() {
        for (GuiComponent child : this.children) {
            child.method_25393();
        }
        super.method_25393();
        if (this.sizeIsInvalid) {
            this.validateSize();
        }
    }

    public void method_25426() {
        super.method_25426();
        for (GuiComponent child : this.children) {
            child.method_25423(this.field_22787, this.field_22789, this.field_22790);
        }
    }

    protected int getWidth() {
        return this.contentWidth;
    }

    protected int getHeight() {
        return this.contentHeight;
    }

    void setClipped(boolean value) {
        this.isClipped = value;
    }

    private void invalidateSize() {
        this.sizeIsInvalid = true;
        if (this.parent != null) {
            this.parent.invalidateSize();
        }
    }

    void validateSize() {
        int leftmost = Integer.MAX_VALUE;
        int rightmost = Integer.MIN_VALUE;
        int topmost = Integer.MAX_VALUE;
        int bottommost = Integer.MIN_VALUE;
        for (GuiComponent child : this.children) {
            int childHeight;
            int y;
            int childWidth;
            int x = child.getGuiX();
            if (x < leftmost) {
                leftmost = x;
            }
            if (x + (childWidth = child.getWidth()) > rightmost) {
                rightmost = x + childWidth;
            }
            if ((y = child.getGuiY()) < topmost) {
                topmost = y;
            }
            if (y + (childHeight = child.getHeight()) <= bottommost) continue;
            bottommost = y + childHeight;
        }
        this.contentWidth = Math.max(this.properWidth, rightmost - leftmost);
        this.contentHeight = Math.max(this.properHeight, bottommost - topmost);
        this.sizeIsInvalid = false;
    }

    boolean isMouseInRegion(int left, int top, int width, int height) {
        double mouseX = this.getMouseX();
        double mouseY = this.getMouseY();
        return mouseX >= (double)left && mouseX < (double)(left + width) && mouseY >= (double)top && mouseY < (double)(top + height);
    }

    protected boolean isMouseInRadius(int x, int y, int radius) {
        double mouseX = this.getMouseX();
        double mouseY = this.getMouseY();
        return mouseX >= (double)(x - radius) && mouseX < (double)(x + radius) && mouseY >= (double)(y - radius) && mouseY < (double)(y + radius);
    }

    private void drawHoveringText2(class_4587 matrices, List<class_2561> lines, double x, double y, class_327 font) {
        boolean stencilEnabled = GL11.glIsEnabled((int)2960);
        if (stencilEnabled) {
            GL11.glDisable((int)2960);
        }
        class_327 old = this.field_22793;
        this.field_22793 = font;
        this.method_30901(matrices, lines, (int)x, (int)y);
        this.field_22793 = old;
        if (stencilEnabled) {
            GL11.glEnable((int)2960);
        }
    }

    private GuiComponent getTopLevelParent() {
        GuiComponent component = this;
        while (component.parent != null) {
            component = component.parent;
        }
        return component;
    }

    protected void drawTooltip(List<class_2561> lines, class_327 font) {
        GuiComponent topLevel = this.getTopLevelParent();
        topLevel.hoveringTextInfo.lines = lines;
        topLevel.hoveringTextInfo.x = this.getMouseX();
        topLevel.hoveringTextInfo.y = this.getMouseY();
        topLevel.hoveringTextInfo.font = font;
        topLevel.hoveringTextInfo.shouldDraw = true;
    }

    public void closeChild() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        } else {
            class_310.method_1551().method_1507(null);
        }
    }

    protected void onChildClosed(GuiComponent child) {
    }

    protected void drawCentered(class_4587 matrices, class_2561 text, int y, int color, boolean dropShadow) {
        int length = this.field_22793.method_27525((class_5348)text);
        if (dropShadow) {
            this.field_22793.method_30881(matrices, text, (float)(this.field_22789 - length) / 2.0f, (float)y, color);
        } else {
            this.field_22793.method_30883(matrices, text, (float)(this.field_22789 - length) / 2.0f, (float)y, color);
        }
    }

    protected double getMouseX() {
        return class_310.method_1551().field_1729.method_1603() * (double)this.field_22789 / (double)class_310.method_1551().method_22683().method_4480();
    }

    protected double getMouseY() {
        return class_310.method_1551().field_1729.method_1604() * (double)this.field_22790 / (double)class_310.method_1551().method_22683().method_4507();
    }

    private static class HoveringTextInfo {
        List<class_2561> lines;
        double x;
        double y;
        class_327 font;
        boolean shouldDraw = false;

        private HoveringTextInfo() {
        }
    }

    @FunctionalInterface
    static interface UiCall {
        public boolean call(GuiComponent var1);
    }
}

