/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.marker;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.registry.MarkerType;
import hunternif.mc.impl.atlas.resource.ResourceReloadListener;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

@Environment(value=EnvType.CLIENT)
public class MarkerTextureConfig
implements ResourceReloadListener<Map<class_2960, MarkerType>> {
    public static final class_2960 ID = AntiqueAtlasMod.id("markers");
    private static final int VERSION = 1;
    private static final JsonParser parser = new JsonParser();

    @Override
    public CompletableFuture<Map<class_2960, MarkerType>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<class_2960, MarkerType> typeMap = new HashMap<class_2960, MarkerType>();
            for (class_2960 id : manager.method_14488("atlas/markers", s -> s.endsWith(".json"))) {
                class_2960 markerId = new class_2960(id.method_12836(), id.method_12832().replace("atlas/markers/", "").replace(".json", ""));
                try {
                    class_3298 resource = manager.method_14486(id);
                    InputStream stream = resource.method_14482();
                    try (InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject object = parser.parse((Reader)reader).getAsJsonObject();
                        int version = object.getAsJsonPrimitive("version").getAsInt();
                        if (version != 1) {
                            throw new RuntimeException("Incompatible version (1 != " + version + ")");
                        }
                        MarkerType markerType = new MarkerType(markerId);
                        markerType.getJSONData().readFrom(object);
                        markerType.setIsFromJson(true);
                        typeMap.put(markerId, markerType);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    AntiqueAtlasMod.LOG.warn("Error reading marker " + markerId + "!", (Throwable)e);
                }
            }
            return typeMap;
        }, executor);
    }

    @Override
    public CompletableFuture<Void> apply(Map<class_2960, MarkerType> data, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (Map.Entry entry : data.entrySet()) {
                MarkerType.register((class_2960)entry.getKey(), (MarkerType)entry.getValue());
            }
        }, executor);
    }

    @Override
    public String method_22322() {
        return ID.toString();
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public Collection<class_2960> getDependencies() {
        return Collections.emptyList();
    }
}

