/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.marker;

import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.MarkersData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public class MarkersDataHandler {
    private static final String MARKERS_DATA_PREFIX = "aaMarkers_";
    private final Map<String, MarkersData> markersDataClientCache = new ConcurrentHashMap<String, MarkersData>();

    public MarkersData getMarkersData(class_1799 stack, class_1937 world) {
        if (stack.method_7909() instanceof AtlasItem) {
            return this.getMarkersData(AtlasItem.getAtlasID(stack), world);
        }
        return null;
    }

    public MarkersData getMarkersData(int atlasID, class_1937 world) {
        if (world == null) {
            return null;
        }
        String key = this.getMarkersDataKey(atlasID);
        if (world.field_9236) {
            return this.markersDataClientCache.computeIfAbsent(key + world.method_27983(), s -> new MarkersData());
        }
        class_26 manager = ((class_3218)world).method_17983();
        return (MarkersData)manager.method_17924(MarkersData::fromNbt, MarkersData::new, key);
    }

    public MarkersData getMarkersDataCached(int atlasID, class_5321<class_1937> world) {
        String key = this.getMarkersDataKey(atlasID);
        return this.markersDataClientCache.computeIfAbsent(key + world, s -> new MarkersData());
    }

    private String getMarkersDataKey(int atlasID) {
        return MARKERS_DATA_PREFIX + atlasID;
    }

    public void onClientConnectedToServer(boolean ignoredIsRemote) {
        this.markersDataClientCache.clear();
    }
}

