/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import dev.architectury.networking.NetworkManager;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileGroup;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.network.packet.s2c.S2CPacket;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class TileGroupsS2CPacket
extends S2CPacket {
    public static final int TILE_GROUPS_PER_PACKET = 100;
    public static final class_2960 ID = AntiqueAtlasMod.id("packet", "s2c", "tile", "groups");

    public TileGroupsS2CPacket(int atlasID, class_5321<class_1937> world, List<TileGroup> tileGroups) {
        this.method_10804(atlasID);
        this.method_10812(world.method_29177());
        this.method_10804(tileGroups.size());
        for (TileGroup tileGroup : tileGroups) {
            this.method_10794(tileGroup.writeToNBT(new class_2487()));
        }
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Environment(value=EnvType.CLIENT)
    public static void apply(class_2540 buf, NetworkManager.PacketContext context) {
        int atlasID = buf.method_10816();
        class_5321 world = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)buf.method_10810());
        int length = buf.method_10816();
        ArrayList<TileGroup> tileGroups = new ArrayList<TileGroup>(length);
        for (int i = 0; i < length; ++i) {
            class_2487 tag = buf.method_10798();
            if (tag == null) continue;
            tileGroups.add(TileGroup.fromNBT(tag));
        }
        context.queue(() -> {
            AtlasData atlasData = AntiqueAtlasMod.tileData.getData(atlasID, context.getPlayer().method_5770());
            WorldData worldData = atlasData.getWorldData((class_5321<class_1937>)world);
            for (TileGroup t : tileGroups) {
                worldData.putTileGroup(t);
            }
        });
    }
}

