/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Lifecycle;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.client.texture.Texture;
import hunternif.mc.impl.atlas.registry.MarkerRenderInfo;
import hunternif.mc.impl.atlas.util.BitMatrix;
import hunternif.mc.impl.atlas.util.Log;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.OptionalInt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1060;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_5321;
import org.apache.commons.io.IOUtils;

public class MarkerType {
    public static final class_5321<class_2378<MarkerType>> KEY = class_5321.method_29180((class_2960)AntiqueAtlasMod.id("marker"));
    public static final class_2348<MarkerType> REGISTRY = new class_2348(AntiqueAtlasMod.id("red_x_small").toString(), KEY, Lifecycle.experimental(), null);
    private class_2960[] icons;
    private BitMatrix[] iconPixels;
    private int[] iconSizes = null;
    private int viewSize = 2;
    private int clipMin = -1000;
    private int clipMax = 1000;
    private boolean alwaysShow = false;
    private boolean isTile = false;
    private boolean isTechnical = false;
    private double centerX = 0.5;
    private double centerY = 0.5;
    private boolean isFromJson = false;
    private final JSONData data = new JSONData(this);
    private int iconIndex = 0;

    public MarkerType(class_2960 ... icons) {
        this.icons = icons;
    }

    public static void register(class_2960 location, MarkerType type) {
        type.initMips();
        if (REGISTRY.method_10250(location)) {
            int id = REGISTRY.method_10206((Object)((MarkerType)REGISTRY.method_10223(location)));
            REGISTRY.method_31062(OptionalInt.of(id), class_5321.method_29179(KEY, (class_2960)location), (Object)type, Lifecycle.stable());
        } else {
            REGISTRY.method_10272(class_5321.method_29179(KEY, (class_2960)location), (Object)type, Lifecycle.stable());
        }
    }

    public boolean isTechnical() {
        return this.isTechnical;
    }

    public boolean shouldHide(boolean isHidingMarkers, int scaleIndex) {
        return this.shouldClip(scaleIndex) || !this.alwaysShow && isHidingMarkers;
    }

    private boolean shouldClip(int scaleIndex) {
        return scaleIndex < this.clipMin || scaleIndex > this.clipMax;
    }

    public boolean shouldHover(double x, double y) {
        if (this.isTechnical() || x > 1.0 || x < 0.0 || y > 1.0 || y < 0.0) {
            return false;
        }
        if (this.iconPixels == null || this.iconPixels.length == 0 || this.iconIndex < 0) {
            return true;
        }
        int iconX = (int)((double)this.iconPixels[this.iconIndex].getWidth() * x);
        int iconY = (int)((double)this.iconPixels[this.iconIndex].getHeight() * y);
        return this.iconPixels[this.iconIndex].get(iconX, iconY);
    }

    private int viewSize() {
        return this.viewSize;
    }

    private boolean isTile() {
        return this.isTile;
    }

    private double getCenterX() {
        return this.centerX;
    }

    private double getCenterY() {
        return this.centerY;
    }

    public class_2960 getIcon() {
        return this.icons.length == 0 || this.iconIndex < 0 ? class_1060.field_5285 : this.icons[this.iconIndex];
    }

    public ITexture getTexture() {
        if (this.icons.length == 0 || this.iconIndex < 0) {
            return null;
        }
        return new Texture(this.getIcon(), this.iconSizes[this.iconIndex], this.iconSizes[this.iconIndex]);
    }

    public class_2960[] getAllIcons() {
        return this.icons;
    }

    public void calculateMip(double scale, double mapScale, double screenScale) {
        int size = (int)(16.0 * scale * (double)this.viewSize());
        if (this.isTile) {
            size = (int)((double)size * mapScale);
        }
        if (this.icons.length > 1) {
            int smallestSide = size;
            int closestValue = Integer.MAX_VALUE;
            int closestIndex = -1;
            for (int i = 0; i < this.iconSizes.length; ++i) {
                if (this.iconSizes[i] >= closestValue || this.iconSizes[i] < smallestSide) continue;
                closestValue = this.iconSizes[i];
                closestIndex = i;
            }
            if (closestIndex > 0) {
                this.iconIndex = closestIndex;
            }
        }
    }

    public void resetMip() {
        this.iconIndex = 0;
    }

    public MarkerRenderInfo getRenderInfo(double scale, double mapScale, double screenScale) {
        boolean isTile = this.isTile();
        int size = (int)(16.0 * scale * (double)this.viewSize());
        if (isTile) {
            size = (int)((double)size * mapScale);
        }
        int x = -((int)((double)size * this.getCenterX()));
        int y = -((int)((double)size * this.getCenterY()));
        return new MarkerRenderInfo(this.getTexture(), x, y, size, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Environment(value=EnvType.CLIENT)
    public void initMips() {
        this.iconSizes = new int[this.icons.length];
        this.iconPixels = new BitMatrix[this.icons.length];
        int ALPHA_THRESHOLD = 8;
        for (int i = 0; i < this.icons.length; ++i) {
            class_3298 iresource;
            block9: {
                this.iconSizes[i] = -1;
                if (this.icons[i] == null) {
                    Log.warn("Marker %s -- Texture location is null at index %d!", REGISTRY.method_10221((Object)this).toString(), i);
                }
                iresource = null;
                class_1011 bufferedimage = null;
                try {
                    iresource = class_310.method_1551().method_1478().method_14486(this.icons[i]);
                    bufferedimage = class_1011.method_4309((InputStream)iresource.method_14482());
                    this.iconSizes[i] = Math.min(bufferedimage.method_4307(), bufferedimage.method_4323());
                    BitMatrix matrix = new BitMatrix(bufferedimage.method_4307(), bufferedimage.method_4323(), false);
                    for (int x = 0; x < bufferedimage.method_4307(); ++x) {
                        for (int y = 0; y < bufferedimage.method_4323(); ++y) {
                            int color = bufferedimage.method_4315(x, y);
                            int alpha = color >> 24 & 0xFF;
                            if (alpha < ALPHA_THRESHOLD) continue;
                            matrix.set(x, y, true);
                            matrix.set(x - 1, y, true);
                            matrix.set(x + 1, y, true);
                            matrix.set(x, y - 1, true);
                            matrix.set(x, y + 1, true);
                            matrix.set(x + 1, y + 1, true);
                            matrix.set(x - 1, y - 1, true);
                            matrix.set(x + 1, y - 1, true);
                            matrix.set(x - 1, y + 1, true);
                        }
                    }
                    this.iconPixels[i] = matrix;
                    if (bufferedimage == null) break block9;
                }
                catch (IOException e) {
                    block10: {
                        try {
                            Log.warn(e, "Marker %s -- Error getting texture size data for index %d - %s", REGISTRY.method_10221((Object)this).toString(), i, this.icons[i].toString());
                            if (bufferedimage == null) break block10;
                        }
                        catch (Throwable throwable) {
                            if (bufferedimage != null) {
                                bufferedimage.close();
                            }
                            IOUtils.closeQuietly(iresource);
                            throw throwable;
                        }
                        bufferedimage.close();
                    }
                    IOUtils.closeQuietly((Closeable)iresource);
                    continue;
                }
                bufferedimage.close();
            }
            IOUtils.closeQuietly((Closeable)iresource);
            continue;
        }
    }

    public MarkerType setSize(int value) {
        this.viewSize = value;
        return this;
    }

    public MarkerType setIsTile(boolean value) {
        this.isTile = value;
        return this;
    }

    public MarkerType setAlwaysShow(boolean value) {
        this.alwaysShow = value;
        return this;
    }

    public MarkerType setClip(int min, int max) {
        this.clipMin = Math.min(min, max);
        this.clipMax = Math.max(min, max);
        return this;
    }

    public MarkerType setCenter(double x, double y) {
        this.centerX = x;
        this.centerY = y;
        return this;
    }

    public MarkerType setIsTechnical(boolean value) {
        this.isTechnical = value;
        return this;
    }

    public MarkerType setIsFromJson(boolean value) {
        this.isFromJson = value;
        return this;
    }

    public JSONData getJSONData() {
        return this.data;
    }

    public static class JSONData {
        static final String ICONS = "textures";
        static final String SIZE = "size";
        static final String CLIP_MIN = "clipMin";
        static final String CLIP_MAX = "clipMax";
        static final String ALWAYS_SHOW = "alwaysShow";
        static final String IS_TILE = "isTile";
        static final String IS_TECH = "isTechnical";
        static final String CENTER_X = "centerX";
        static final String CENTER_Y = "centerY";
        static final String NONE = "NONE";
        private final MarkerType type;
        class_2960[] icons;
        Integer viewSize = null;
        Integer clipMin = null;
        Integer clipMax = null;
        Boolean alwaysShow = null;
        Boolean isTile = null;
        Boolean isTechnical = null;
        Double centerX = null;
        Double centerY = null;

        JSONData(MarkerType type) {
            this.type = type;
        }

        public void saveTo(JsonObject object) {
            if (this.icons != null) {
                JsonArray arr = new JsonArray();
                for (class_2960 loc : this.icons) {
                    arr.add((JsonElement)new JsonPrimitive(loc.toString()));
                }
                object.add(ICONS, (JsonElement)arr);
            }
            if (this.viewSize != null) {
                object.addProperty(SIZE, (Number)this.viewSize);
            }
            if (this.clipMin != null) {
                object.addProperty(CLIP_MIN, (Number)this.clipMin);
            }
            if (this.clipMax != null) {
                object.addProperty(CLIP_MAX, (Number)this.clipMax);
            }
            if (this.alwaysShow != null) {
                object.addProperty(ALWAYS_SHOW, this.alwaysShow);
            }
            if (this.isTile != null) {
                object.addProperty(IS_TILE, this.isTile);
            }
            if (this.isTechnical != null) {
                object.addProperty(IS_TECH, this.isTechnical);
            }
            if (this.centerX != null) {
                object.addProperty(CENTER_X, (Number)this.centerX);
            }
            if (this.centerY != null) {
                object.addProperty(CENTER_Y, (Number)this.centerY);
            }
        }

        public void readFrom(JsonObject object) {
            if (object.entrySet().size() == 0) {
                return;
            }
            class_2960 typeName = REGISTRY.method_10221((Object)this.type);
            String workingOn = NONE;
            try {
                if (object.has(ICONS) && object.get(ICONS).isJsonArray()) {
                    workingOn = ICONS;
                    ArrayList<class_2960> list = new ArrayList<class_2960>();
                    int i = 0;
                    for (JsonElement elem : object.get(ICONS).getAsJsonArray()) {
                        if (elem.isJsonPrimitive()) {
                            list.add(AntiqueAtlasMod.id(elem.getAsString()));
                        } else {
                            Log.warn("Loading marker %s from JSON: Texture item %d isn't a primitive", typeName, i);
                        }
                        ++i;
                    }
                    this.icons = list.toArray(new class_2960[0]);
                    workingOn = NONE;
                }
                if (object.has(SIZE) && object.get(SIZE).isJsonPrimitive()) {
                    workingOn = SIZE;
                    this.viewSize = object.get(SIZE).getAsInt();
                    workingOn = NONE;
                }
                if (object.has(CLIP_MIN) && object.get(CLIP_MIN).isJsonPrimitive()) {
                    workingOn = CLIP_MIN;
                    this.clipMin = object.get(CLIP_MIN).getAsInt();
                    workingOn = NONE;
                }
                if (object.has(CLIP_MAX) && object.get(CLIP_MAX).isJsonPrimitive()) {
                    workingOn = CLIP_MAX;
                    this.clipMax = object.get(CLIP_MAX).getAsInt();
                    workingOn = NONE;
                }
                if (object.has(ALWAYS_SHOW) && object.get(ALWAYS_SHOW).isJsonPrimitive()) {
                    workingOn = ALWAYS_SHOW;
                    this.alwaysShow = object.get(ALWAYS_SHOW).getAsBoolean();
                    workingOn = NONE;
                }
                if (object.has(IS_TILE) && object.get(IS_TILE).isJsonPrimitive()) {
                    workingOn = IS_TILE;
                    this.isTile = object.get(IS_TILE).getAsBoolean();
                    workingOn = NONE;
                }
                if (object.has(IS_TECH) && object.get(IS_TECH).isJsonPrimitive()) {
                    workingOn = IS_TECH;
                    this.isTechnical = object.get(IS_TECH).getAsBoolean();
                    workingOn = NONE;
                }
                if (object.has(CENTER_X) && object.get(CENTER_X).isJsonPrimitive()) {
                    workingOn = CENTER_X;
                    this.centerX = object.get(CENTER_X).getAsDouble();
                    workingOn = NONE;
                }
                if (object.has(CENTER_Y) && object.get(CENTER_Y).isJsonPrimitive()) {
                    workingOn = CENTER_Y;
                    this.centerY = object.get(CENTER_Y).getAsDouble();
                    workingOn = NONE;
                }
            }
            catch (ClassCastException e) {
                Log.warn(e, "Loading marker $s from JSON: Parsing element %s: element was wrong type!", typeName, workingOn);
            }
            catch (NumberFormatException e) {
                Log.warn(e, "Loading marker $s from JSON: Parsing element %s: element was an invalid number!", typeName, workingOn);
            }
            if (this.icons != null) {
                this.type.icons = this.icons;
            }
            if (this.viewSize != null) {
                this.type.viewSize = this.viewSize;
            }
            if (this.clipMin != null) {
                this.type.clipMin = this.clipMin;
            }
            if (this.clipMax != null) {
                this.type.clipMax = this.clipMax;
            }
            if (this.alwaysShow != null) {
                this.type.alwaysShow = this.alwaysShow;
            }
            if (this.isTile != null) {
                this.type.isTile = this.isTile;
            }
            if (this.isTechnical != null) {
                this.type.isTechnical = this.isTechnical;
            }
            if (this.centerX != null) {
                this.type.centerX = this.centerX;
            }
            if (this.centerY != null) {
                this.type.centerY = this.centerY;
            }
        }
    }
}

