/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.structure;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.resource.ResourceReloadListener;
import hunternif.mc.impl.atlas.structure.StructureHandler;
import hunternif.mc.impl.atlas.structure.StructurePieceTile;
import hunternif.mc.impl.atlas.structure.StructurePieceTileXZ;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

public class JigsawConfig
implements ResourceReloadListener<Map<class_2960, StructurePieceTile>> {
    private static final class_2960 ID = AntiqueAtlasMod.id("structures");
    public static final Map<class_2960, StructurePieceTile> PIECES = new ConcurrentHashMap<class_2960, StructurePieceTile>();

    private static JsonObject readResource(class_3300 manager, class_2960 id) throws IOException {
        class_3298 resource = manager.method_14486(id);
        try (InputStream stream = resource.method_14482();){
            JsonObject jsonObject;
            try (InputStreamReader reader = new InputStreamReader(stream);){
                jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            return jsonObject;
        }
    }

    private static StructurePieceTile parseJson(JsonObject json) {
        int version = json.getAsJsonPrimitive("version").getAsInt();
        if (version == 1) {
            return new StructurePieceTile(class_2960.method_12829((String)json.get("tile").getAsString()), json.get("priority").getAsInt());
        }
        if (version == 2) {
            return new StructurePieceTileXZ(class_2960.method_12829((String)json.get("tile_x").getAsString()), class_2960.method_12829((String)json.get("tile_z").getAsString()), json.get("priority").getAsInt());
        }
        throw new RuntimeException("Unsupported JSON version: " + version + ". Only version 1 is supported.");
    }

    @Override
    public CompletableFuture<Map<class_2960, StructurePieceTile>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<class_2960, StructurePieceTile> pieces = new HashMap<class_2960, StructurePieceTile>();
            try {
                for (class_2960 id : manager.method_14488("atlas/structures", s -> s.endsWith(".json"))) {
                    AntiqueAtlasMod.LOG.info("Found structure piece config: " + id);
                    try {
                        class_2960 piece_id = new class_2960(id.method_12836(), id.method_12832().replace("atlas/structures/", "").replace(".json", ""));
                        JsonObject json = JigsawConfig.readResource(manager, id);
                        pieces.put(piece_id, JigsawConfig.parseJson(json));
                    }
                    catch (Exception e) {
                        AntiqueAtlasMod.LOG.warn("Error reading structure piece config from " + id, (Throwable)e);
                    }
                }
            }
            catch (Throwable e) {
                AntiqueAtlasMod.LOG.warn("Failed to read structure piece mapping from data pack!", e);
            }
            return pieces;
        }, executor);
    }

    @Override
    public CompletableFuture<Void> apply(Map<class_2960, StructurePieceTile> pieces, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> pieces.forEach((id, piece) -> {
            AntiqueAtlasMod.LOG.info("Apply structure piece config: " + id);
            if (piece instanceof StructurePieceTileXZ) {
                StructureHandler.registerJigsawTile(id, piece.getPriority(), piece.getTileX(), StructureHandler::IF_X_DIRECTION);
                StructureHandler.registerJigsawTile(id, piece.getPriority(), piece.getTileZ(), StructureHandler::IF_Z_DIRECTION);
            } else {
                StructureHandler.registerJigsawTile(id, piece.getPriority(), piece.getTile());
            }
        }), executor);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public Collection<class_2960> getDependencies() {
        return Collections.emptyList();
    }
}

