/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas;

import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.KeyHandler;
import hunternif.mc.impl.atlas.client.TextureConfig;
import hunternif.mc.impl.atlas.client.TextureSetConfig;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.TileTextureConfig;
import hunternif.mc.impl.atlas.client.TileTextureMap;
import hunternif.mc.impl.atlas.marker.MarkerTextureConfig;
import hunternif.mc.impl.atlas.registry.MarkerType;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
implements PreparableReloadListener {
    public void initClient() {
        TextureConfig textureConfig = new TextureConfig(Textures.TILE_TEXTURES_MAP);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)textureConfig, (ResourceLocation)textureConfig.getId(), textureConfig.getDependencies());
        TextureSetMap textureSetMap = TextureSetMap.instance();
        TextureSetConfig textureSetConfig = new TextureSetConfig(textureSetMap);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)textureSetConfig, (ResourceLocation)textureSetConfig.getId(), textureSetConfig.getDependencies());
        TileTextureMap tileTextureMap = TileTextureMap.instance();
        TileTextureConfig tileTextureConfig = new TileTextureConfig(tileTextureMap, textureSetMap);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)tileTextureConfig, (ResourceLocation)tileTextureConfig.getId(), tileTextureConfig.getDependencies());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)this);
        MarkerTextureConfig markerTextureConfig = new MarkerTextureConfig();
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)markerTextureConfig, (ResourceLocation)markerTextureConfig.getId(), markerTextureConfig.getDependencies());
        for (MarkerType type : MarkerType.REGISTRY) {
            type.initMips();
        }
        if (!AntiqueAtlasMod.CONFIG.itemNeeded) {
            KeyHandler.registerBindings();
            ClientTickEvent.CLIENT_POST.register(KeyHandler::onClientTick);
        }
    }

    public static void assignCustomBiomeTextures(ClientLevel world) {
        ResourceLocation id;
        for (Map.Entry biome : BuiltinRegistries.f_123865_.m_6579_()) {
            id = BuiltinRegistries.f_123865_.m_7981_((Object)((Biome)biome.getValue()));
            if (TileTextureMap.instance().isRegistered(id)) continue;
            TileTextureMap.instance().autoRegister(id, (ResourceKey<Biome>)((ResourceKey)biome.getKey()));
        }
        for (Map.Entry entry : world.m_5962_().m_175515_(Registry.f_122885_).m_6579_()) {
            id = world.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)((Biome)entry.getValue()));
            if (TileTextureMap.instance().isRegistered(id)) continue;
            TileTextureMap.instance().autoRegister(id, (ResourceKey<Biome>)((ResourceKey)entry.getKey()));
        }
    }

    public String m_7812_() {
        return AntiqueAtlasMod.id("proxy").toString();
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier synchronizer, ResourceManager manager, ProfilerFiller prepareProfiler, ProfilerFiller applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        return ((CompletableFuture)CompletableFuture.completedFuture(null).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)synchronizer).m_6769_(arg_0))).thenCompose(t -> CompletableFuture.runAsync(() -> {
            for (MarkerType type : MarkerType.REGISTRY) {
                type.initMips();
            }
        }, applyExecutor));
    }
}

