/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.TextureConfig;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.resource.ResourceReloadListener;
import hunternif.mc.impl.atlas.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextureSetConfig
implements ResourceReloadListener<Collection<TextureSet>> {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("texture_sets");
    private static final int VERSION = 1;
    private static final JsonParser PARSER = new JsonParser();
    private final TextureSetMap textureSetMap;

    public TextureSetConfig(TextureSetMap textureSetMap) {
        this.textureSetMap = textureSetMap;
    }

    @Override
    public CompletableFuture<Collection<TextureSet>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, TextureSet> sets = new HashMap<ResourceLocation, TextureSet>();
            try {
                for (ResourceLocation id : manager.m_6540_("atlas/texture_sets", s -> s.endsWith(".json"))) {
                    ResourceLocation texture_id = new ResourceLocation(id.m_135827_(), id.m_135815_().replace("atlas/texture_sets/", "").replace(".json", ""));
                    try {
                        Resource resource = manager.m_142591_(id);
                        InputStream stream = resource.m_6679_();
                        try (InputStreamReader reader = new InputStreamReader(stream);){
                            TextureSet set;
                            JsonObject object = PARSER.parse((Reader)reader).getAsJsonObject();
                            int version = object.getAsJsonPrimitive("version").getAsInt();
                            if (version != 1) {
                                AntiqueAtlasMod.LOG.warn("The TextureSet " + texture_id + " is in the wrong version! Skipping.");
                                continue;
                            }
                            JsonObject data = object.getAsJsonObject("data");
                            ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
                            for (Map.Entry entry2 : data.getAsJsonObject("textures").entrySet()) {
                                for (int i = 0; i < ((JsonElement)entry2.getValue()).getAsInt(); ++i) {
                                    textures.add(new ResourceLocation((String)entry2.getKey()));
                                }
                            }
                            ResourceLocation[] textureArray = new ResourceLocation[textures.size()];
                            if (!data.has("shore")) {
                                set = new TextureSet(texture_id, textures.toArray(textureArray));
                            } else {
                                JsonObject shore = data.getAsJsonObject("shore");
                                if (!shore.has("water")) {
                                    throw new RuntimeException("The `shore` entry is missing a water entry.");
                                }
                                set = new TextureSet.TextureSetShore(texture_id, new ResourceLocation(shore.get("water").getAsString()), textures.toArray(textureArray));
                            }
                            if (data.has("stitch")) {
                                data.getAsJsonObject("stitch").entrySet().forEach(entry -> {
                                    String to;
                                    switch (to = ((JsonElement)entry.getValue()).getAsString()) {
                                        case "both": {
                                            set.stitchTo(new ResourceLocation((String)entry.getKey()));
                                            break;
                                        }
                                        case "horizontal": {
                                            set.stitchToHorizontal(new ResourceLocation((String)entry.getKey()));
                                            break;
                                        }
                                        case "vertical": {
                                            set.stitchToVertical(new ResourceLocation((String)entry.getKey()));
                                            break;
                                        }
                                        default: {
                                            throw new RuntimeException("Invalid stitch value (" + to + ") for `" + (String)entry.getKey() + "`");
                                        }
                                    }
                                });
                            }
                            sets.put(texture_id, set);
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        AntiqueAtlasMod.LOG.warn("Error reading TextureSet " + texture_id + "!", (Throwable)e);
                    }
                }
            }
            catch (Throwable e) {
                Log.warn(e, "Failed to read texture sets!", new Object[0]);
            }
            return sets.values();
        }, executor);
    }

    @Override
    public CompletableFuture<Void> apply(Collection<TextureSet> sets, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (TextureSet set : sets) {
                try {
                    set.loadTextures();
                    this.textureSetMap.register(set);
                    if (!AntiqueAtlasMod.CONFIG.resourcePackLogging) continue;
                    Log.info("Loaded texture set %s with %d custom texture(s)", set.name, set.getTexturePaths().length);
                }
                catch (Throwable e) {
                    Log.error(e, "Failed to load the texture set `%s`:", set.name);
                }
            }
            for (TextureSet set : sets) {
                set.checkStitching();
                if (!(set instanceof TextureSet.TextureSetShore)) continue;
                TextureSet.TextureSetShore texture = (TextureSet.TextureSetShore)set;
                texture.loadWater();
                if (!AntiqueAtlasMod.CONFIG.resourcePackLogging) continue;
                Log.info("Loaded water texture `%s` for shore texture `%s` texture", texture.waterName, texture.name);
            }
        }, executor);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        return Collections.singleton(TextureConfig.ID);
    }
}

