/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import dev.architectury.injectables.annotations.ExpectPlatform;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.forge.TileTextureMapImpl;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.core.scaning.TileHeightType;
import hunternif.mc.impl.atlas.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileTextureMap {
    private static final TileTextureMap INSTANCE = new TileTextureMap();
    public static final ResourceLocation DEFAULT_TEXTURE = AntiqueAtlasMod.id("test");
    private final Map<ResourceLocation, TextureSet> textureMap = new HashMap<ResourceLocation, TextureSet>();

    public static TileTextureMap instance() {
        return INSTANCE;
    }

    public void setTexture(ResourceLocation tileId, TextureSet textureSet) {
        if (tileId == null) {
            return;
        }
        if (textureSet == null) {
            if (this.textureMap.remove(tileId) != null) {
                Log.warn("Removing old texture for %d", tileId);
            }
            return;
        }
        this.textureMap.put(tileId, textureSet);
    }

    public void setAllTextures(ResourceLocation tileId, TextureSet textureSet) {
        this.setTexture(tileId, textureSet);
        for (TileHeightType layer : TileHeightType.values()) {
            this.setTexture(ResourceLocation.m_135820_((String)(tileId + "_" + layer)), textureSet);
        }
    }

    public TextureSet getDefaultTexture() {
        return TextureSetMap.instance().getByName(DEFAULT_TEXTURE);
    }

    public void autoRegister(ResourceLocation id, ResourceKey<Biome> biome) {
        if (biome == null || id == null) {
            Log.error("Given biome is null. Cannot autodetect a suitable texture set for that.", new Object[0]);
            return;
        }
        Optional<ResourceLocation> texture_set = TileTextureMap.guessFittingTextureSet(biome);
        if (texture_set.isPresent()) {
            this.setAllTextures(id, TextureSetMap.instance().getByName(texture_set.get()));
            Log.info("Auto-registered standard texture set for biome %s: %s", id, texture_set.get());
        } else {
            Log.error("Failed to auto-register a standard texture set for the biome '%s'. This is most likely caused by errors in the TextureSet configurations, check your resource packs first before reporting it as an issue!", id.toString());
            this.setAllTextures(id, this.getDefaultTexture());
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Optional<ResourceLocation> guessFittingTextureSet(ResourceKey<Biome> biome) {
        return TileTextureMapImpl.guessFittingTextureSet(biome);
    }

    public static Optional<ResourceLocation> guessFittingTextureSetFallback(Biome biome) {
        ResourceLocation texture_set = switch (biome.m_47567_()) {
            default -> throw new IncompatibleClassChangeError();
            case Biome.BiomeCategory.SWAMP -> AntiqueAtlasMod.id("swamp");
            case Biome.BiomeCategory.OCEAN, Biome.BiomeCategory.RIVER -> {
                if (biome.m_47530_() == Biome.Precipitation.SNOW) {
                    yield AntiqueAtlasMod.id("ice");
                }
                yield AntiqueAtlasMod.id("water");
            }
            case Biome.BiomeCategory.BEACH -> AntiqueAtlasMod.id("shore");
            case Biome.BiomeCategory.JUNGLE -> AntiqueAtlasMod.id("jungle");
            case Biome.BiomeCategory.SAVANNA -> AntiqueAtlasMod.id("savanna");
            case Biome.BiomeCategory.MESA -> AntiqueAtlasMod.id("plateau_mesa");
            case Biome.BiomeCategory.FOREST -> {
                if (biome.m_47530_() == Biome.Precipitation.SNOW) {
                    yield AntiqueAtlasMod.id("snow_pines");
                }
                yield AntiqueAtlasMod.id("forest");
            }
            case Biome.BiomeCategory.PLAINS -> {
                if (biome.m_47530_() == Biome.Precipitation.SNOW) {
                    yield AntiqueAtlasMod.id("snow");
                }
                yield AntiqueAtlasMod.id("plains");
            }
            case Biome.BiomeCategory.ICY -> AntiqueAtlasMod.id("ice_spikes");
            case Biome.BiomeCategory.DESERT -> AntiqueAtlasMod.id("desert");
            case Biome.BiomeCategory.TAIGA -> AntiqueAtlasMod.id("snow");
            case Biome.BiomeCategory.EXTREME_HILLS -> AntiqueAtlasMod.id("hills");
            case Biome.BiomeCategory.MOUNTAIN -> AntiqueAtlasMod.id("mountains");
            case Biome.BiomeCategory.THEEND -> {
                List features = biome.m_47536_().m_47818_();
                PlacedFeature chorus_plant_feature = (PlacedFeature)BuiltinRegistries.f_194653_.m_7745_(new ResourceLocation("chorus_plant"));
                if (!$assertionsDisabled && chorus_plant_feature == null) {
                    throw new AssertionError();
                }
                boolean has_chorus_plant = features.stream().anyMatch(entries -> entries.m_203614_().anyMatch(feature -> feature.m_203334_() == chorus_plant_feature));
                if (has_chorus_plant) {
                    yield AntiqueAtlasMod.id("end_island_plants");
                }
                yield AntiqueAtlasMod.id("end_island");
            }
            case Biome.BiomeCategory.MUSHROOM -> AntiqueAtlasMod.id("mushroom");
            case Biome.BiomeCategory.NETHER -> AntiqueAtlasMod.id("soul_sand_valley");
            case Biome.BiomeCategory.NONE -> AntiqueAtlasMod.id("end_void");
            case Biome.BiomeCategory.UNDERGROUND -> {
                Log.warn("Underground biomes aren't supported yet.", new Object[0]);
                yield null;
            }
        };
        return Optional.ofNullable(texture_set);
    }

    public boolean isRegistered(ResourceLocation id) {
        return this.textureMap.containsKey(id);
    }

    public TextureSet getTextureSet(ResourceLocation tile) {
        if (tile == null) {
            return this.getDefaultTexture();
        }
        return this.textureMap.getOrDefault(tile, this.getDefaultTexture());
    }

    public ITexture getTexture(SubTile subTile) {
        return this.getTextureSet(subTile.tile).getTexture(subTile.variationNumber);
    }

    public List<ResourceLocation> getAllTextures() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, TextureSet> entry : this.textureMap.entrySet()) {
            Arrays.stream(entry.getValue().textures).forEach(iTexture -> list.add(iTexture.getTexture()));
        }
        return list;
    }
}

