/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import hunternif.mc.api.client.AtlasClientAPI;
import hunternif.mc.impl.atlas.client.gui.GuiMarkerInList;
import hunternif.mc.impl.atlas.client.gui.core.GuiComponent;
import hunternif.mc.impl.atlas.client.gui.core.GuiScrollingContainer;
import hunternif.mc.impl.atlas.client.gui.core.ToggleGroup;
import hunternif.mc.impl.atlas.registry.MarkerType;
import hunternif.mc.impl.atlas.util.Log;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiMarkerFinalizer
extends GuiComponent {
    private Level world;
    private int atlasID;
    private int markerX;
    private int markerZ;
    MarkerType selectedType = (MarkerType)MarkerType.REGISTRY.m_7745_(MarkerType.REGISTRY.m_122315_());
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_SPACING = 4;
    private static final int TYPE_SPACING = 1;
    private static final int TYPE_BG_FRAME = 4;
    private Button btnDone;
    private Button btnCancel;
    private EditBox textField;
    private GuiScrollingContainer scroller;
    private ToggleGroup<GuiMarkerInList> typeRadioGroup;
    private final List<IMarkerTypeSelectListener> markerListeners = new ArrayList<IMarkerTypeSelectListener>();

    GuiMarkerFinalizer() {
    }

    void setMarkerData(Level world, int atlasID, int markerX, int markerZ) {
        this.world = world;
        this.atlasID = atlasID;
        this.markerX = markerX;
        this.markerZ = markerZ;
        this.setBlocksScreen(true);
    }

    void addMarkerListener(IMarkerTypeSelectListener listener) {
        this.markerListeners.add(listener);
    }

    void removeMarkerListener(IMarkerTypeSelectListener listener) {
        this.markerListeners.remove(listener);
    }

    void removeAllMarkerListeners() {
        this.markerListeners.clear();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.btnDone = new Button(this.f_96543_ / 2 - 100 - 2, this.f_96544_ / 2 + 40, 100, 20, (Component)new TranslatableComponent("gui.done"), button -> {
            AtlasClientAPI.getMarkerAPI().putMarker(this.world, true, this.atlasID, MarkerType.REGISTRY.m_7981_((Object)this.selectedType), (Component)new TextComponent(this.textField.m_94155_()), this.markerX, this.markerZ);
            Log.info("Put marker in Atlas #%d \"%s\" at (%d, %d)", this.atlasID, this.textField.m_94155_(), this.markerX, this.markerZ);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            this.world.m_5594_((Player)player, player.m_142538_(), SoundEvents.f_12565_, SoundSource.AMBIENT, 1.0f, 1.0f);
            this.closeChild();
        });
        this.m_142416_((GuiEventListener)this.btnDone);
        this.btnCancel = new Button(this.f_96543_ / 2 + 2, this.f_96544_ / 2 + 40, 100, 20, (Component)new TranslatableComponent("gui.cancel"), button -> this.closeChild());
        this.m_142416_((GuiEventListener)this.btnCancel);
        this.textField = new EditBox(Minecraft.m_91087_().f_91062_, (this.f_96543_ - 200) / 2, this.f_96544_ / 2 - 81, 200, 20, (Component)new TranslatableComponent("gui.antiqueatlas.marker.label"));
        this.textField.m_94186_(true);
        this.textField.m_94144_("");
        this.scroller = new GuiScrollingContainer();
        this.scroller.setWheelScrollsHorizontally();
        this.addChild(this.scroller);
        int typeCount = 0;
        for (MarkerType type : MarkerType.REGISTRY) {
            if (type.isTechnical()) continue;
            ++typeCount;
        }
        int allTypesWidth = typeCount * 35 - 1;
        int scrollerWidth = Math.min(allTypesWidth, 240);
        this.scroller.setViewportSize(scrollerWidth, 35);
        this.scroller.setGuiCoords((this.f_96543_ - scrollerWidth) / 2, this.f_96544_ / 2 - 25);
        this.typeRadioGroup = new ToggleGroup();
        this.typeRadioGroup.addListener(button -> {
            this.selectedType = button.getMarkerType();
            for (IMarkerTypeSelectListener listener : this.markerListeners) {
                listener.onSelectMarkerType(button.getMarkerType());
            }
        });
        int contentX = 0;
        for (MarkerType markerType : MarkerType.REGISTRY) {
            if (markerType.isTechnical()) continue;
            GuiMarkerInList markerGui = new GuiMarkerInList(markerType);
            this.typeRadioGroup.addButton(markerGui);
            if (this.selectedType.equals(markerType)) {
                this.typeRadioGroup.setSelectedButton(markerGui);
            }
            this.scroller.addContent(markerGui).setRelativeX(contentX);
            contentX += 35;
        }
    }

    public void setMarkerName(Component name) {
        this.textField.m_94144_(name.m_6111_());
    }

    @Override
    public void closeChild() {
        super.closeChild();
        if (this.scroller != null) {
            this.scroller.closeChild();
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button) || this.textField.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_7933_(int aa, int bb, int cc) {
        return super.m_7933_(aa, bb, cc) || this.textField.m_7933_(aa, bb, cc);
    }

    @Override
    public boolean m_5534_(char aa, int bb) {
        return super.m_5534_(aa, bb) || this.textField.m_5534_(aa, bb);
    }

    @Override
    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(matrices);
        this.drawCentered(matrices, (Component)new TranslatableComponent("gui.antiqueatlas.marker.label"), this.f_96544_ / 2 - 97, 0xFFFFFF, true);
        this.textField.m_6305_(matrices, mouseX, mouseY, partialTick);
        this.drawCentered(matrices, (Component)new TranslatableComponent("gui.antiqueatlas.marker.type"), this.f_96544_ / 2 - 44, 0xFFFFFF, true);
        this.m_93179_(matrices, this.scroller.getGuiX() - 4, this.scroller.getGuiY() - 4, this.scroller.getGuiX() + this.scroller.getWidth() + 4, this.scroller.getGuiY() + this.scroller.getHeight() + 4, -2012213232, -1727000560);
        super.m_6305_(matrices, mouseX, mouseY, partialTick);
    }

    static interface IMarkerTypeSelectListener {
        public void onSelectMarkerType(MarkerType var1);
    }
}

