/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core.scaning;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.TileIdMap;
import hunternif.mc.impl.atlas.core.scaning.ITileDetector;
import hunternif.mc.impl.atlas.core.scaning.TileHeightType;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;

public class TileDetectorBase
implements ITileDetector {
    private static final ResourceLocation waterPoolBiome = Biomes.f_48208_.m_135782_();
    private static final int priorityRavine = 12;
    private static final int priorityWaterPool = 4;
    private static final int priorityLavaPool = 6;
    private static final int ravineMinDepth = 7;
    private static final Set<ResourceLocation> waterBiomes = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> beachBiomes = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> swampBiomes = new HashSet<ResourceLocation>();

    public static void scanBiomeTypes() {
        for (Biome biome : BuiltinRegistries.f_123865_) {
            switch (biome.m_47567_()) {
                case BEACH: {
                    beachBiomes.add(BuiltinRegistries.f_123865_.m_7981_((Object)biome));
                    break;
                }
                case RIVER: 
                case OCEAN: {
                    waterBiomes.add(BuiltinRegistries.f_123865_.m_7981_((Object)biome));
                    break;
                }
                case SWAMP: {
                    swampBiomes.add(BuiltinRegistries.f_123865_.m_7981_((Object)biome));
                }
            }
        }
    }

    int priorityForBiome(ResourceLocation biome) {
        if (waterBiomes.contains(biome)) {
            return 4;
        }
        if (beachBiomes.contains(biome)) {
            return 3;
        }
        return 1;
    }

    protected static TileHeightType getHeightTypeFromY(int y, int sealevel) {
        if (y < sealevel + 10) {
            return TileHeightType.VALLEY;
        }
        if (y < sealevel + 20) {
            return TileHeightType.LOW;
        }
        if (y < sealevel + 35) {
            return TileHeightType.MID;
        }
        if (y < sealevel + 50) {
            return TileHeightType.HIGH;
        }
        return TileHeightType.PEAK;
    }

    protected static ResourceLocation getBiomeIdentifier(Level world, Biome biome) {
        return world.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)biome);
    }

    protected static void updateOccurrencesMap(Map<ResourceLocation, Integer> map, ResourceLocation biome, int weight) {
        int occurrence = map.getOrDefault(biome, 0) + weight;
        map.put(biome, occurrence);
    }

    protected static void updateOccurrencesMap(Map<ResourceLocation, Integer> map, Level world, Biome biome, TileHeightType type, int weight) {
        ResourceLocation id = TileDetectorBase.getBiomeIdentifier(world, biome);
        id = ResourceLocation.m_135820_((String)(id.toString() + "_" + type.getName()));
        int occurrence = map.getOrDefault(id, 0) + weight;
        map.put(id, occurrence);
    }

    @Override
    public int getScanRadius() {
        return AntiqueAtlasMod.CONFIG.scanRadius;
    }

    @Override
    public ResourceLocation getBiomeID(Level world, ChunkAccess chunk) {
        HashMap<ResourceLocation, Integer> biomeOccurrences = new HashMap<ResourceLocation, Integer>(BuiltinRegistries.f_123865_.m_6566_().size());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Biome biome = (Biome)chunk.m_203495_(x, world.m_5736_(), z).m_203334_();
                int y = chunk.m_6005_(Heightmap.Types.MOTION_BLOCKING).m_64242_(x, z);
                if (AntiqueAtlasMod.CONFIG.doScanPonds && y > 0) {
                    Block topBlock = chunk.m_8055_(new BlockPos(x, y - 1, z)).m_60734_();
                    if (topBlock == Blocks.f_49990_) {
                        if (swampBiomes.contains(TileDetectorBase.getBiomeIdentifier(world, biome))) {
                            TileDetectorBase.updateOccurrencesMap(biomeOccurrences, TileIdMap.SWAMP_WATER, 4);
                        } else {
                            TileDetectorBase.updateOccurrencesMap(biomeOccurrences, waterPoolBiome, 4);
                        }
                    } else if (topBlock == Blocks.f_49991_) {
                        TileDetectorBase.updateOccurrencesMap(biomeOccurrences, TileIdMap.TILE_LAVA, 6);
                    }
                }
                if (AntiqueAtlasMod.CONFIG.doScanRavines && y > 0 && y < world.m_5736_() - 7) {
                    TileDetectorBase.updateOccurrencesMap(biomeOccurrences, TileIdMap.TILE_RAVINE, 12);
                }
                TileDetectorBase.updateOccurrencesMap(biomeOccurrences, world, biome, TileDetectorBase.getHeightTypeFromY(y, world.m_5736_()), this.priorityForBiome(TileDetectorBase.getBiomeIdentifier(world, biome)));
            }
        }
        if (biomeOccurrences.isEmpty()) {
            return null;
        }
        Map.Entry meanBiome = Collections.max(biomeOccurrences.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
        return (ResourceLocation)meanBiome.getKey();
    }
}

