/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.marker;

import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.util.ListMapValueIterator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class DimensionMarkersData {
    private final MarkersData parent;
    private final ResourceKey<Level> world;
    private int size = 0;
    private final Map<ChunkPos, List<Marker>> chunkMap = new ConcurrentHashMap<ChunkPos, List<Marker>>(2, 0.75f, 2);
    private final Values values = new Values();

    public DimensionMarkersData(MarkersData parent, ResourceKey<Level> world) {
        this.parent = parent;
        this.world = world;
    }

    public ResourceKey<Level> getWorld() {
        return this.world;
    }

    public List<Marker> getMarkersAtChunk(int x, int z) {
        return this.chunkMap.get(new ChunkPos(x, z));
    }

    public void insertMarker(Marker marker) {
        ChunkPos key = new ChunkPos(marker.getChunkX() / 8, marker.getChunkZ() / 8);
        List<Marker> list = this.chunkMap.get(key);
        if (list == null) {
            list = new CopyOnWriteArrayList<Marker>();
            this.chunkMap.put(key, list);
        }
        boolean inserted = false;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getZ() <= marker.getZ()) continue;
            list.add(i, marker);
            inserted = true;
            break;
        }
        if (!inserted) {
            list.add(marker);
        }
        ++this.size;
        this.parent.m_77762_();
    }

    public boolean removeMarker(Marker marker) {
        --this.size;
        return this.getMarkersAtChunk(marker.getChunkX() / 8, marker.getChunkZ() / 8).remove(marker);
    }

    public Collection<Marker> getAllMarkers() {
        return this.values;
    }

    private class Values
    extends AbstractCollection<Marker> {
        private Values() {
        }

        @Override
        public Iterator<Marker> iterator() {
            return new ListMapValueIterator<Marker>(DimensionMarkersData.this.chunkMap).setImmutable(true);
        }

        @Override
        public int size() {
            return DimensionMarkersData.this.size;
        }
    }
}

