/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.marker;

import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.DimensionMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.mixinhooks.EntityHooksAA;
import hunternif.mc.impl.atlas.registry.MarkerType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;

public class NetherPortalWatcher {
    private final Map<Integer, DimensionType> teleportingPlayersOrigin = new ConcurrentHashMap<Integer, DimensionType>();

    private void addPortalMarkerIfNone(Player player) {
        if (!AntiqueAtlasMod.CONFIG.autoNetherPortalMarkers || player.m_20193_().f_46443_) {
            return;
        }
        Level world = player.m_20193_();
        if (!AntiqueAtlasMod.CONFIG.itemNeeded) {
            this.addPortalMarkerIfNone(player, world, player.m_142081_().hashCode());
            return;
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack == null || !(stack.m_41720_() instanceof AtlasItem)) continue;
            this.addPortalMarkerIfNone(player, world, AtlasItem.getAtlasID(stack));
        }
    }

    private void addPortalMarkerIfNone(Player player, Level world, int atlasID) {
        int z;
        int x;
        MarkerType netherPortalType = (MarkerType)MarkerType.REGISTRY.m_7745_(AntiqueAtlasMod.id("nether_portal"));
        if (netherPortalType == null) {
            return;
        }
        DimensionMarkersData data = AntiqueAtlasMod.markersData.getMarkersData(atlasID, world).getMarkersDataInWorld((ResourceKey<Level>)world.m_46472_());
        List<Marker> markers = data.getMarkersAtChunk(((x = (int)player.m_20185_()) >> 4) / 8, ((z = (int)player.m_20189_()) >> 4) / 8);
        if (markers != null) {
            for (Marker marker : markers) {
                if (!marker.getType().equals((Object)"antiqueatlas:nether_portal")) continue;
                return;
            }
        }
        AtlasAPI.getMarkerAPI().putMarker(world, false, atlasID, MarkerType.REGISTRY.m_7981_((Object)netherPortalType), (Component)new TranslatableComponent("gui.antiqueatlas.marker.netherPortal"), x, z);
    }

    private static boolean isEntityInPortal(Entity entity) {
        return ((EntityHooksAA)entity).antiqueAtlas_isInPortal();
    }
}

