/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import dev.architectury.networking.NetworkManager;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.AntiqueAtlasModClient;
import hunternif.mc.impl.atlas.marker.GlobalMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.network.packet.s2c.S2CPacket;
import hunternif.mc.impl.atlas.registry.MarkerType;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PutMarkersS2CPacket
extends S2CPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "s2c", "marker", "put");
    private static final int GLOBAL = -1;

    public PutMarkersS2CPacket(int atlasID, ResourceKey<Level> world, Collection<Marker> markers) {
        ArrayListMultimap markersByType = ArrayListMultimap.create();
        for (Marker marker : markers) {
            markersByType.put((Object)marker.getType(), (Object)marker);
        }
        this.m_130130_(atlasID);
        this.m_130085_(world.m_135782_());
        this.m_130130_(markersByType.keySet().size());
        for (ResourceLocation type : markersByType.keySet()) {
            this.m_130085_(type);
            List markerList = markersByType.get((Object)type);
            this.m_130130_(markerList.size());
            for (Marker marker : markerList) {
                marker.write(this);
            }
        }
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void apply(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int atlasID = buf.m_130242_();
        ResourceKey world = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_());
        int typesLength = buf.m_130242_();
        ArrayListMultimap markersByType = ArrayListMultimap.create();
        for (int i = 0; i < typesLength; ++i) {
            ResourceLocation type = buf.m_130281_();
            int markersLength = buf.m_130242_();
            for (int j = 0; j < markersLength; ++j) {
                markersByType.put((Object)type, (Object)new Marker.Precursor(buf));
            }
        }
        context.queue(() -> PutMarkersS2CPacket.lambda$apply$0(atlasID, world, (ListMultimap)markersByType));
    }

    private static /* synthetic */ void lambda$apply$0(int atlasID, ResourceKey world, ListMultimap markersByType) {
        GlobalMarkersData markersData = atlasID == -1 ? AntiqueAtlasMod.globalMarkersData.getData() : AntiqueAtlasMod.markersData.getMarkersDataCached(atlasID, (ResourceKey<Level>)world);
        for (ResourceLocation type : markersByType.keys()) {
            MarkerType markerType = (MarkerType)MarkerType.REGISTRY.m_7745_(type);
            for (Marker.Precursor precursor : markersByType.get((Object)type)) {
                ((MarkersData)markersData).loadMarker(new Marker(MarkerType.REGISTRY.m_7981_((Object)markerType), (ResourceKey<Level>)world, precursor));
            }
        }
        AntiqueAtlasModClient.getAtlasGUI().updateBookmarkerList();
    }
}

