/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas;

import hunternif.mc.atlas.CommonProxy;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.client.BiomeTextureConfig;
import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.KeyHandler;
import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.client.TextureSetConfig;
import hunternif.mc.atlas.client.TextureSetMap;
import hunternif.mc.atlas.client.gui.GuiAtlas;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.ext.ExtTileTextureConfig;
import hunternif.mc.atlas.ext.ExtTileTextureMap;
import hunternif.mc.atlas.marker.MarkerTextureConfig;
import hunternif.mc.atlas.registry.MarkerRegistry;
import hunternif.mc.atlas.registry.MarkerType;
import java.io.File;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.client.ClientTickCallback;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.api.network.PacketConsumer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_437;

public class ClientProxy
extends CommonProxy
implements SimpleSynchronousResourceReloadListener {
    private static TextureSetMap textureSetMap;
    private static TextureSetConfig textureSetConfig;
    private static BiomeTextureMap biomeTextureMap;
    private static BiomeTextureConfig biomeTextureConfig;
    private static ExtTileTextureMap tileTextureMap;
    private static ExtTileTextureConfig tileTextureConfig;
    private static MarkerTextureConfig markerTextureConfig;
    private static GuiAtlas guiAtlas;

    @Override
    public void registerPackets(Set<class_2960> clientPackets, Set<class_2960> serverPackets, Function<class_2960, PacketConsumer> consumer) {
        super.registerPackets(clientPackets, serverPackets, consumer);
        clientPackets.forEach(id -> ClientSidePacketRegistry.INSTANCE.register(id, (PacketConsumer)consumer.apply((class_2960)id)));
    }

    public void initClient() {
        textureSetMap = TextureSetMap.instance();
        textureSetConfig = new TextureSetConfig(textureSetMap);
        this.registerDefaultTextureSets(textureSetMap);
        textureSetMap.setDirty(false);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)textureSetConfig);
        File biomeTextureConfigFile = new File(configDir, "textures.json");
        if (biomeTextureConfigFile.exists()) {
            biomeTextureConfigFile.renameTo(new File(configDir, "biome_textures.json"));
        }
        tileTextureMap = ExtTileTextureMap.instance();
        tileTextureConfig = new ExtTileTextureConfig(tileTextureMap, textureSetMap);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)tileTextureConfig);
        tileTextureMap.setDirty(false);
        this.registerVanillaCustomTileTextures();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this);
        biomeTextureMap = BiomeTextureMap.instance();
        biomeTextureConfig = new BiomeTextureConfig(biomeTextureMap, textureSetMap);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)biomeTextureConfig);
        biomeTextureMap.setDirty(false);
        this.assignVanillaBiomeTextures();
        markerTextureConfig = new MarkerTextureConfig();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)markerTextureConfig);
        MarkerRegistry.INSTANCE.setDirty(true);
        for (MarkerType type : MarkerRegistry.iterable()) {
            type.initMips();
        }
        if (!SettingsConfig.gameplay.itemNeeded) {
            KeyHandler.registerBindings();
            ClientTickCallback.EVENT.register(KeyHandler::onClientTick);
        }
    }

    private GuiAtlas getAtlasGUI() {
        if (guiAtlas == null) {
            guiAtlas = new GuiAtlas();
            guiAtlas.setMapScale(SettingsConfig.userInterface.defaultScale);
        }
        return guiAtlas;
    }

    @Override
    public void openAtlasGUI(class_1799 stack) {
        this.openAtlasGUI(this.getAtlasGUI().prepareToOpen(stack));
    }

    @Override
    public void openAtlasGUI() {
        this.openAtlasGUI(this.getAtlasGUI().prepareToOpen());
    }

    private void openAtlasGUI(GuiAtlas gui) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 == null) {
            guiAtlas.updateL18n();
            mc.method_1507((class_437)gui);
        }
    }

    private void registerDefaultTextureSets(TextureSetMap map) {
        map.register(TextureSet.ICE);
        map.register(TextureSet.SHORE);
        map.register(TextureSet.ROCK_SHORE);
        map.register(TextureSet.DESERT);
        map.register(TextureSet.PLAINS);
        map.register(TextureSet.SUNFLOWERS);
        map.register(TextureSet.HILLS);
        map.register(TextureSet.DESERT_HILLS);
        map.register(TextureSet.ICE_SPIKES);
        map.register(TextureSet.SNOW_PINES);
        map.register(TextureSet.SNOW_PINES_HILLS);
        map.register(TextureSet.SNOW_HILLS);
        map.register(TextureSet.SNOW);
        map.register(TextureSet.MOUNTAINS_NAKED);
        map.register(TextureSet.MOUNTAINS);
        map.register(TextureSet.MOUNTAINS_SNOW_CAPS);
        map.register(TextureSet.MOUNTAINS_ALL);
        map.register(TextureSet.FOREST);
        map.register(TextureSet.FOREST_HILLS);
        map.register(TextureSet.FOREST_FLOWERS);
        map.register(TextureSet.DENSE_FOREST);
        map.register(TextureSet.DENSE_FOREST_HILLS);
        map.register(TextureSet.BIRCH);
        map.register(TextureSet.BIRCH_HILLS);
        map.register(TextureSet.TALL_BIRCH);
        map.register(TextureSet.TALL_BIRCH_HILLS);
        map.register(TextureSet.DENSE_BIRCH);
        map.register(TextureSet.JUNGLE);
        map.register(TextureSet.JUNGLE_HILLS);
        map.register(TextureSet.JUNGLE_CLIFFS);
        map.register(TextureSet.JUNGLE_EDGE);
        map.register(TextureSet.JUNGLE_EDGE_HILLS);
        map.register(TextureSet.PINES);
        map.register(TextureSet.PINES_HILLS);
        map.register(TextureSet.SAVANNA);
        map.register(TextureSet.SAVANNA_CLIFFS);
        map.register(TextureSet.PLATEAU_SAVANNA_M);
        map.register(TextureSet.MESA);
        map.register(TextureSet.BRYCE);
        map.register(TextureSet.PLATEAU_MESA);
        map.register(TextureSet.PLATEAU_MESA_LOW);
        map.register(TextureSet.PLATEAU_MESA_TREES);
        map.register(TextureSet.PLATEAU_MESA_TREES_LOW);
        map.register(TextureSet.PLATEAU_SAVANNA);
        map.register(TextureSet.MEGA_SPRUCE);
        map.register(TextureSet.MEGA_SPRUCE_HILLS);
        map.register(TextureSet.MEGA_TAIGA);
        map.register(TextureSet.MEGA_TAIGA_HILLS);
        map.register(TextureSet.SWAMP);
        map.register(TextureSet.SWAMP_HILLS);
        map.register(TextureSet.MUSHROOM);
        map.register(TextureSet.WATER);
        map.register(TextureSet.LAVA);
        map.register(TextureSet.LAVA_SHORE);
        map.register(TextureSet.CAVE_WALLS);
        map.register(TextureSet.RAVINE);
        map.register(TextureSet.HOUSE);
        map.register(TextureSet.FENCE);
        map.register(TextureSet.LIBRARY);
        map.register(TextureSet.L_HOUSE);
        map.register(TextureSet.SMITHY);
        map.register(TextureSet.FARMLAND_LARGE);
        map.register(TextureSet.FARMLAND_SMALL);
        map.register(TextureSet.WELL);
        map.register(TextureSet.VILLAGE_TORCH);
        map.register(TextureSet.HUT);
        map.register(TextureSet.HOUSE_SMALL);
        map.register(TextureSet.BUTCHERS_SHOP);
        map.register(TextureSet.CHURCH);
        map.register(TextureSet.NETHER_BRIDGE);
        map.register(TextureSet.NETHER_BRIDGE_X);
        map.register(TextureSet.NETHER_BRIDGE_Z);
        map.register(TextureSet.NETHER_BRIDGE_END_X);
        map.register(TextureSet.NETHER_BRIDGE_END_Z);
        map.register(TextureSet.NETHER_BRIDGE_GATE);
        map.register(TextureSet.NETHER_TOWER);
        map.register(TextureSet.NETHER_WALL);
        map.register(TextureSet.NETHER_HALL);
        map.register(TextureSet.NETHER_FORT_STAIRS);
        map.register(TextureSet.NETHER_THRONE);
        map.register(TextureSet.END_ISLAND);
        map.register(TextureSet.END_ISLAND_PLANTS);
        map.register(TextureSet.END_VOID);
    }

    private void assignVanillaBiomeTextures() {
        this.setBiomeTextureIfNone(class_1972.field_9453, TextureSet.ICE_SPIKES);
        this.setBiomeTextureIfNone(class_1972.field_9455, TextureSet.SUNFLOWERS);
        this.setBiomeTextureIfNone(class_1972.field_9478, TextureSet.SHORE);
        this.setBiomeTextureIfNone(class_1972.field_9419, TextureSet.ROCK_SHORE);
        this.setBiomeTextureIfNone(class_1972.field_9414, TextureSet.FOREST_FLOWERS);
        this.setBiomeTextureIfNone(class_1972.field_9412, TextureSet.BIRCH);
        this.setBiomeTextureIfNone(class_1972.field_9431, TextureSet.TALL_BIRCH);
        this.setBiomeTextureIfNone(class_1972.field_9421, TextureSet.BIRCH_HILLS);
        this.setBiomeTextureIfNone(class_1972.field_9458, TextureSet.TALL_BIRCH_HILLS);
        this.setBiomeTextureIfNone(class_1972.field_9417, TextureSet.JUNGLE);
        this.setBiomeTextureIfNone(class_1972.field_9432, TextureSet.JUNGLE_HILLS);
        this.setBiomeTextureIfNone(class_1972.field_9474, TextureSet.JUNGLE_EDGE);
        this.setBiomeTextureIfNone(class_1972.field_9477, TextureSet.MEGA_TAIGA);
        this.setBiomeTextureIfNone(class_1972.field_9416, TextureSet.MEGA_SPRUCE);
        this.setBiomeTextureIfNone(class_1972.field_9429, TextureSet.MEGA_TAIGA_HILLS);
        this.setBiomeTextureIfNone(class_1972.field_9404, TextureSet.MEGA_SPRUCE_HILLS);
        this.setBiomeTextureIfNone(class_1972.field_9461, TextureSet.CAVE_WALLS);
        this.setBiomeTextureIfNone(class_1972.field_9411, TextureSet.END_VOID);
        this.setBiomeTextureIfNone(class_1972.field_9462, TextureSet.MUSHROOM);
        this.setBiomeTextureIfNone(class_1972.field_9407, TextureSet.SHORE);
        for (class_1959 biome : class_2378.field_11153) {
            BiomeTextureMap.instance().checkRegistration(biome);
        }
    }

    private void setBiomeTextureIfNone(class_1959 biome, TextureSet textureSet) {
        if (!biomeTextureMap.isRegistered(biome)) {
            biomeTextureMap.setTexture(biome, textureSet);
        }
    }

    private void registerVanillaCustomTileTextures() {
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_LIBRARY, TextureSet.LIBRARY);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_SMITHY, TextureSet.SMITHY);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_L_HOUSE, TextureSet.L_HOUSE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_FARMLAND_LARGE, TextureSet.FARMLAND_LARGE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_FARMLAND_SMALL, TextureSet.FARMLAND_SMALL);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_WELL, TextureSet.WELL);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_TORCH, TextureSet.VILLAGE_TORCH);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_HUT, TextureSet.HUT);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_SMALL_HOUSE, TextureSet.HOUSE_SMALL);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_BUTCHERS_SHOP, TextureSet.BUTCHERS_SHOP);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_CHURCH, TextureSet.CHURCH);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_LAVA, TextureSet.LAVA);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_LAVA_SHORE, TextureSet.LAVA_SHORE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_NETHER_BRIDGE, TextureSet.NETHER_BRIDGE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_NETHER_BRIDGE_X, TextureSet.NETHER_BRIDGE_X);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_NETHER_BRIDGE_Z, TextureSet.NETHER_BRIDGE_Z);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_NETHER_BRIDGE_END_X, TextureSet.NETHER_BRIDGE_END_X);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_NETHER_BRIDGE_END_Z, TextureSet.NETHER_BRIDGE_END_Z);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_NETHER_BRIDGE_GATE, TextureSet.NETHER_BRIDGE_GATE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_NETHER_TOWER, TextureSet.NETHER_TOWER);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_NETHER_WALL, TextureSet.NETHER_WALL);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_NETHER_HALL, TextureSet.NETHER_HALL);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_NETHER_FORT_STAIRS, TextureSet.NETHER_FORT_STAIRS);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_NETHER_THRONE, TextureSet.NETHER_THRONE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_END_ISLAND, TextureSet.END_ISLAND);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_END_ISLAND_PLANTS, TextureSet.END_ISLAND_PLANTS);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_END_VOID, TextureSet.END_VOID);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_RAVINE, TextureSet.RAVINE);
    }

    private void setCustomTileTextureIfNone(class_2960 tileName, TextureSet textureSet) {
        if (!tileTextureMap.isRegistered(tileName)) {
            tileTextureMap.setTexture(tileName, textureSet);
        }
    }

    @Override
    public File getConfigDir() {
        return configDir;
    }

    public class_2960 getFabricId() {
        return new class_2960("antiqueatlas:proxy");
    }

    public void method_14491(class_3300 var1) {
        for (MarkerType type : MarkerRegistry.iterable()) {
            type.initMips();
        }
    }
}

