/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.api.impl;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.api.MarkerAPI;
import hunternif.mc.atlas.marker.GlobalMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.bidirectional.DeleteMarkerPacket;
import hunternif.mc.atlas.network.client.MarkersPacket;
import hunternif.mc.atlas.network.server.AddMarkerPacket;
import hunternif.mc.atlas.registry.MarkerRegistry;
import hunternif.mc.atlas.registry.MarkerType;
import hunternif.mc.atlas.util.Log;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class MarkerApiImpl
implements MarkerAPI {
    private static final int GLOBAL = -1;

    @Override
    @Nullable
    public Marker putMarker(@Nonnull class_1937 world, boolean visibleAhead, int atlasID, String markerType, String label, int x, int z) {
        return this.doPutMarker(world, visibleAhead, atlasID, markerType, label, x, z);
    }

    @Override
    @Nullable
    public Marker putGlobalMarker(@Nonnull class_1937 world, boolean visibleAhead, String markerType, String label, int x, int z) {
        return this.doPutMarker(world, visibleAhead, -1, markerType, label, x, z);
    }

    private Marker doPutMarker(class_1937 world, boolean visibleAhead, int atlasID, String markerType, String label, int x, int z) {
        Marker marker = null;
        if (world.field_9236) {
            if (atlasID == -1) {
                Log.warn("Client tried to add a global marker!", new Object[0]);
            } else {
                PacketDispatcher.sendToServer(new AddMarkerPacket(atlasID, world.field_9247.method_12460(), markerType, label, x, z, visibleAhead));
            }
        } else if (atlasID == -1) {
            GlobalMarkersData data = AntiqueAtlasMod.globalMarkersData.getData();
            marker = ((MarkersData)data).createAndSaveMarker(markerType, label, world.field_9247.method_12460(), x, z, visibleAhead);
            PacketDispatcher.sendToAll(((class_3218)world).method_8503(), new MarkersPacket(world.field_9247.method_12460(), marker));
        } else {
            MarkersData data = AntiqueAtlasMod.markersData.getMarkersData(atlasID, world);
            marker = data.createAndSaveMarker(markerType, label, world.field_9247.method_12460(), x, z, visibleAhead);
            PacketDispatcher.sendToAll(((class_3218)world).method_8503(), new MarkersPacket(atlasID, world.field_9247.method_12460(), marker));
        }
        return marker;
    }

    @Override
    public void deleteMarker(@Nonnull class_1937 world, int atlasID, int markerID) {
        this.doDeleteMarker(world, atlasID, markerID);
    }

    @Override
    public void deleteGlobalMarker(@Nonnull class_1937 world, int markerID) {
        this.doDeleteMarker(world, -1, markerID);
    }

    private void doDeleteMarker(class_1937 world, int atlasID, int markerID) {
        DeleteMarkerPacket packet;
        DeleteMarkerPacket deleteMarkerPacket = packet = atlasID == -1 ? new DeleteMarkerPacket(markerID) : new DeleteMarkerPacket(atlasID, markerID);
        if (world.field_9236) {
            if (atlasID == -1) {
                Log.warn("Client tried to delete a global marker!", new Object[0]);
            } else {
                PacketDispatcher.sendToServer(packet);
            }
        } else {
            GlobalMarkersData data = atlasID == -1 ? AntiqueAtlasMod.globalMarkersData.getData() : AntiqueAtlasMod.markersData.getMarkersData(atlasID, world);
            data.removeMarker(markerID);
            PacketDispatcher.sendToAll(((class_3218)world).method_8503(), packet);
        }
    }

    @Override
    public void registerMarker(class_2960 identifier, MarkerType markerType) {
        MarkerRegistry.register(identifier, markerType);
    }
}

