/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.api.impl;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.api.TileAPI;
import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.client.TextureSetMap;
import hunternif.mc.atlas.core.AtlasData;
import hunternif.mc.atlas.core.TileKind;
import hunternif.mc.atlas.core.TileKindFactory;
import hunternif.mc.atlas.ext.ExtBiomeData;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.ext.ExtTileTextureMap;
import hunternif.mc.atlas.ext.TileIdRegisteredCallback;
import hunternif.mc.atlas.network.AbstractMessage;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.bidirectional.PutTilePacket;
import hunternif.mc.atlas.network.client.DeleteCustomGlobalTilePacket;
import hunternif.mc.atlas.network.client.TileNameIDPacket;
import hunternif.mc.atlas.network.client.TilesPacket;
import hunternif.mc.atlas.network.server.RegisterTileIdPacket;
import hunternif.mc.atlas.util.Log;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class TileApiImpl
implements TileAPI {
    private final Map<class_2960, TileData> pendingTiles = new HashMap<class_2960, TileData>();

    public TileApiImpl() {
        TileIdRegisteredCallback.EVENT.register(this::onTileIdRegistered);
    }

    @Override
    public TextureSet registerTextureSet(class_2960 name, class_2960 ... textures) {
        TextureSet textureSet = new TextureSet(name, textures);
        TextureSetMap.instance().register(textureSet);
        return textureSet;
    }

    @Override
    public void setBiomeTexture(class_1959 biome, class_2960 textureSetName, class_2960 ... textures) {
        TextureSet set = new TextureSet(textureSetName, textures);
        TextureSetMap.instance().register(set);
        BiomeTextureMap.instance().setTexture(biome, set);
    }

    @Override
    public void setBiomeTexture(class_1959 biome, TextureSet textureSet) {
        BiomeTextureMap.instance().setTexture(biome, textureSet);
    }

    @Override
    public void setCustomTileTexture(class_2960 uniqueTileName, class_2960 ... textures) {
        TextureSet set = new TextureSet(uniqueTileName, textures);
        TextureSetMap.instance().register(set);
        this.setCustomTileTexture(uniqueTileName, set);
    }

    @Override
    public void setCustomTileTexture(class_2960 uniqueTileName, TextureSet textureSet) {
        ExtTileTextureMap.instance().setTexture(uniqueTileName, textureSet);
    }

    private void putTile(class_1937 world, int atlasID, TileKind kind, int chunkX, int chunkZ) {
        class_2874 dimension = world.field_9247.method_12460();
        PutTilePacket packet = new PutTilePacket(atlasID, dimension, chunkX, chunkZ, kind);
        if (world.field_9236) {
            PacketDispatcher.sendToServer(packet);
        } else {
            AtlasData data = AntiqueAtlasMod.atlasData.getAtlasData(atlasID, world);
            data.setTile(dimension, chunkX, chunkZ, kind);
            for (class_1657 syncedPlayer : data.getSyncedPlayers()) {
                PacketDispatcher.sendTo(new PutTilePacket(atlasID, dimension, chunkX, chunkZ, kind), (class_3222)syncedPlayer);
            }
        }
    }

    @Override
    public void putBiomeTile(class_1937 world, int atlasID, class_1959 biome, int chunkX, int chunkZ) {
        this.putTile(world, atlasID, TileKindFactory.get(biome), chunkX, chunkZ);
    }

    @Override
    public void putCustomTile(class_1937 world, int atlasID, class_2960 tileName, int chunkX, int chunkZ) {
        if (tileName == null) {
            Log.error("Attempted to put custom tile with null name", new Object[0]);
            return;
        }
        if (world.field_9236) {
            int biomeID = ExtTileIdMap.instance().getPseudoBiomeID(tileName);
            if (biomeID != -1) {
                this.putTile(world, atlasID, TileKindFactory.get(tileName), chunkX, chunkZ);
            } else {
                this.pendingTiles.put(tileName, new TileData(world, atlasID, chunkX, chunkZ));
                PacketDispatcher.sendToServer(new RegisterTileIdPacket(tileName));
            }
        } else {
            int biomeID = ExtTileIdMap.instance().getPseudoBiomeID(tileName);
            if (biomeID == -1) {
                biomeID = ExtTileIdMap.instance().getOrCreatePseudoBiomeID(tileName);
                TileNameIDPacket packet = new TileNameIDPacket();
                packet.put(tileName, biomeID);
                PacketDispatcher.sendToAll(((class_3218)world).method_8503(), packet);
            }
            this.putTile(world, atlasID, TileKindFactory.get(biomeID), chunkX, chunkZ);
        }
    }

    @Override
    public void putCustomGlobalTile(class_1937 world, class_2960 tileName, int chunkX, int chunkZ) {
        AbstractMessage.AbstractClientMessage packet;
        if (tileName == null) {
            Log.error("Attempted to put custom global tile with null name", new Object[0]);
            return;
        }
        if (world.field_9236) {
            Log.warn("Client attempted to put global tile", new Object[0]);
            return;
        }
        boolean isIdRegistered = ExtTileIdMap.instance().getPseudoBiomeID(tileName) != -1;
        int biomeID = ExtTileIdMap.instance().getOrCreatePseudoBiomeID(tileName);
        ExtBiomeData data = AntiqueAtlasMod.extBiomeData.getData();
        data.setBiomeAt(world.field_9247.method_12460(), chunkX, chunkZ, biomeID);
        if (!isIdRegistered) {
            packet = new TileNameIDPacket();
            ((TileNameIDPacket)packet).put(tileName, biomeID);
            PacketDispatcher.sendToAll(((class_3218)world).method_8503(), packet);
        }
        packet = new TilesPacket(world.field_9247.method_12460());
        ((TilesPacket)packet).addTile(chunkX, chunkZ, biomeID);
        PacketDispatcher.sendToAll(((class_3218)world).method_8503(), packet);
    }

    public void onTileIdRegistered(Map<class_2960, Integer> nameToIdMap) {
        for (Map.Entry<class_2960, Integer> entry : nameToIdMap.entrySet()) {
            TileData tile = this.pendingTiles.remove(entry.getKey());
            if (tile == null) continue;
            this.putBiomeTile(tile.world, tile.atlasID, TileKindFactory.get(entry.getValue()).getBiome(), tile.x, tile.z);
        }
    }

    @Override
    public void deleteCustomGlobalTile(class_1937 world, int chunkX, int chunkZ) {
        class_2874 dimension;
        if (world.field_9236) {
            Log.warn("Client attempted to delete global tile", new Object[0]);
            return;
        }
        ExtBiomeData data = AntiqueAtlasMod.extBiomeData.getData();
        if (data.getBiomeAt(dimension = world.field_9247.method_12460(), chunkX, chunkZ) != -1) {
            data.removeBiomeAt(dimension, chunkX, chunkZ);
            PacketDispatcher.sendToAll(((class_3218)world).method_8503(), new DeleteCustomGlobalTilePacket(dimension, chunkX, chunkZ));
        }
    }

    private static class TileData {
        final class_1937 world;
        final int atlasID;
        final int x;
        final int z;

        TileData(class_1937 world, int atlasID, int x, int z) {
            this.world = world;
            this.atlasID = atlasID;
            this.x = x;
            this.z = z;
        }
    }
}

