/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client;

import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.core.TileKind;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.SaveData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class BiomeTextureMap
extends SaveData {
    private static final BiomeTextureMap INSTANCE = new BiomeTextureMap();
    final Map<class_1959, TextureSet> biomeTextureMap = new HashMap<class_1959, TextureSet>();
    final Map<Integer, TextureSet> pseudoBiomeTextureMap = new HashMap<Integer, TextureSet>();
    public static final TextureSet defaultTexture = TextureSet.PLAINS;

    public static BiomeTextureMap instance() {
        return INSTANCE;
    }

    public void setTexture(class_1959 biome, TextureSet textureSet) {
        Log.info("Register texture set %s for biome %s", textureSet.name, biome.method_8689());
        if (textureSet == null) {
            if (this.biomeTextureMap.remove(biome) != null) {
                Log.warn("Removing old texture for biome %s", class_2378.field_11153.method_10221((Object)biome));
            }
            return;
        }
        TextureSet previous = this.biomeTextureMap.put(biome, textureSet);
        if (previous == null) {
            this.markDirty();
        } else if (!previous.equals(textureSet)) {
            Log.warn("Overwriting texture set for biome %s", class_2378.field_11153.method_10221((Object)biome));
            this.markDirty();
        }
    }

    public void setTexture(int pseudoID, TextureSet textureSet) {
        if (textureSet == null) {
            if (this.pseudoBiomeTextureMap.remove(pseudoID) != null) {
                Log.warn("Removing old texture for pseudo-biome %d", pseudoID);
            }
            return;
        }
        TextureSet previous = this.pseudoBiomeTextureMap.put(pseudoID, textureSet);
        if (previous == null) {
            this.markDirty();
        } else if (!previous.equals(textureSet)) {
            Log.warn("Overwriting texture set for pseudo-biome %d", pseudoID);
            this.markDirty();
        }
    }

    private void autoRegister(class_1959 biome) {
        if (biome == null) {
            Log.warn("Biome is null", new Object[0]);
            return;
        }
        switch (biome.method_8688()) {
            case field_9364: {
                this.setTexture(biome, biome.method_8686() >= 0.25f ? TextureSet.SWAMP_HILLS : TextureSet.SWAMP);
                break;
            }
            case field_9367: 
            case field_9369: {
                this.setTexture(biome, biome.method_8694() == class_1959.class_1963.field_9383 ? TextureSet.ICE : TextureSet.WATER);
                break;
            }
            case field_9363: {
                this.setTexture(biome, TextureSet.SHORE);
                break;
            }
            case field_9358: {
                this.setTexture(biome, biome.method_8686() >= 0.25f ? TextureSet.JUNGLE_HILLS : TextureSet.JUNGLE);
                break;
            }
            case field_9356: {
                this.setTexture(biome, biome.method_8695() >= 1.0f ? TextureSet.PLATEAU_SAVANNA : TextureSet.SAVANNA);
                break;
            }
            case field_9354: {
                this.setTexture(biome, TextureSet.PLATEAU_MESA);
                break;
            }
            case field_9370: {
                this.setTexture(biome, biome.method_8694() == class_1959.class_1963.field_9383 ? (biome.method_8686() >= 0.25f ? TextureSet.SNOW_PINES_HILLS : TextureSet.SNOW_PINES) : (biome.method_8686() >= 0.25f ? TextureSet.FOREST_HILLS : TextureSet.FOREST));
                break;
            }
            case field_9355: {
                this.setTexture(biome, biome.method_8694() == class_1959.class_1963.field_9383 ? (biome.method_8686() >= 0.25f ? TextureSet.SNOW_HILLS : TextureSet.SNOW) : (biome.method_8686() >= 0.25f ? TextureSet.HILLS : TextureSet.PLAINS));
                break;
            }
            case field_9362: {
                this.setTexture(biome, biome.method_8686() >= 0.25f ? TextureSet.MOUNTAINS_SNOW_CAPS : TextureSet.ICE_SPIKES);
                break;
            }
            case field_9368: {
                this.setTexture(biome, biome.method_8686() >= 0.25f ? TextureSet.DESERT_HILLS : TextureSet.DESERT);
                break;
            }
            case field_9361: {
                this.setTexture(biome, TextureSet.SNOW);
                break;
            }
            case field_9357: {
                this.setTexture(biome, biome.method_8686() >= 0.25f ? TextureSet.MOUNTAINS : TextureSet.HILLS);
                break;
            }
            case field_9360: {
                boolean[] hasPlants = new boolean[]{false};
                Stream.of(biome.method_8721(class_2893.class_2895.field_13178)).forEach(feature -> {
                    if (!feature.isEmpty()) {
                        hasPlants[0] = true;
                    }
                });
                if (hasPlants[0]) {
                    this.setTexture(biome, TextureSet.END_ISLAND_PLANTS);
                    break;
                }
                this.setTexture(biome, TextureSet.END_ISLAND);
                break;
            }
            case field_9371: {
                this.setTexture(biome, TextureSet.END_VOID);
                break;
            }
            default: {
                this.setTexture(biome, defaultTexture);
            }
        }
        Log.info("Auto-registered standard texture set for biome %s", class_2378.field_11153.method_10221((Object)biome).toString());
    }

    public void checkRegistration(class_1959 biome) {
        if (!this.isRegistered(biome)) {
            this.autoRegister(biome);
            this.markDirty();
        }
    }

    private void checkRegistration(int pseudoID) {
        if (!this.isRegistered(pseudoID)) {
            this.setTexture(pseudoID, defaultTexture);
        }
    }

    public boolean isRegistered(class_1959 biome) {
        return this.biomeTextureMap.containsKey(biome);
    }

    public boolean isRegistered(int pseudoID) {
        return this.pseudoBiomeTextureMap.containsKey(pseudoID);
    }

    public TextureSet getTextureSet(TileKind tile) {
        if (tile == null) {
            return defaultTexture;
        }
        class_1959 biome = tile.getBiome();
        if (biome != null) {
            this.checkRegistration(biome);
            return this.biomeTextureMap.getOrDefault(biome, defaultTexture);
        }
        this.checkRegistration(tile.getId());
        return this.pseudoBiomeTextureMap.get(tile.getId());
    }

    public class_2960 getTexture(int variationNumber, TileKind tile) {
        TextureSet set = this.getTextureSet(tile);
        return set.textures[variationNumber % set.textures.length];
    }

    public List<class_2960> getAllTextures() {
        ArrayList<class_2960> list = new ArrayList<class_2960>(this.biomeTextureMap.size());
        for (Map.Entry<class_1959, TextureSet> entry : this.biomeTextureMap.entrySet()) {
            list.addAll(Arrays.asList(entry.getValue().textures));
        }
        for (Map.Entry<Object, TextureSet> entry : this.pseudoBiomeTextureMap.entrySet()) {
            list.addAll(Arrays.asList(entry.getValue().textures));
        }
        return list;
    }
}

