/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client;

import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.util.SaveData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class TextureSetMap
extends SaveData {
    private static final TextureSetMap INSTANCE = new TextureSetMap();
    private final Map<class_2960, TextureSet> map = new HashMap<class_2960, TextureSet>();

    public static TextureSetMap instance() {
        return INSTANCE;
    }

    public void register(TextureSet set) {
        TextureSet old = this.map.put(set.name, set);
        if (!set.equals(old)) {
            this.markDirty();
        }
    }

    public TextureSet getByName(class_2960 name) {
        return this.map.get(name);
    }

    public TextureSet getByNameNonNull(class_2960 name) {
        TextureSet set = this.getByName(name);
        return set == null ? TextureSet.TEST : set;
    }

    public boolean isRegistered(String name) {
        return this.map.containsKey(name);
    }

    public Collection<TextureSet> getAllTextureSets() {
        return this.map.values();
    }

    Collection<TextureSet> getAllNonStandardTextureSets() {
        ArrayList<TextureSet> list = new ArrayList<TextureSet>(this.map.size());
        for (TextureSet set : this.map.values()) {
            if (set.isStandard) continue;
            list.add(set);
        }
        return list;
    }
}

