/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client.gui;

import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.client.gui.GuiMarkerInList;
import hunternif.mc.atlas.client.gui.core.GuiComponent;
import hunternif.mc.atlas.client.gui.core.GuiScrollingContainer;
import hunternif.mc.atlas.client.gui.core.ToggleGroup;
import hunternif.mc.atlas.registry.MarkerRegistry;
import hunternif.mc.atlas.registry.MarkerType;
import hunternif.mc.atlas.util.Log;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;

public class GuiMarkerFinalizer
extends GuiComponent {
    private class_1937 world;
    private int atlasID;
    private class_2874 dimension;
    private int markerX;
    private int markerZ;
    MarkerType selectedType = MarkerRegistry.findDefault();
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_SPACING = 4;
    private static final int TYPE_SPACING = 1;
    private static final int TYPE_BG_FRAME = 4;
    private class_4185 btnDone;
    private class_4185 btnCancel;
    private class_342 textField;
    private final GuiScrollingContainer scroller;
    private ToggleGroup<GuiMarkerInList> typeRadioGroup;
    private final List<IMarkerTypeSelectListener> markerListeners = new ArrayList<IMarkerTypeSelectListener>();

    GuiMarkerFinalizer() {
        this.scroller = new GuiScrollingContainer();
        this.scroller.setWheelScrollsHorizontally();
        this.addChild(this.scroller);
    }

    void setMarkerData(class_1937 world, int atlasID, class_2874 dimension, int markerX, int markerZ) {
        this.world = world;
        this.atlasID = atlasID;
        this.dimension = dimension;
        this.markerX = markerX;
        this.markerZ = markerZ;
        this.setBlocksScreen(true);
    }

    void addMarkerListener(IMarkerTypeSelectListener listener) {
        this.markerListeners.add(listener);
    }

    void removeMarkerListener(IMarkerTypeSelectListener listener) {
        this.markerListeners.remove(listener);
    }

    void removeAllMarkerListeners() {
        this.markerListeners.clear();
    }

    protected void init() {
        super.init();
        this.btnDone = new class_4185(this.width / 2 - 100 - 2, this.height / 2 + 40, 100, 20, class_1074.method_4662((String)"gui.done", (Object[])new Object[0]), button -> {
            AtlasAPI.markers.putMarker(this.world, true, this.atlasID, MarkerRegistry.getId(this.selectedType).toString(), this.textField.method_1882(), this.markerX, this.markerZ);
            Log.info("Put marker in Atlas #%d \"%s\" at (%d, %d)", this.atlasID, this.textField.method_1882(), this.markerX, this.markerZ);
            this.close();
        });
        this.addButton((class_339)this.btnDone);
        this.btnCancel = new class_4185(this.width / 2 + 2, this.height / 2 + 40, 100, 20, class_1074.method_4662((String)"gui.cancel", (Object[])new Object[0]), button -> this.close());
        this.addButton((class_339)this.btnCancel);
        this.textField = new class_342(class_310.method_1551().field_1772, (this.width - 200) / 2, this.height / 2 - 81, 200, 20, class_1074.method_4662((String)"gui.antiqueatlas.marker.label", (Object[])new Object[0]));
        this.textField.method_1888(true);
        this.textField.method_1852("");
        this.scroller.removeAllContent();
        int typeCount = 0;
        for (MarkerType type : MarkerRegistry.iterable()) {
            if (type.isTechnical()) continue;
            ++typeCount;
        }
        int allTypesWidth = typeCount * 35 - 1;
        int scrollerWidth = Math.min(allTypesWidth, 240);
        this.scroller.setViewportSize(scrollerWidth, 34);
        this.scroller.setGuiCoords((this.width - scrollerWidth) / 2, this.height / 2 - 25);
        this.typeRadioGroup = new ToggleGroup();
        this.typeRadioGroup.addListener(button -> {
            this.selectedType = button.getMarkerType();
            for (IMarkerTypeSelectListener listener : this.markerListeners) {
                listener.onSelectMarkerType(button.getMarkerType());
            }
        });
        int contentX = 0;
        for (MarkerType markerType : MarkerRegistry.iterable()) {
            if (markerType.isTechnical()) continue;
            GuiMarkerInList markerGui = new GuiMarkerInList(markerType);
            this.typeRadioGroup.addButton(markerGui);
            if (this.selectedType.equals(markerType)) {
                this.typeRadioGroup.setSelectedButton(markerGui);
            }
            this.scroller.addContent(markerGui).setRelativeX(contentX);
            contentX += 35;
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button) || this.textField.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean keyPressed(int aa, int bb, int cc) {
        return super.keyPressed(aa, bb, cc) || this.textField.keyPressed(aa, bb, cc);
    }

    @Override
    public boolean charTyped(char aa, int bb) {
        return super.charTyped(aa, bb) || this.textField.charTyped(aa, bb);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        this.renderBackground();
        this.drawCenteredString(class_1074.method_4662((String)"gui.antiqueatlas.marker.label", (Object[])new Object[0]), this.height / 2 - 97, 0xFFFFFF, true);
        this.textField.render(mouseX, mouseY, partialTick);
        this.drawCenteredString(class_1074.method_4662((String)"gui.antiqueatlas.marker.type", (Object[])new Object[0]), this.height / 2 - 44, 0xFFFFFF, true);
        this.fillGradient(this.scroller.getGuiX() - 4, this.scroller.getGuiY() - 4, this.scroller.getGuiX() + this.scroller.getWidth() + 4, this.scroller.getGuiY() + this.scroller.getHeight() + 4, -2012213232, -1727000560);
        super.render(mouseX, mouseY, partialTick);
    }

    static interface IMarkerTypeSelectListener {
        public void onSelectMarkerType(MarkerType var1);
    }
}

