/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.core.IBiomeDetector;
import hunternif.mc.atlas.core.TileKind;
import hunternif.mc.atlas.core.TileKindFactory;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_4548;

public class BiomeDetectorBase
implements IBiomeDetector {
    private boolean doScanPonds = true;
    private boolean doScanRavines = true;
    private static final class_1959 waterPoolBiome = class_1972.field_9438;
    private static final int priorityRavine = 12;
    private static final int priorityWaterPool = 4;
    private static final int prioritylavaPool = 6;
    private static final int ravineMinDepth = 7;
    private static final Set<class_1959> waterBiomes = new HashSet<class_1959>();
    private static final Set<class_1959> beachBiomes = new HashSet<class_1959>();
    private static final Set<class_1959> swampBiomes = new HashSet<class_1959>();

    public static void scanBiomeTypes() {
        for (class_1959 biome : class_2378.field_11153) {
            switch (biome.method_8688()) {
                case field_9363: {
                    beachBiomes.add(biome);
                    break;
                }
                case field_9367: {
                    waterBiomes.add(biome);
                    break;
                }
                case field_9364: {
                    swampBiomes.add(biome);
                }
            }
        }
    }

    public void setScanPonds(boolean value) {
        this.doScanPonds = value;
    }

    public void setScanRavines(boolean value) {
        this.doScanRavines = value;
    }

    int priorityForBiome(class_1959 biome) {
        if (waterBiomes.contains(biome)) {
            return 4;
        }
        if (beachBiomes.contains(biome)) {
            return 3;
        }
        return 1;
    }

    @Override
    public TileKind getBiomeID(class_1937 world, class_2791 chunk) {
        class_4548 chunkBiomes = chunk.method_12036();
        HashMap<class_1959, Integer> biomeOccurrences = new HashMap<class_1959, Integer>(class_2378.field_11153.method_10235().size());
        int lavaOccurrences = 0;
        int ravineOccurences = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height;
                int y;
                class_1959 biomeID = chunkBiomes.method_16359(x, 0, z);
                if (this.doScanPonds && (y = chunk.method_12032(class_2902.class_2903.field_13197).method_12603(x, z)) > 0) {
                    class_2248 topBlock = chunk.method_8320(new class_2338(x, y - 1, z)).method_11614();
                    if (topBlock == class_2246.field_10382 && !swampBiomes.contains(biomeID)) {
                        int occurrence = biomeOccurrences.getOrDefault(waterPoolBiome, 0) + 4;
                        biomeOccurrences.put(waterPoolBiome, occurrence);
                    } else if (topBlock == class_2246.field_10164) {
                        lavaOccurrences += 6;
                    }
                }
                if (this.doScanRavines && (height = chunk.method_12032(class_2902.class_2903.field_13197).method_12603(x, z)) > 0 && height < world.method_8615() - 7) {
                    ravineOccurences += 12;
                }
                int occurrence = biomeOccurrences.getOrDefault(biomeID, 0) + this.priorityForBiome(biomeID);
                biomeOccurrences.put(biomeID, occurrence);
            }
        }
        try {
            Map.Entry meanBiome = Collections.max(biomeOccurrences.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
            class_1959 meanBiomeId = (class_1959)meanBiome.getKey();
            int meanBiomeOccurrences = (Integer)meanBiome.getValue();
            if (meanBiomeOccurrences < ravineOccurences) {
                return TileKindFactory.get(ExtTileIdMap.TILE_RAVINE);
            }
            if (meanBiomeOccurrences < lavaOccurrences) {
                return TileKindFactory.get(ExtTileIdMap.TILE_LAVA);
            }
            return TileKindFactory.get(meanBiomeId);
        }
        catch (NoSuchElementException e) {
            return TileKindFactory.get(class_1972.field_9469);
        }
    }
}

