/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.ext;

import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.client.TilesPacket;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.ShortVec2;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ExtBiomeData
extends class_18 {
    private static final int VERSION = 1;
    private static final String TAG_VERSION = "aaVersion";
    private static final String TAG_DIMENSION_MAP_LIST = "dimMap";
    private static final String TAG_DIMENSION_ID = "dimID";
    private static final String TAG_BIOME_IDS = "biomeIDs";
    private final Map<class_2874, Map<ShortVec2, Integer>> dimensionMap = new ConcurrentHashMap<class_2874, Map<ShortVec2, Integer>>(2, 0.75f, 2);
    private final ShortVec2 tempCoords = new ShortVec2(0, 0);

    public ExtBiomeData(String key) {
        super(key);
    }

    public void method_77(class_2487 compound) {
        int version = compound.method_10550(TAG_VERSION);
        if (version < 1) {
            Log.warn("Outdated atlas data format! Was %d but current is %d", version, 1);
            this.method_80();
        }
        class_2499 dimensionMapList = compound.method_10554(TAG_DIMENSION_MAP_LIST, 10);
        for (int d = 0; d < dimensionMapList.size(); ++d) {
            class_2487 tag = dimensionMapList.method_10602(d);
            class_2874 dimensionID = tag.method_10573(TAG_DIMENSION_ID, 99) ? (class_2874)class_2378.field_11155.method_10200(tag.method_10550(TAG_DIMENSION_ID)) : (class_2874)class_2378.field_11155.method_10223(new class_2960(tag.method_10558(TAG_DIMENSION_ID)));
            Map<ShortVec2, Integer> biomeMap = this.getBiomesInDimension(dimensionID);
            int[] intArray = tag.method_10561(TAG_BIOME_IDS);
            for (int i = 0; i < intArray.length; i += 3) {
                ShortVec2 coords = new ShortVec2(intArray[i], intArray[i + 1]);
                biomeMap.put(coords, intArray[i + 2]);
            }
        }
    }

    public class_2487 method_75(class_2487 compound) {
        compound.method_10569(TAG_VERSION, 1);
        class_2499 dimensionMapList = new class_2499();
        for (class_2874 dimension : this.dimensionMap.keySet()) {
            class_2487 tag = new class_2487();
            tag.method_10582(TAG_DIMENSION_ID, class_2378.field_11155.method_10221((Object)dimension).toString());
            Map<ShortVec2, Integer> biomeMap = this.getBiomesInDimension(dimension);
            int[] intArray = new int[biomeMap.size() * 3];
            int i = 0;
            for (Map.Entry<ShortVec2, Integer> entry : biomeMap.entrySet()) {
                intArray[i++] = entry.getKey().x;
                intArray[i++] = entry.getKey().y;
                intArray[i++] = entry.getValue();
            }
            tag.method_10539(TAG_BIOME_IDS, intArray);
            dimensionMapList.add((Object)tag);
        }
        compound.method_10566(TAG_DIMENSION_MAP_LIST, (class_2520)dimensionMapList);
        return compound;
    }

    private Map<ShortVec2, Integer> getBiomesInDimension(class_2874 dimension) {
        return this.dimensionMap.computeIfAbsent(dimension, k -> new ConcurrentHashMap(2, 0.75f, 2));
    }

    public int getBiomeAt(class_2874 dimension, int x, int z) {
        Integer i = this.getBiomesInDimension(dimension).get(this.tempCoords.set(x, z));
        return i != null ? i : -1;
    }

    public void setBiomeAt(class_2874 dimension, int x, int z, int biome) {
        this.getBiomesInDimension(dimension).put(new ShortVec2(x, z), biome);
        this.method_80();
    }

    public void removeBiomeAt(class_2874 dimension, int x, int z) {
        this.getBiomesInDimension(dimension).remove(this.tempCoords.set(x, z));
        this.method_80();
    }

    public void syncOnPlayer(class_1657 player) {
        for (class_2874 dimension : this.dimensionMap.keySet()) {
            TilesPacket packet = new TilesPacket(dimension);
            Map<ShortVec2, Integer> biomes = this.getBiomesInDimension(dimension);
            for (Map.Entry<ShortVec2, Integer> entry : biomes.entrySet()) {
                packet.addTile(entry.getKey().x, entry.getKey().y, entry.getValue());
            }
            PacketDispatcher.sendTo(packet, (class_3222)player);
        }
        Log.info("Sent custom biome data to player %s", player.method_5671().method_9214());
    }
}

