/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.ext.watcher;

import com.google.common.collect.Sets;
import hunternif.mc.atlas.ext.watcher.IStructureWatcher;
import hunternif.mc.atlas.ext.watcher.WatcherPos;
import hunternif.mc.atlas.util.Log;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import org.apache.commons.lang3.tuple.Pair;

public class StructureWatcher {
    public static final StructureWatcher INSTANCE = new StructureWatcher();
    private final Set<IStructureWatcher> structureWatchers = Sets.newHashSet();

    private void handlePotential(class_1937 world) {
        if (world.field_9236) {
            return;
        }
        for (IStructureWatcher watcher : this.structureWatchers) {
            class_2487 structureData;
            if (!watcher.isDimensionValid(world.field_9247.method_12460()) || (structureData = watcher.getStructureData(world)) == null) continue;
            Set<Pair<WatcherPos, String>> visited = watcher.visitStructure(world, structureData);
            for (Pair<WatcherPos, String> visit : visited) {
                Log.info("Visited %s in dimension %s at %s", visit.getRight(), world.field_9247.method_12460().toString(), ((WatcherPos)visit.getLeft()).toString());
            }
        }
    }

    public void handleShutdown() {
        for (IStructureWatcher watcher : this.structureWatchers) {
            watcher.getVisited().clear();
        }
    }

    public void addWatcher(IStructureWatcher watcher) {
        if (!this.structureWatchers.contains(watcher)) {
            this.structureWatchers.add(watcher);
        }
    }
}

