/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.ext.watcher.impl;

import com.google.common.collect.Sets;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.ext.watcher.IStructureWatcher;
import hunternif.mc.atlas.ext.watcher.StructureWatcher;
import hunternif.mc.atlas.ext.watcher.WatcherPos;
import hunternif.mc.atlas.util.MathUtil;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import org.apache.commons.lang3.tuple.Pair;

public class StructureWatcherFortress
implements IStructureWatcher {
    private static final String ROOFED = "NeSCLT";
    private static final String ROOFED2 = "NeSCR";
    private static final String ROOFED_STAIRS = "NeCCS";
    private static final String ROOFED3 = "NeCTB";
    private static final String ROOFED4 = "NeSC";
    private static final String BRIDGE_GATE = "NeRC";
    private static final String ROOFED_CROSS = "NeSCSC";
    private static final String BRIDGE_CROSS = "NeBCr";
    private static final String START = "NeStart";
    private static final String BRIDGE = "NeBS";
    private static final String BRIDGE_END = "NeBEF";
    private static final String ENTRANCE = "NeCE";
    private static final String WART_STAIRS = "NeCSR";
    private static final String THRONE = "NeMT";
    private static final String TOWER = "NeSR";
    private final Set<WatcherPos> visited = new HashSet<WatcherPos>();

    public StructureWatcherFortress() {
        StructureWatcher.INSTANCE.addWatcher(this);
    }

    @Override
    @Nonnull
    public Set<WatcherPos> getVisited() {
        return this.visited;
    }

    @Override
    public boolean isDimensionValid(class_2874 type) {
        return type == class_2874.field_13076;
    }

    @Override
    @Nullable
    public class_2487 getStructureData(@Nonnull class_1937 world) {
        return null;
    }

    @Override
    @Nonnull
    public Set<Pair<WatcherPos, String>> visitStructure(@Nonnull class_1937 world, @Nonnull class_2487 structureTag) {
        HashSet visits = Sets.newHashSet();
        Set tagSet = structureTag.method_10541();
        for (String coords : tagSet) {
            WatcherPos pos;
            if (!WatcherPos.POS_PATTERN.matcher(coords).matches() || this.visited.contains(pos = new WatcherPos(coords))) continue;
            class_2487 tag = structureTag.method_10562(coords);
            this.visitFortress(world, tag);
            this.visited.add(pos);
            visits.add(Pair.of((Object)pos, (Object)"Nether Fortress"));
        }
        return visits;
    }

    private void visitFortress(class_1937 world, class_2487 tag) {
        class_2499 children = tag.method_10554("Children", 10);
        for (int i = 0; i < children.size(); ++i) {
            int chunkX;
            int chunkZ;
            class_2487 child = children.method_10602(i);
            String childID = child.method_10558("id");
            class_3341 boundingBox = new class_3341(child.method_10561("BB"));
            if (BRIDGE.equals(childID)) {
                if (boundingBox.method_14660() > 16) {
                    class_2960 tileName = ExtTileIdMap.TILE_NETHER_BRIDGE_X;
                    chunkZ = MathUtil.getCenter(boundingBox).method_10260() >> 4;
                    for (int x = boundingBox.field_14381; x < boundingBox.field_14378; x += 16) {
                        int chunkX2 = x >> 4;
                        if (!StructureWatcherFortress.noTileAt(world, chunkX2, chunkZ)) continue;
                        AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX2, chunkZ);
                    }
                    continue;
                }
                class_2960 tileName = ExtTileIdMap.TILE_NETHER_BRIDGE_Z;
                chunkX = MathUtil.getCenter(boundingBox).method_10263() >> 4;
                for (int z = boundingBox.field_14379; z < boundingBox.field_14376; z += 16) {
                    int chunkZ2 = z >> 4;
                    if (!StructureWatcherFortress.noTileAt(world, chunkX, chunkZ2)) continue;
                    AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX, chunkZ2);
                }
                continue;
            }
            if (BRIDGE_END.equals(childID)) {
                int chunkZ3;
                class_2960 tileName;
                if (boundingBox.method_14660() > boundingBox.method_14664()) {
                    tileName = ExtTileIdMap.TILE_NETHER_BRIDGE_END_X;
                    chunkX = boundingBox.field_14381 >> 4;
                    chunkZ3 = MathUtil.getCenter(boundingBox).method_10260() >> 4;
                } else {
                    tileName = ExtTileIdMap.TILE_NETHER_BRIDGE_END_Z;
                    chunkX = MathUtil.getCenter(boundingBox).method_10263() >> 4;
                    chunkZ3 = boundingBox.field_14379 >> 4;
                }
                if (!StructureWatcherFortress.noTileAt(world, chunkX, chunkZ3)) continue;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX, chunkZ3);
                continue;
            }
            int chunkX3 = MathUtil.getCenter(boundingBox).method_10263() >> 4;
            chunkZ = MathUtil.getCenter(boundingBox).method_10260() >> 4;
            if (BRIDGE_GATE.equals(childID)) {
                class_2960 tileName = ExtTileIdMap.TILE_NETHER_BRIDGE_GATE;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (BRIDGE_CROSS.equals(childID) || START.equals(childID)) {
                class_2960 tileName = ExtTileIdMap.TILE_NETHER_BRIDGE;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (TOWER.equals(childID)) {
                class_2960 tileName = ExtTileIdMap.TILE_NETHER_TOWER;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (ENTRANCE.equals(childID)) {
                class_2960 tileName = ExtTileIdMap.TILE_NETHER_HALL;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (WART_STAIRS.equals(childID)) {
                class_2960 tileName = ExtTileIdMap.TILE_NETHER_FORT_STAIRS;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (THRONE.equals(childID)) {
                class_2960 tileName = ExtTileIdMap.TILE_NETHER_THRONE;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            class_2960 tileName = ExtTileIdMap.TILE_NETHER_WALL;
            if (!StructureWatcherFortress.noTileAt(world, chunkX3, chunkZ)) continue;
            AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
        }
    }

    private static boolean noTileAt(class_1937 world, int chunkX, int chunkZ) {
        return AntiqueAtlasMod.extBiomeData.getData().getBiomeAt(world.field_9247.method_12460(), chunkX, chunkZ) == -1;
    }
}

