/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.ext.watcher.impl;

import com.google.common.collect.Sets;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.ext.watcher.IStructureWatcher;
import hunternif.mc.atlas.ext.watcher.StructureWatcher;
import hunternif.mc.atlas.ext.watcher.WatcherPos;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.registry.MarkerRegistry;
import hunternif.mc.atlas.registry.MarkerType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2874;
import org.apache.commons.lang3.tuple.Pair;

public class StructureWatcherGeneric
implements IStructureWatcher {
    private final Set<WatcherPos> visited = new HashSet<WatcherPos>();
    private final String datFileName;
    private MarkerType marker;
    private MarkerType tileMarker;
    private String markerLabel;
    private String tileMarkerLabel;
    private final class_2874 dimension;

    public StructureWatcherGeneric(String datFileName, class_2874 dimType, MarkerType marker, String label) {
        this.marker = marker;
        this.markerLabel = label;
        this.dimension = dimType;
        this.datFileName = datFileName;
        StructureWatcher.INSTANCE.addWatcher(this);
    }

    @Override
    @Nonnull
    public Set<WatcherPos> getVisited() {
        return this.visited;
    }

    @Override
    public boolean isDimensionValid(class_2874 type) {
        return this.dimension == type;
    }

    @Override
    @Nullable
    public class_2487 getStructureData(@Nonnull class_1937 world) {
        return null;
    }

    @Override
    @Nonnull
    public Set<Pair<WatcherPos, String>> visitStructure(@Nonnull class_1937 world, @Nonnull class_2487 structureTag) {
        HashSet visits = Sets.newHashSet();
        Set tagSet = structureTag.method_10541();
        for (String coords : tagSet) {
            WatcherPos pos;
            if (!WatcherPos.POS_PATTERN.matcher(coords).matches() || this.visited.contains(pos = new WatcherPos(coords))) continue;
            class_2487 tag = structureTag.method_10562(coords);
            this.visit(world, tag);
            this.visited.add(pos);
            visits.add(Pair.of((Object)pos, (Object)this.datFileName));
        }
        return visits;
    }

    public StructureWatcherGeneric setTileMarker(MarkerType type, String label) {
        this.tileMarker = type;
        this.tileMarkerLabel = label;
        return this;
    }

    private void visit(class_1937 world, class_2487 tag) {
        int chunkX = tag.method_10550("ChunkX");
        int chunkZ = tag.method_10550("ChunkZ");
        boolean foundMarker = false;
        boolean foundTileMarker = false;
        List<Marker> markers = AntiqueAtlasMod.globalMarkersData.getData().getMarkersAtChunk(world.field_9247.method_12460(), chunkX / 8, chunkZ / 8);
        if (markers != null) {
            for (Marker marker : markers) {
                if (!foundMarker && marker.getChunkX() == chunkX && marker.getChunkZ() == chunkZ && marker.getType().equals(this.marker)) {
                    foundMarker = true;
                }
                if (foundTileMarker || this.tileMarker == null || marker.getChunkX() != chunkX || marker.getChunkZ() != chunkZ || !marker.getType().equals(this.tileMarker)) continue;
                foundTileMarker = true;
            }
        }
        if (SettingsConfig.gameplay.autoVillageMarkers) {
            if (!foundMarker) {
                AtlasAPI.markers.putGlobalMarker(world, false, MarkerRegistry.getId(this.marker).toString(), this.markerLabel, (chunkX << 4) + 8, (chunkZ << 4) + 8);
            }
            if (this.tileMarker != null && !foundTileMarker) {
                AtlasAPI.markers.putGlobalMarker(world, false, MarkerRegistry.getId(this.tileMarker).toString(), this.tileMarkerLabel, (chunkX << 4) + 8, (chunkZ << 4) + 8);
            }
        }
    }
}

