/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.marker;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.item.ItemAtlas;
import hunternif.mc.atlas.marker.DimensionMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.mixinhooks.EntityHooksAA;
import hunternif.mc.atlas.registry.MarkerRegistry;
import hunternif.mc.atlas.registry.MarkerType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class NetherPortalWatcher {
    private final Map<Integer, class_2874> teleportingPlayersOrigin = new ConcurrentHashMap<Integer, class_2874>();

    private void addPortalMarkerIfNone(class_1657 player, class_2874 dimension) {
        if (!SettingsConfig.gameplay.autoNetherPortalMarkers || player.method_5770().field_9236) {
            return;
        }
        class_3218 world = ((class_3218)player.method_5770()).method_8503().method_3847(dimension);
        if (!SettingsConfig.gameplay.itemNeeded) {
            this.addPortalMarkerIfNone(player, (class_1937)world, dimension, player.method_5667().hashCode());
            return;
        }
        for (class_1799 stack : player.field_7514.field_7547) {
            if (stack == null || !(stack.method_7909() instanceof ItemAtlas)) continue;
            this.addPortalMarkerIfNone(player, (class_1937)world, dimension, ((ItemAtlas)stack.method_7909()).getAtlasID(stack));
        }
    }

    private void addPortalMarkerIfNone(class_1657 player, class_1937 world, class_2874 dimension, int atlasID) {
        int z;
        int x;
        MarkerType netherPortalType = MarkerRegistry.find(new class_2960("antiqueatlas:nether_portal"), false);
        if (netherPortalType == null) {
            return;
        }
        DimensionMarkersData data = AntiqueAtlasMod.markersData.getMarkersData(atlasID, world).getMarkersDataInDimension(dimension);
        List<Marker> markers = data.getMarkersAtChunk(((x = (int)player.method_23317()) >> 4) / 8, ((z = (int)player.method_23321()) >> 4) / 8);
        if (markers != null) {
            for (Marker marker : markers) {
                if (!marker.getType().equals("antiqueatlas:nether_portal")) continue;
                return;
            }
        }
        AtlasAPI.markers.putMarker(world, false, atlasID, MarkerRegistry.getId(netherPortalType).toString(), "gui.antiqueatlas.marker.netherPortal", x, z);
    }

    private static boolean isEntityInPortal(class_1297 entity) {
        return ((EntityHooksAA)entity).antiqueAtlas_isInPortal();
    }
}

