/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network.bidirectional;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.marker.GlobalMarkersData;
import hunternif.mc.atlas.network.AbstractMessage;
import hunternif.mc.atlas.util.Log;
import java.io.IOException;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1657;
import net.minecraft.class_2540;

public class DeleteMarkerPacket
extends AbstractMessage<DeleteMarkerPacket> {
    private static final int GLOBAL = -1;
    private int atlasID;
    private int markerID;

    public DeleteMarkerPacket() {
    }

    public DeleteMarkerPacket(int atlasID, int markerID) {
        this.atlasID = atlasID;
        this.markerID = markerID;
    }

    public DeleteMarkerPacket(int markerID) {
        this(-1, markerID);
    }

    @Override
    public void read(class_2540 buffer) throws IOException {
        this.atlasID = buffer.method_10816();
        this.markerID = buffer.method_10816();
    }

    @Override
    public void write(class_2540 buffer) throws IOException {
        buffer.method_10804(this.atlasID);
        buffer.method_10804(this.markerID);
    }

    private boolean isGlobal() {
        return this.atlasID == -1;
    }

    @Override
    protected void process(class_1657 player, EnvType side) {
        if (side == EnvType.SERVER) {
            if (SettingsConfig.gameplay.itemNeeded && !AtlasAPI.getPlayerAtlases(player).contains(this.atlasID)) {
                Log.warn("Player %s attempted to delete marker from someone else's Atlas #%d", player.method_5671().method_9214(), this.atlasID);
                return;
            }
            if (this.isGlobal()) {
                AtlasAPI.markers.deleteGlobalMarker(player.method_5770(), this.markerID);
            } else {
                AtlasAPI.markers.deleteMarker(player.method_5770(), this.atlasID, this.markerID);
            }
        } else {
            GlobalMarkersData data = this.isGlobal() ? AntiqueAtlasMod.globalMarkersData.getData() : AntiqueAtlasMod.markersData.getMarkersData(this.atlasID, player.method_5770());
            data.removeMarker(this.markerID);
        }
    }
}

