/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network.client;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.core.AtlasData;
import hunternif.mc.atlas.core.TileInfo;
import hunternif.mc.atlas.core.TileKind;
import hunternif.mc.atlas.core.TileKindFactory;
import hunternif.mc.atlas.network.AbstractMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2874;
import net.minecraft.class_2960;

public class DimensionUpdatePacket
extends AbstractMessage.AbstractClientMessage<DimensionUpdatePacket> {
    private static final int ENTRY_SIZE_BYTES = 8;
    private int atlasID;
    private class_2960 dimensionId;
    private int tileCount;
    private ByteBuf tileData;

    public DimensionUpdatePacket() {
    }

    public DimensionUpdatePacket(int atlasID, class_2874 dimension) {
        this.atlasID = atlasID;
        this.dimensionId = class_2378.field_11155.method_10221((Object)dimension);
        this.tileCount = 0;
        this.tileData = Unpooled.buffer();
    }

    public DimensionUpdatePacket(int atlasID, class_2874 dimension, Collection<TileInfo> tiles) {
        this(atlasID, dimension);
        for (TileInfo i : tiles) {
            this.addTile(i.x, i.z, i.biome);
        }
    }

    public DimensionUpdatePacket addTile(int x, int y, TileKind biomeID) {
        this.tileData.writeShort(x);
        this.tileData.writeShort(y);
        this.tileData.writeInt(biomeID.getId());
        ++this.tileCount;
        return this;
    }

    public boolean isEmpty() {
        return this.tileCount == 0;
    }

    @Override
    public void read(class_2540 buffer) throws IOException {
        this.atlasID = buffer.method_10816();
        this.dimensionId = buffer.method_10810();
        this.tileCount = buffer.method_10816();
        this.tileData = buffer.readBytes(this.tileCount * 8);
    }

    @Override
    public void write(class_2540 buffer) throws IOException {
        buffer.method_10804(this.atlasID);
        buffer.method_10812(this.dimensionId);
        buffer.method_10804(this.tileCount);
        buffer.writeBytes(this.tileData);
        this.tileData.readerIndex(0);
    }

    @Override
    protected void process(class_1657 player, EnvType side) {
        class_2874 dimension = (class_2874)class_2378.field_11155.method_10223(this.dimensionId);
        if (dimension == null) {
            return;
        }
        AtlasData data = AntiqueAtlasMod.atlasData.getAtlasData(this.atlasID, player.field_6002);
        for (int i = 0; i < this.tileCount; ++i) {
            short x = this.tileData.readShort();
            short y = this.tileData.readShort();
            TileKind tile = TileKindFactory.get(this.tileData.readInt());
            data.getDimensionData(dimension).setTile(x, y, tile);
        }
    }
}

