/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network.client;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.ext.ExtBiomeData;
import hunternif.mc.atlas.network.AbstractMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2874;

public class TilesPacket
extends AbstractMessage.AbstractClientMessage<TilesPacket> {
    private static final int ENTRY_SIZE_BYTES = 8;
    private class_2874 dimension;
    private int tileCount;
    private ByteBuf tileData;

    public TilesPacket() {
    }

    public TilesPacket(class_2874 dimension) {
        this.dimension = dimension;
        this.tileCount = 0;
        this.tileData = Unpooled.buffer();
    }

    public TilesPacket addTile(int x, int y, int biomeID) {
        this.tileData.writeShort(x);
        this.tileData.writeShort(y);
        this.tileData.writeInt(biomeID);
        ++this.tileCount;
        return this;
    }

    public boolean isEmpty() {
        return this.tileCount == 0;
    }

    @Override
    public void read(class_2540 buffer) throws IOException {
        this.dimension = (class_2874)class_2378.field_11155.method_10200(buffer.method_10816());
        this.tileCount = buffer.method_10816();
        this.tileData = buffer.readBytes(this.tileCount * 8);
    }

    @Override
    public void write(class_2540 buffer) throws IOException {
        buffer.method_10804(class_2378.field_11155.method_10249((Object)this.dimension));
        buffer.method_10804(this.tileCount);
        buffer.writeBytes(this.tileData);
    }

    @Override
    protected void process(class_1657 player, EnvType side) {
        if (this.dimension == null) {
            return;
        }
        ExtBiomeData data = AntiqueAtlasMod.extBiomeData.getData();
        for (int i = 0; i < this.tileCount; ++i) {
            data.setBiomeAt(this.dimension, this.tileData.readShort(), this.tileData.readShort(), this.tileData.readInt());
        }
    }
}

