/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network.server;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.network.AbstractMessage;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.client.MarkersPacket;
import hunternif.mc.atlas.util.Log;
import java.io.IOException;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2874;
import net.minecraft.class_3218;

public class AddMarkerPacket
extends AbstractMessage.AbstractServerMessage<AddMarkerPacket> {
    private int atlasID;
    private class_2874 dimension;
    private String type;
    private String label;
    private int x;
    private int y;
    private boolean visibleAhead;

    public AddMarkerPacket() {
    }

    public AddMarkerPacket(int atlasID, class_2874 dimension, String type, String label, int x, int y, boolean visibleAhead) {
        this.atlasID = atlasID;
        this.dimension = dimension;
        this.type = type;
        this.label = label;
        this.x = x;
        this.y = y;
        this.visibleAhead = visibleAhead;
    }

    @Override
    public void read(class_2540 buffer) throws IOException {
        this.atlasID = buffer.method_10816();
        this.dimension = (class_2874)class_2378.field_11155.method_10200(buffer.method_10816());
        this.type = buffer.method_10800(512);
        this.label = buffer.method_10800(512);
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.visibleAhead = buffer.readBoolean();
    }

    @Override
    public void write(class_2540 buffer) throws IOException {
        buffer.method_10804(this.atlasID);
        buffer.method_10804(class_2378.field_11155.method_10249((Object)this.dimension));
        buffer.method_10814(this.type);
        buffer.method_10814(this.label);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeBoolean(this.visibleAhead);
    }

    @Override
    protected void process(class_1657 player, EnvType side) {
        if (SettingsConfig.gameplay.itemNeeded && !AtlasAPI.getPlayerAtlases(player).contains(this.atlasID)) {
            Log.warn("Player %s attempted to put marker into someone else's Atlas #%d", player.method_5671().method_9214(), this.atlasID);
            return;
        }
        MarkersData markersData = AntiqueAtlasMod.markersData.getMarkersData(this.atlasID, player.method_5770());
        Marker marker = markersData.createAndSaveMarker(this.type, this.label, this.dimension, this.x, this.y, this.visibleAhead);
        MarkersPacket packetForClients = new MarkersPacket(this.atlasID, this.dimension, marker);
        PacketDispatcher.sendToAll(((class_3218)player.method_5770()).method_8503(), packetForClients);
    }
}

