/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network.server;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.network.AbstractMessage;
import hunternif.mc.atlas.util.Log;
import java.io.IOException;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2874;

public class BrowsingPositionPacket
extends AbstractMessage.AbstractServerMessage<BrowsingPositionPacket> {
    public static final double ZOOM_SCALE_FACTOR = 1024.0;
    private int atlasID;
    private class_2874 dimension;
    private int x;
    private int y;
    private double zoom;

    public BrowsingPositionPacket() {
    }

    public BrowsingPositionPacket(int atlasID, class_2874 dimension, int x, int y, double zoom) {
        this.atlasID = atlasID;
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.zoom = zoom;
    }

    @Override
    protected void read(class_2540 buffer) throws IOException {
        this.atlasID = buffer.method_10816();
        this.dimension = (class_2874)class_2378.field_11155.method_10200(buffer.method_10816());
        this.x = buffer.method_10816();
        this.y = buffer.method_10816();
        this.zoom = (double)buffer.method_10816() / 1024.0;
    }

    @Override
    protected void write(class_2540 buffer) throws IOException {
        buffer.method_10804(this.atlasID);
        buffer.method_10804(class_2378.field_11155.method_10249((Object)this.dimension));
        buffer.method_10804(this.x);
        buffer.method_10804(this.y);
        buffer.method_10804((int)Math.round(this.zoom * 1024.0));
    }

    @Override
    protected void process(class_1657 player, EnvType side) {
        if (SettingsConfig.gameplay.itemNeeded && !AtlasAPI.getPlayerAtlases(player).contains(this.atlasID)) {
            Log.warn("Player %s attempted to put position marker into someone else's Atlas #%d", player.method_5671().method_9214(), this.atlasID);
            return;
        }
        AntiqueAtlasMod.atlasData.getAtlasData(this.atlasID, player.method_5770()).getDimensionData(this.dimension).setBrowsingPosition(this.x, this.y, this.zoom);
    }
}

