/*
 * Decompiled with CFR 0.152.
 */
package kenkron.antiqueatlasoverlay;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.RegistrarAntiqueAtlas;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.SubTile;
import hunternif.mc.atlas.client.SubTileQuartet;
import hunternif.mc.atlas.client.Textures;
import hunternif.mc.atlas.client.TileRenderIterator;
import hunternif.mc.atlas.client.gui.GuiAtlas;
import hunternif.mc.atlas.core.DimensionData;
import hunternif.mc.atlas.item.ItemAtlas;
import hunternif.mc.atlas.marker.DimensionMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.registry.MarkerRegistry;
import hunternif.mc.atlas.registry.MarkerRenderInfo;
import hunternif.mc.atlas.registry.MarkerType;
import hunternif.mc.atlas.util.AtlasRenderHelper;
import hunternif.mc.atlas.util.Rect;
import java.util.List;
import kenkron.antiqueatlasoverlay.AAOConfig;
import kenkron.antiqueatlasoverlay.AntiqueAtlasOverlayMod;
import kenkron.antiqueatlasoverlay.SetTileRenderer;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_4493;
import net.minecraft.class_746;
import org.lwjgl.opengl.GL11;

public class OverlayRenderer {
    private static final int CHUNK_SIZE = 16;

    private static Integer getPlayerAtlas(class_1657 player) {
        if (!SettingsConfig.gameplay.itemNeeded) {
            return player.method_5667().hashCode();
        }
        class_1799 stack = player.method_6079();
        if (!stack.method_7960() && stack.method_7909() == RegistrarAntiqueAtlas.ATLAS) {
            return stack.method_7919();
        }
        for (int i = 0; i < 9; ++i) {
            stack = player.field_7514.method_5438(i);
            if (stack.method_7960() || stack.method_7909() != RegistrarAntiqueAtlas.ATLAS) continue;
            return stack.method_7919();
        }
        return null;
    }

    public static void drawOverlay(int gameWidth, int gameHeight) {
        if (!AAOConfig.appearance.enabled) {
            return;
        }
        if (class_310.method_1551().field_1755 instanceof GuiAtlas) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        Integer atlas = null;
        if (AAOConfig.appearance.requiresHold) {
            class_1799 stack = player.method_6047();
            class_1799 stack2 = player.method_6079();
            if (!stack.method_7960() && stack.method_7909() == RegistrarAntiqueAtlas.ATLAS) {
                atlas = ((ItemAtlas)stack.method_7909()).getAtlasID(stack);
            } else if (!stack2.method_7960() && stack2.method_7909() == RegistrarAntiqueAtlas.ATLAS) {
                atlas = ((ItemAtlas)stack2.method_7909()).getAtlasID(stack2);
            }
        } else {
            atlas = OverlayRenderer.getPlayerAtlas((class_1657)player);
        }
        if (atlas != null) {
            Rect bounds = new Rect().setOrigin(AAOConfig.position.xPosition, AAOConfig.position.yPosition);
            if (AAOConfig.position.alignRight) {
                bounds.minX = gameWidth - (AAOConfig.position.width + AAOConfig.position.xPosition);
            }
            if (AAOConfig.position.alignBottom) {
                bounds.minY = gameHeight - (AAOConfig.position.height + AAOConfig.position.yPosition);
            }
            bounds.setSize(AAOConfig.position.width, AAOConfig.position.height);
            OverlayRenderer.drawMinimap(bounds, atlas, player.method_19538(), player.method_5791(), player.field_6026);
        }
    }

    private static void drawMinimap(Rect shape, int atlasID, class_243 position, float rotation, class_2874 dimension) {
        class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4493.method_22056();
        class_4493.method_21945((int)516, (float)0.0f);
        AtlasRenderHelper.drawFullTexture(Textures.BOOK, shape.minX, shape.minY, shape.getWidth(), shape.getHeight());
        Rect innerShape = new Rect(shape.minX + Math.round(AAOConfig.appearance.borderX * (float)shape.getWidth()), shape.minY + Math.round(AAOConfig.appearance.borderY * (float)shape.getHeight()), shape.maxX - Math.round(AAOConfig.appearance.borderX * (float)shape.getWidth()), shape.maxY - Math.round(AAOConfig.appearance.borderY * (float)shape.getHeight()));
        OverlayRenderer.drawTiles(innerShape, atlasID, position, dimension);
        if (AAOConfig.appearance.markerSize > 0) {
            OverlayRenderer.drawMarkers(innerShape, atlasID, position, dimension);
            int shapeMiddleX = (shape.minX + shape.maxX) / 2;
            int shapeMiddleY = (shape.minY + shape.maxY) / 2;
            OverlayRenderer.drawPlayer(shapeMiddleX, shapeMiddleY, rotation);
        }
        class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AtlasRenderHelper.drawFullTexture(Textures.BOOK_FRAME, shape.minX, shape.minY, shape.getWidth(), shape.getHeight());
        class_4493.method_22053();
    }

    private static void drawTiles(Rect shape, int atlasID, class_243 position, class_2874 dimension) {
        GL11.glEnable((int)3089);
        OverlayRenderer.glScissorGUI(shape);
        class_4493.method_22056();
        class_4493.method_21984((int)770, (int)771);
        DimensionData biomeData = AntiqueAtlasMod.atlasData.getAtlasData(atlasID, (class_1937)class_310.method_1551().field_1687).getDimensionData(dimension);
        TileRenderIterator iter = new TileRenderIterator(biomeData);
        Rect iteratorScope = OverlayRenderer.getChunkCoverage(position, shape);
        iter.setScope(iteratorScope);
        iter.setStep(1);
        class_243 chunkPosition = new class_243(position.field_1352 / 16.0, position.field_1351 / 16.0, position.field_1350 / 16.0);
        int shapeMiddleX = (shape.minX + shape.maxX) / 2;
        int shapeMiddleY = (shape.minY + shape.maxY) / 2;
        SetTileRenderer renderer = new SetTileRenderer(AAOConfig.appearance.tileSize / 2);
        while (iter.hasNext()) {
            SubTileQuartet subtiles = iter.next();
            for (SubTile subtile : subtiles) {
                if (subtile == null || subtile.tile == null) continue;
                float relativeChunkPositionX = (float)((double)subtile.x / 2.0 + (double)iteratorScope.minX - chunkPosition.field_1352);
                float relativeChunkPositionY = (float)((double)subtile.y / 2.0 + (double)iteratorScope.minY - chunkPosition.field_1350);
                renderer.addTileCorner(BiomeTextureMap.instance().getTexture(subtile.variationNumber, subtile.tile), shapeMiddleX + (int)Math.floor(relativeChunkPositionX * (float)AAOConfig.appearance.tileSize), shapeMiddleY + (int)Math.floor(relativeChunkPositionY * (float)AAOConfig.appearance.tileSize), subtile.getTextureU(), subtile.getTextureV());
            }
        }
        renderer.draw();
        GL11.glDisable((int)3089);
        class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawMarkers(Rect shape, int atlasID, class_243 position, class_2874 dimension) {
        GL11.glEnable((int)3089);
        OverlayRenderer.glScissorGUI(shape);
        DimensionData biomeData = AntiqueAtlasMod.atlasData.getAtlasData(atlasID, (class_1937)class_310.method_1551().field_1687).getDimensionData(dimension);
        DimensionMarkersData globalMarkersData = AntiqueAtlasMod.globalMarkersData.getData().getMarkersDataInDimension(dimension);
        OverlayRenderer.drawMarkersData(globalMarkersData, shape, biomeData, position);
        MarkersData markersData = AntiqueAtlasMod.markersData.getMarkersData(atlasID, (class_1937)class_310.method_1551().field_1687);
        DimensionMarkersData localMarkersData = null;
        if (markersData != null) {
            localMarkersData = markersData.getMarkersDataInDimension(dimension);
        }
        OverlayRenderer.drawMarkersData(localMarkersData, shape, biomeData, position);
        GL11.glDisable((int)3089);
        class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawPlayer(float x, float y, float rotation) {
        class_4493.method_21926();
        class_4493.method_21999((float)x, (float)y, (float)0.0f);
        class_4493.method_21981((float)(180.0f + rotation), (float)0.0f, (float)0.0f, (float)1.0f);
        class_4493.method_21999((float)(-AAOConfig.appearance.playerIconWidth / 2), (float)(-AAOConfig.appearance.playerIconHeight / 2), (float)0.0f);
        AtlasRenderHelper.drawFullTexture(Textures.PLAYER, 0.0, 0.0, AAOConfig.appearance.playerIconWidth, AAOConfig.appearance.playerIconHeight);
        class_4493.method_21928();
        class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawMarkersData(DimensionMarkersData markersData, Rect shape, DimensionData biomeData, class_243 position) {
        Rect markerShape = new Rect(shape.minX - AAOConfig.appearance.markerSize / 2, shape.minY - AAOConfig.appearance.markerSize / 2, shape.maxX + AAOConfig.appearance.markerSize / 2, shape.maxY + AAOConfig.appearance.markerSize / 2);
        Rect mcchunks = OverlayRenderer.getChunkCoverage(position, markerShape);
        Rect chunks = new Rect((int)Math.floor(mcchunks.minX / 8), (int)Math.floor(mcchunks.minY / 8), (int)Math.ceil(mcchunks.maxX / 8), (int)Math.ceil(mcchunks.maxY / 8));
        int shapeMiddleX = (shape.minX + shape.maxX) / 2;
        int shapeMiddleY = (shape.minY + shape.maxY) / 2;
        for (int x = chunks.minX; x <= chunks.maxX; ++x) {
            for (int z = chunks.minY; z <= chunks.maxY; ++z) {
                List<Marker> markers = markersData.getMarkersAtChunk(Math.round(x), Math.round(z));
                if (markers == null) continue;
                for (Marker marker : markers) {
                    int relativeChunkPositionX = AAOConfig.appearance.tileSize * (2 * (marker.getX() / 2) - 2 * (int)Math.floor(position.field_1352 / 2.0)) / 16;
                    int relativeChunkPositionY = AAOConfig.appearance.tileSize * (2 * (marker.getZ() / 2) - 2 * (int)Math.floor(position.field_1350 / 2.0)) / 16;
                    int guiX = (int)Math.floor(shapeMiddleX - AAOConfig.appearance.markerSize / 2 + relativeChunkPositionX);
                    int guiY = (int)Math.floor(shapeMiddleY - AAOConfig.appearance.markerSize / 2 + relativeChunkPositionY);
                    OverlayRenderer.renderMarker(marker, guiX, guiY, biomeData);
                }
            }
        }
    }

    private static void renderMarker(Marker marker, int x, int y, DimensionData biomeData) {
        if (!marker.isVisibleAhead() && !biomeData.hasTileAt(marker.getChunkX(), marker.getChunkZ())) {
            return;
        }
        class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MarkerType m = MarkerRegistry.find(marker.getType());
        if (m == null) {
            AntiqueAtlasOverlayMod.LOGGER.warn("Could not find marker type for {}", (Object)marker.getId());
            return;
        }
        MarkerRenderInfo info = m.getRenderInfo(1.0, AAOConfig.appearance.tileSize, 1.0);
        AtlasRenderHelper.drawFullTexture(info.tex, x, y, AAOConfig.appearance.markerSize, AAOConfig.appearance.markerSize);
    }

    private static Rect getChunkCoverage(class_243 position, Rect windowShape) {
        int minChunkX = (int)Math.floor(position.field_1352 / 16.0 - (double)((float)windowShape.getWidth() / (2.0f * (float)AAOConfig.appearance.tileSize)));
        int minChunkY = (int)Math.floor(position.field_1350 / 16.0 - (double)((float)windowShape.getHeight() / (2.0f * (float)AAOConfig.appearance.tileSize)));
        int maxChunkX = (int)Math.ceil(position.field_1352 / 16.0 + (double)((float)windowShape.getWidth() / (2.0f * (float)AAOConfig.appearance.tileSize)));
        int maxChunkY = (int)Math.ceil(position.field_1350 / 16.0 + (double)((float)windowShape.getHeight() / (2.0f * (float)AAOConfig.appearance.tileSize)));
        return new Rect(--minChunkX, --minChunkY, ++maxChunkX, ++maxChunkY);
    }

    private static void glScissorGUI(Rect shape) {
        float scissorScale = (float)class_310.method_1551().method_22683().method_4495();
        int mcHeight = class_310.method_1551().method_22683().method_4506();
        GL11.glScissor((int)((int)((float)shape.minX * scissorScale)), (int)((int)((float)mcHeight - (float)shape.maxY * scissorScale)), (int)((int)((float)shape.getWidth() * scissorScale)), (int)((int)((float)shape.getHeight() * scissorScale)));
    }
}

