/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas;

import hunternif.mc.atlas.core.BiomeDetectorBase;
import hunternif.mc.atlas.ext.ExtTileConfig;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.util.Log;
import java.io.File;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.fabric.api.network.PacketConsumer;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;

public class CommonProxy {
    static File configDir;
    private static ExtTileIdMap extTileIdMap;
    private static ExtTileConfig extTileConfig;

    public void init() {
        configDir = new File(FabricLoader.getInstance().getConfigDirectory(), "antiqueatlas");
        configDir.mkdir();
        extTileIdMap = ExtTileIdMap.instance();
        extTileConfig = new ExtTileConfig(new File(configDir, "tileids.json"));
        extTileConfig.load(extTileIdMap);
        this.registerVanillaCustomTiles();
        this.checkSaveConfig();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("antiqueatlas:scanbiometypes");
            }

            public void method_14491(class_3300 var1) {
                BiomeDetectorBase.scanBiomeTypes();
            }
        });
    }

    private void registerVanillaCustomTiles() {
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_VILLAGE_LIBRARY);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_VILLAGE_SMITHY);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_VILLAGE_L_HOUSE);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_VILLAGE_FARMLAND_LARGE);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_VILLAGE_FARMLAND_SMALL);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_VILLAGE_WELL);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_VILLAGE_TORCH);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_VILLAGE_HUT);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_VILLAGE_SMALL_HOUSE);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_VILLAGE_BUTCHERS_SHOP);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_VILLAGE_CHURCH);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_LAVA);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_LAVA_SHORE);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_NETHER_BRIDGE);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_NETHER_BRIDGE_X);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_NETHER_BRIDGE_Z);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_NETHER_BRIDGE_END_X);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_NETHER_BRIDGE_END_Z);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_NETHER_BRIDGE_GATE);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_NETHER_TOWER);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_NETHER_WALL);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_NETHER_HALL);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_NETHER_FORT_STAIRS);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_NETHER_THRONE);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_END_ISLAND);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_END_ISLAND_PLANTS);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_END_VOID);
        extTileIdMap.getOrCreatePseudoBiomeID(ExtTileIdMap.TILE_RAVINE);
    }

    public void openAtlasGUI(class_1799 stack) {
    }

    public void openAtlasGUI() {
    }

    public File getConfigDir() {
        return configDir;
    }

    private void checkSaveConfig() {
        if (extTileIdMap.isDirty()) {
            Log.info("Saving ext tile id config", new Object[0]);
            extTileConfig.save(extTileIdMap);
            extTileIdMap.setDirty(false);
        }
    }

    public void registerPackets(Set<class_2960> clientPackets, Set<class_2960> serverPackets, Function<class_2960, PacketConsumer> consumer) {
        serverPackets.forEach(id -> ServerSidePacketRegistry.INSTANCE.register(id, (PacketConsumer)consumer.apply((class_2960)id)));
    }
}

