/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.client.TextureSetMap;
import hunternif.mc.atlas.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

@Environment(value=EnvType.CLIENT)
public class TextureSetConfig
implements SimpleResourceReloadListener<Collection<TextureSet>> {
    private static final int VERSION = 1;
    private static final JsonParser PARSER = new JsonParser();
    private final TextureSetMap textureSetMap;

    public TextureSetConfig(TextureSetMap textureSetMap) {
        this.textureSetMap = textureSetMap;
    }

    public CompletableFuture<Collection<TextureSet>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<TextureSet> sets = new ArrayList<TextureSet>();
            try {
                for (class_3298 resource : manager.method_14489(new class_2960("antiqueatlas:texture_sets.json"))) {
                    try {
                        InputStream stream = resource.method_14482();
                        Throwable throwable = null;
                        try {
                            InputStreamReader reader = new InputStreamReader(stream);
                            Throwable throwable2 = null;
                            try {
                                JsonElement element = PARSER.parse((Reader)reader);
                                if (element.isJsonObject()) {
                                    JsonObject obj = element.getAsJsonObject();
                                    if (!obj.has("version")) {
                                        Log.warn("Invalid texture set file found!", new Object[0]);
                                        continue;
                                    }
                                    if (obj.get("version").getAsInt() < 1) {
                                        Log.warn("Outdated texture set file version: " + obj.get("version").getAsInt(), new Object[0]);
                                        continue;
                                    }
                                    for (Map.Entry entry : obj.get("data").getAsJsonObject().entrySet()) {
                                        String name = (String)entry.getKey();
                                        JsonArray array = ((JsonElement)entry.getValue()).getAsJsonArray();
                                        class_2960[] textures = new class_2960[array.size()];
                                        for (int i = 0; i < array.size(); ++i) {
                                            String path = array.get(i).getAsString();
                                            textures[i] = new class_2960(path);
                                        }
                                        sets.add(new TextureSet(AntiqueAtlasMod.id(name), textures));
                                    }
                                    continue;
                                }
                                Log.warn("Invalid texture set file found!", new Object[0]);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                reader.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                    catch (Throwable e) {
                        Log.warn(e, "Failed to read texture set file!", new Object[0]);
                    }
                }
            }
            catch (Throwable e) {
                Log.warn(e, "Failed to read texture sets!", new Object[0]);
            }
            return sets;
        });
    }

    public CompletableFuture<Void> apply(Collection<TextureSet> sets, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (TextureSet set : sets) {
                this.textureSetMap.register(set);
                Log.info("Loaded texture set %s with %d custom texture(s)", set.name, set.textures.length);
            }
        });
    }

    public class_2960 getFabricId() {
        return new class_2960("antiqueatlas:texture_sets");
    }
}

