/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client.gui;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.SubTile;
import hunternif.mc.atlas.client.SubTileQuartet;
import hunternif.mc.atlas.client.Textures;
import hunternif.mc.atlas.client.TileRenderIterator;
import hunternif.mc.atlas.client.gui.ExportUpdateListener;
import hunternif.mc.atlas.client.gui.GuiArrowButton;
import hunternif.mc.atlas.client.gui.GuiBlinkingMarker;
import hunternif.mc.atlas.client.gui.GuiBookmarkButton;
import hunternif.mc.atlas.client.gui.GuiMarkerFinalizer;
import hunternif.mc.atlas.client.gui.GuiPositionButton;
import hunternif.mc.atlas.client.gui.GuiScaleBar;
import hunternif.mc.atlas.client.gui.ProgressBarOverlay;
import hunternif.mc.atlas.client.gui.core.GuiComponent;
import hunternif.mc.atlas.client.gui.core.GuiComponentButton;
import hunternif.mc.atlas.client.gui.core.GuiCursor;
import hunternif.mc.atlas.client.gui.core.GuiStates;
import hunternif.mc.atlas.client.gui.core.IButtonListener;
import hunternif.mc.atlas.core.DimensionData;
import hunternif.mc.atlas.event.MarkerClickedCallback;
import hunternif.mc.atlas.event.MarkerHoveredCallback;
import hunternif.mc.atlas.item.ItemAtlas;
import hunternif.mc.atlas.marker.DimensionMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.server.BrowsingPositionPacket;
import hunternif.mc.atlas.registry.MarkerRegistry;
import hunternif.mc.atlas.registry.MarkerRenderInfo;
import hunternif.mc.atlas.registry.MarkerType;
import hunternif.mc.atlas.util.AtlasRenderHelper;
import hunternif.mc.atlas.util.ExportImageUtil;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.MathUtil;
import hunternif.mc.atlas.util.Rect;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_2874;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import org.lwjgl.opengl.GL11;

public class GuiAtlas
extends GuiComponent {
    public static final int WIDTH = 310;
    public static final int HEIGHT = 218;
    private static final int CONTENT_X = 17;
    private static final int CONTENT_Y = 11;
    private static final int MAP_WIDTH = 276;
    private static final int MAP_HEIGHT = 194;
    private static final float PLAYER_ROTATION_STEPS = 16.0f;
    private static final int PLAYER_ICON_WIDTH = 7;
    private static final int PLAYER_ICON_HEIGHT = 8;
    public static final int MARKER_SIZE = 32;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private static final double MIN_SCALE_THRESHOLD = 0.5;
    private final long[] renderTimes = new long[30];
    private int renderTimesIndex = 0;
    private final GuiStates state = new GuiStates();
    private final GuiStates.IState NORMAL = new GuiStates.SimpleState();
    private final GuiStates.IState HIDING_MARKERS = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.btnShowMarkers.setSelected(false);
            GuiAtlas.this.btnShowMarkers.setTitle((class_2561)new class_2588("gui.antiqueatlas.showMarkers"));
            GuiAtlas.this.btnShowMarkers.setIconTexture(Textures.ICON_SHOW_MARKERS);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.btnShowMarkers.setSelected(false);
            GuiAtlas.this.btnShowMarkers.setTitle((class_2561)new class_2588("gui.antiqueatlas.hideMarkers"));
            GuiAtlas.this.btnShowMarkers.setIconTexture(Textures.ICON_HIDE_MARKERS);
        }
    };
    private final GuiStates.IState PLACING_MARKER = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.btnMarker.setSelected(true);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.btnMarker.setSelected(false);
        }
    };
    private final GuiStates.IState DELETING_MARKER = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.addChild(GuiAtlas.this.eraser);
            GuiAtlas.this.btnDelMarker.setSelected(true);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.removeChild(GuiAtlas.this.eraser);
            GuiAtlas.this.btnDelMarker.setSelected(false);
        }
    };
    private final GuiCursor eraser = new GuiCursor();
    private final GuiStates.IState EXPORTING_IMAGE = new GuiStates.IState(){

        @Override
        public void onEnterState() {
            GuiAtlas.this.btnExportPng.setSelected(true);
        }

        @Override
        public void onExitState() {
            GuiAtlas.this.btnExportPng.setSelected(false);
        }
    };
    private final GuiArrowButton btnUp;
    private final GuiArrowButton btnDown;
    private final GuiArrowButton btnLeft;
    private final GuiArrowButton btnRight;
    private final GuiBookmarkButton btnExportPng;
    private final GuiBookmarkButton btnMarker;
    private final GuiBookmarkButton btnDelMarker;
    private final GuiBookmarkButton btnShowMarkers;
    private final GuiPositionButton btnPosition;
    private static final int BUTTON_PAUSE = 8;
    private static final int navigateStep = 24;
    private GuiComponentButton selectedButton = null;
    private long timeButtonPressed = 0L;
    private boolean isDragging = false;
    private int mapOffsetX;
    private int mapOffsetY;
    private boolean followPlayer = true;
    private final GuiScaleBar scaleBar = new GuiScaleBar();
    private double mapScale;
    private int tileHalfSize;
    private int tile2ChunkScale;
    private DimensionMarkersData localMarkersData;
    private DimensionMarkersData globalMarkersData;
    private Marker hoveredMarker;
    private final GuiMarkerFinalizer markerFinalizer = new GuiMarkerFinalizer();
    private final GuiBlinkingMarker blinkingIcon = new GuiBlinkingMarker();
    private class_1657 player;
    private class_1799 stack;
    private DimensionData biomeData;
    private double screenScale;
    private final ProgressBarOverlay progressBar = new ProgressBarOverlay(100, 2);
    private long lastUpdateMillis = System.currentTimeMillis();
    private int scaleAlpha = 255;
    private int scaleClipIndex = 0;
    private int zoomLevelOne;
    private int zoomLevel = this.zoomLevelOne = 8;
    private String[] zoomNames = new String[]{"256", "128", "64", "32", "16", "8", "4", "2", "1", "1/2", "1/4", "1/8", "1/16", "1/32", "1/64", "1/128", "1/256"};
    private Thread exportThread;

    public GuiAtlas() {
        this.setSize(310, 218);
        this.setMapScale(0.5);
        this.followPlayer = true;
        this.setInterceptKeyboard(true);
        this.btnUp = GuiArrowButton.up();
        this.addChild(this.btnUp).offsetGuiCoords(148, 10);
        this.btnDown = GuiArrowButton.down();
        this.addChild(this.btnDown).offsetGuiCoords(148, 194);
        this.btnLeft = GuiArrowButton.left();
        this.addChild(this.btnLeft).offsetGuiCoords(15, 100);
        this.btnRight = GuiArrowButton.right();
        this.addChild(this.btnRight).offsetGuiCoords(283, 100);
        this.btnPosition = new GuiPositionButton();
        this.btnPosition.setEnabled(!this.followPlayer);
        this.addChild(this.btnPosition).offsetGuiCoords(283, 194);
        IButtonListener<GuiComponentButton> positionListener = button -> {
            this.selectedButton = button;
            if (((Object)((Object)button)).equals((Object)this.btnPosition)) {
                this.followPlayer = true;
                this.btnPosition.setEnabled(false);
            } else {
                this.navigateByButton(this.selectedButton);
                this.timeButtonPressed = this.player.method_5770().method_8510();
            }
        };
        this.btnUp.addListener(positionListener);
        this.btnDown.addListener(positionListener);
        this.btnLeft.addListener(positionListener);
        this.btnRight.addListener(positionListener);
        this.btnPosition.addListener(positionListener);
        this.btnExportPng = new GuiBookmarkButton(1, Textures.ICON_EXPORT, (class_2561)new class_2588("gui.antiqueatlas.exportImage")){

            @Override
            public boolean isEnabled() {
                return !ExportImageUtil.isExporting;
            }
        };
        this.addChild(this.btnExportPng).offsetGuiCoords(300, 75);
        this.btnExportPng.addListener(button -> {
            if (this.stack != null || !SettingsConfig.gameplay.itemNeeded) {
                this.exportThread = new Thread(() -> this.exportImage(this.getAtlasID()), "Atlas file export thread");
                this.exportThread.start();
            }
        });
        this.btnMarker = new GuiBookmarkButton(0, Textures.ICON_ADD_MARKER, (class_2561)new class_2588("gui.antiqueatlas.addMarker"));
        this.addChild(this.btnMarker).offsetGuiCoords(300, 14);
        this.btnMarker.addListener(button -> {
            if (this.state.is(this.PLACING_MARKER)) {
                this.selectedButton = null;
                this.state.switchTo(this.NORMAL);
            } else if (this.stack != null || !SettingsConfig.gameplay.itemNeeded) {
                this.selectedButton = button;
                this.state.switchTo(this.PLACING_MARKER);
                if (GuiAtlas.method_25442()) {
                    this.markerFinalizer.setMarkerData(this.player.method_5770(), this.getAtlasID(), (class_5321<class_2874>)this.player.method_5770().method_29287(), (int)this.player.method_23317(), (int)this.player.method_23321());
                    this.addChild(this.markerFinalizer);
                    this.blinkingIcon.setTexture(this.markerFinalizer.selectedType.getIcon(), 32, 32);
                    this.addChildBehind(this.markerFinalizer, this.blinkingIcon).setRelativeCoords(this.worldXToScreenX((int)this.player.method_23317()) - this.getGuiX() - 16, this.worldZToScreenY((int)this.player.method_23321()) - this.getGuiY() - 16);
                    this.setInterceptKeyboard(true);
                    class_304.method_1437();
                    this.selectedButton = null;
                    this.state.switchTo(this.NORMAL);
                }
            }
        });
        this.btnDelMarker = new GuiBookmarkButton(2, Textures.ICON_DELETE_MARKER, (class_2561)new class_2588("gui.antiqueatlas.delMarker"));
        this.addChild(this.btnDelMarker).offsetGuiCoords(300, 33);
        this.btnDelMarker.addListener(button -> {
            if (this.state.is(this.DELETING_MARKER)) {
                this.selectedButton = null;
                this.state.switchTo(this.NORMAL);
            } else if (this.stack != null || !SettingsConfig.gameplay.itemNeeded) {
                this.selectedButton = button;
                this.state.switchTo(this.DELETING_MARKER);
            }
        });
        this.btnShowMarkers = new GuiBookmarkButton(3, Textures.ICON_HIDE_MARKERS, (class_2561)new class_2588("gui.antiqueatlas.hideMarkers"));
        this.addChild(this.btnShowMarkers).offsetGuiCoords(300, 52);
        this.btnShowMarkers.addListener(button -> {
            this.selectedButton = null;
            if (this.state.is(this.HIDING_MARKERS)) {
                this.state.switchTo(this.NORMAL);
            } else if (this.stack != null || !SettingsConfig.gameplay.itemNeeded) {
                this.selectedButton = null;
                this.state.switchTo(this.HIDING_MARKERS);
            }
        });
        this.addChild(this.scaleBar).offsetGuiCoords(20, 198);
        this.scaleBar.setMapScale(1.0);
        this.markerFinalizer.addMarkerListener(this.blinkingIcon);
        this.eraser.setTexture(Textures.ERASER, 12, 14, 2, 11);
    }

    public GuiAtlas prepareToOpen(class_1799 stack) {
        this.stack = stack;
        return this.prepareToOpen();
    }

    public GuiAtlas prepareToOpen() {
        this.player = class_310.method_1551().field_1724;
        this.updateAtlasData();
        if (!this.followPlayer && SettingsConfig.gameplay.doSaveBrowsingPos) {
            this.loadSavedBrowsingPosition();
        }
        return this;
    }

    public void loadSavedBrowsingPosition() {
        this.setMapScale(this.biomeData.getBrowsingZoom());
        this.mapOffsetX = this.biomeData.getBrowsingX();
        this.mapOffsetY = this.biomeData.getBrowsingY();
        this.isDragging = false;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.state.is(this.EXPORTING_IMAGE)) {
            this.state.switchTo(this.NORMAL);
        }
        class_310.method_1551().field_1774.method_1462(true);
        this.screenScale = class_310.method_1551().method_22683().method_4495();
        this.setCentered();
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int mouseState) {
        boolean isMouseOverMap;
        boolean result = super.method_25402(mouseX, mouseY, mouseState);
        if (this.state.is(this.EXPORTING_IMAGE)) {
            return result;
        }
        if (result) {
            return true;
        }
        int mapX = (this.field_22789 - 276) / 2;
        int mapY = (this.field_22790 - 194) / 2;
        boolean bl = isMouseOverMap = mouseX >= (double)mapX && mouseX <= (double)(mapX + 276) && mouseY >= (double)mapY && mouseY <= (double)(mapY + 194);
        if (!this.state.is(this.NORMAL) && !this.state.is(this.HIDING_MARKERS)) {
            int atlasID = this.getAtlasID();
            if (this.state.is(this.PLACING_MARKER) && isMouseOverMap && mouseState == 0) {
                this.markerFinalizer.setMarkerData(this.player.method_5770(), atlasID, (class_5321<class_2874>)this.player.field_6002.method_29287(), this.screenXToWorldX((int)mouseX), this.screenYToWorldZ((int)mouseY));
                this.addChild(this.markerFinalizer);
                this.blinkingIcon.setTexture(this.markerFinalizer.selectedType.getIcon(), 32, 32);
                this.addChildBehind(this.markerFinalizer, this.blinkingIcon).setRelativeCoords((int)mouseX - this.getGuiX() - 16, (int)mouseY - this.getGuiY() - 16);
                this.setInterceptKeyboard(true);
                class_304.method_1437();
                this.state.switchTo(this.NORMAL);
                return true;
            }
            if (this.state.is(this.DELETING_MARKER) && this.hoveredMarker != null && !this.hoveredMarker.isGlobal() && isMouseOverMap && mouseState == 0) {
                AtlasAPI.markers.deleteMarker(this.player.method_5770(), atlasID, this.hoveredMarker.getId());
            }
            this.state.switchTo(this.NORMAL);
        } else if (isMouseOverMap && this.selectedButton == null && (this.hoveredMarker == null || !((MarkerClickedCallback)MarkerClickedCallback.EVENT.invoker()).onClicked(this.player, this.hoveredMarker, mouseState))) {
            this.isDragging = true;
            return true;
        }
        return result;
    }

    private void exportImage(int atlasID) {
        boolean showMarkers = !this.state.is(this.HIDING_MARKERS);
        this.state.switchTo(this.EXPORTING_IMAGE);
        ExportImageUtil.isExporting = true;
        File screenshot_folder = new File(class_310.method_1551().field_1697, "screenshots");
        if (!screenshot_folder.isDirectory()) {
            screenshot_folder.mkdir();
        }
        String outputname = "atlas-" + DATE_FORMAT.format(new Date());
        File file = new File(screenshot_folder, outputname + ".png");
        int i = 1;
        while (file.exists()) {
            file = new File(screenshot_folder, outputname + "_" + i + ".png");
            ++i;
        }
        if (file != null) {
            try {
                Log.info("Exporting image from Atlas #%d to file %s", atlasID, file.getAbsolutePath());
                ExportImageUtil.exportPngImage(this.biomeData, this.globalMarkersData, this.localMarkersData, file, showMarkers);
                Log.info("Finished exporting image", new Object[0]);
            }
            catch (OutOfMemoryError e) {
                Log.warn(e, "Image is too large, trying to export in strips", new Object[0]);
                try {
                    ExportImageUtil.exportPngImageTooLarge(this.biomeData, this.globalMarkersData, this.localMarkersData, file, showMarkers);
                }
                catch (OutOfMemoryError e2) {
                    int minX = (this.biomeData.getScope().minX - 1) * 16;
                    int minY = (this.biomeData.getScope().minY - 1) * 16;
                    int outWidth = (this.biomeData.getScope().maxX + 2) * 16 - minX;
                    int outHeight = (this.biomeData.getScope().maxY + 2) * 16 - minY;
                    Log.error(e2, "Image is STILL too large, how massive is this map?! Answer: (%dx%d)", outWidth, outHeight);
                    ExportUpdateListener.INSTANCE.setStatusString(class_1074.method_4662((String)"gui.antiqueatlas.export.tooLarge", (Object[])new Object[0]), new Object[0]);
                    ExportImageUtil.isExporting = false;
                    return;
                }
            }
        }
        ExportImageUtil.isExporting = false;
        this.state.switchTo(showMarkers ? this.NORMAL : this.HIDING_MARKERS);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.navigateMap(0, 24);
        } else if (keyCode == 264) {
            this.navigateMap(0, -24);
        } else if (keyCode == 263) {
            this.navigateMap(24, 0);
        } else if (keyCode == 262) {
            this.navigateMap(-24, 0);
        } else if (keyCode == 61 || keyCode == 334) {
            this.setMapScale(this.mapScale * 2.0);
        } else if (keyCode == 45 || keyCode == 333) {
            this.setMapScale(this.mapScale / 2.0);
        } else if (keyCode == 256) {
            this.method_25419();
        } else {
            class_304[] hotbarKeys;
            for (class_304 bind : hotbarKeys = class_310.method_1551().field_1690.field_1852) {
                if (!bind.method_1417(keyCode, scanCode) || this.markerFinalizer.getParent() != null) continue;
                this.method_25419();
                return false;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        return true;
    }

    @Override
    public boolean method_25401(double mx, double my, double wheelMove) {
        double origWheelMove = wheelMove;
        boolean handled = super.method_25401(mx, my, origWheelMove);
        if (!handled && wheelMove != 0.0) {
            double d = wheelMove = wheelMove > 0.0 ? 1.0 : -1.0;
            if (SettingsConfig.userInterface.doReverseWheelZoom) {
                wheelMove *= -1.0;
            }
            double mouseOffsetX = (double)class_310.method_1551().method_22683().method_4489() / this.screenScale / 2.0 - this.getMouseX();
            double mouseOffsetY = (double)class_310.method_1551().method_22683().method_4506() / this.screenScale / 2.0 - this.getMouseY();
            double newScale = this.mapScale * Math.pow(2.0, wheelMove);
            double addOffsetX = 0.0;
            double addOffsetY = 0.0;
            if (Math.abs(mouseOffsetX) < 138.0 && Math.abs(mouseOffsetY) < 97.0) {
                addOffsetX = mouseOffsetX * wheelMove;
                addOffsetY = mouseOffsetY * wheelMove;
                if (wheelMove > 0.0) {
                    addOffsetX *= this.mapScale / newScale;
                    addOffsetY *= this.mapScale / newScale;
                }
            }
            this.setMapScale(newScale, (int)addOffsetX, (int)addOffsetY);
            return true;
        }
        return handled;
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int mouseState) {
        boolean result = false;
        if (mouseState != -1) {
            result = this.selectedButton != null || this.isDragging;
            this.selectedButton = null;
            this.isDragging = false;
        }
        return super.method_25406(mouseX, mouseY, mouseState) || result;
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int lastMouseButton, double deltaX, double deltaY) {
        boolean result = false;
        if (this.isDragging) {
            this.followPlayer = false;
            this.btnPosition.setEnabled(true);
            this.mapOffsetX += (int)deltaX;
            this.mapOffsetY += (int)deltaY;
            result = true;
        }
        return super.method_25403(mouseX, mouseY, lastMouseButton, deltaX, deltaY) || result;
    }

    @Override
    public void method_25393() {
        super.method_25393();
        if (this.player == null) {
            return;
        }
        if (this.followPlayer) {
            this.mapOffsetX = (int)(-this.player.method_23317() * this.mapScale);
            this.mapOffsetY = (int)(-this.player.method_23321() * this.mapScale);
        }
        if (this.player.method_5770().method_8510() > this.timeButtonPressed + 8L) {
            this.navigateByButton(this.selectedButton);
        }
        this.updateAtlasData();
    }

    private void updateAtlasData() {
        int atlasID = this.getAtlasID();
        this.biomeData = AntiqueAtlasMod.atlasData.getAtlasData(atlasID, this.player.method_5770()).getDimensionData((class_5321<class_2874>)this.player.field_6002.method_29287());
        this.globalMarkersData = AntiqueAtlasMod.globalMarkersData.getData().getMarkersDataInDimension((class_5321<class_2874>)this.player.field_6002.method_29287());
        MarkersData markersData = AntiqueAtlasMod.markersData.getMarkersData(atlasID, this.player.method_5770());
        this.localMarkersData = markersData != null ? markersData.getMarkersDataInDimension((class_5321<class_2874>)this.player.field_6002.method_29287()) : null;
    }

    private void navigateByButton(GuiComponentButton btn) {
        if (btn == null) {
            return;
        }
        if (((Object)((Object)btn)).equals((Object)this.btnUp)) {
            this.navigateMap(0, 24);
        } else if (((Object)((Object)btn)).equals((Object)this.btnDown)) {
            this.navigateMap(0, -24);
        } else if (((Object)((Object)btn)).equals((Object)this.btnLeft)) {
            this.navigateMap(24, 0);
        } else if (((Object)((Object)btn)).equals((Object)this.btnRight)) {
            this.navigateMap(-24, 0);
        }
    }

    private void navigateMap(int dx, int dy) {
        this.mapOffsetX += dx;
        this.mapOffsetY += dy;
        this.followPlayer = false;
        this.btnPosition.setEnabled(true);
    }

    public void setMapScale(double scale) {
        this.setMapScale(scale, 0, 0);
    }

    private void setMapScale(double scale, int addOffsetX, int addOffsetY) {
        double oldScale = this.mapScale;
        this.mapScale = Math.min(Math.max(scale, SettingsConfig.userInterface.minScale), SettingsConfig.userInterface.maxScale);
        if (oldScale == this.mapScale) {
            return;
        }
        if (this.mapScale >= 0.5) {
            this.tileHalfSize = (int)Math.round(8.0 * this.mapScale);
            this.tile2ChunkScale = 1;
        } else {
            this.tileHalfSize = (int)Math.round(4.0);
            this.tile2ChunkScale = (int)Math.round(0.5 / this.mapScale);
        }
        this.scaleBar.setMapScale(this.mapScale * 2.0);
        this.mapOffsetX = (int)((double)(this.mapOffsetX + addOffsetX) * (this.mapScale / oldScale));
        this.mapOffsetY = (int)((double)(this.mapOffsetY + addOffsetY) * (this.mapScale / oldScale));
        this.scaleClipIndex = class_3532.method_15351((int)((int)(this.mapScale * 8192.0))) + 1 - 13;
        this.zoomLevel = -this.scaleClipIndex + this.zoomLevelOne;
        this.scaleAlpha = 255;
        if (this.followPlayer && (addOffsetX != 0 || addOffsetY != 0)) {
            this.followPlayer = false;
            this.btnPosition.setEnabled(true);
        }
    }

    @Override
    public void method_25394(class_4587 matrix, int mouseX, int mouseY, float par3) {
        List<Marker> markers;
        int z;
        int x;
        long currentMillis = System.currentTimeMillis();
        long deltaMillis = currentMillis - this.lastUpdateMillis;
        this.lastUpdateMillis = currentMillis;
        if (SettingsConfig.performance.debugRender) {
            this.renderTimes[this.renderTimesIndex++] = System.currentTimeMillis();
            if (this.renderTimesIndex == this.renderTimes.length) {
                this.renderTimesIndex = 0;
                double elapsed = 0.0;
                for (int i = 0; i < this.renderTimes.length - 1; ++i) {
                    elapsed += (double)(this.renderTimes[i + 1] - this.renderTimes[i]);
                }
                System.out.printf("GuiAtlas avg. render time: %.3f\n", elapsed / (double)this.renderTimes.length);
            }
        }
        super.method_25420(matrix);
        class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4493.method_21945((int)516, (float)0.0f);
        AtlasRenderHelper.drawFullTexture(Textures.BOOK, this.getGuiX(), this.getGuiY(), 310, 218);
        if (this.stack == null && SettingsConfig.gameplay.itemNeeded || this.biomeData == null) {
            return;
        }
        if (this.state.is(this.DELETING_MARKER)) {
            class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)(this.getGuiX() + 17) * this.screenScale)), (int)((int)((double)class_310.method_1551().method_22683().method_4506() - (double)(this.getGuiY() + 11 + 194) * this.screenScale)), (int)((int)(276.0 * this.screenScale)), (int)((int)(194.0 * this.screenScale)));
        class_4493.method_22056();
        class_4493.method_21984((int)770, (int)771);
        int mapStartX = MathUtil.roundToBase((int)Math.floor(-(138.0 + (double)this.mapOffsetX + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapStartZ = MathUtil.roundToBase((int)Math.floor(-(97.0 + (double)this.mapOffsetY + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapEndX = MathUtil.roundToBase((int)Math.ceil((138.0 - (double)this.mapOffsetX + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapEndZ = MathUtil.roundToBase((int)Math.ceil((97.0 - (double)this.mapOffsetY + (double)(2 * this.tileHalfSize)) / this.mapScale / 16.0), this.tile2ChunkScale);
        int mapStartScreenX = this.getGuiX() + 155 + (int)((double)(mapStartX << 4) * this.mapScale) + this.mapOffsetX;
        int mapStartScreenY = this.getGuiY() + 109 + (int)((double)(mapStartZ << 4) * this.mapScale) + this.mapOffsetY;
        TileRenderIterator iter = new TileRenderIterator(this.biomeData);
        iter.setScope(new Rect().setOrigin(mapStartX, mapStartZ).set(mapStartX, mapStartZ, mapEndX, mapEndZ));
        iter.setStep(this.tile2ChunkScale);
        boolean v = true;
        while (iter.hasNext()) {
            SubTileQuartet subtiles = iter.next();
            for (SubTile subtile : subtiles) {
                if (subtile == null || subtile.tile == null) continue;
                AtlasRenderHelper.drawAutotileCorner(BiomeTextureMap.instance().getTexture(subtile.variationNumber, subtile.tile), mapStartScreenX + subtile.x * this.tileHalfSize, mapStartScreenY + subtile.y * this.tileHalfSize, subtile.getTextureU(), subtile.getTextureV(), this.tileHalfSize);
            }
        }
        int markersStartX = MathUtil.roundToBase(mapStartX, 8) / 8 - 1;
        int markersStartZ = MathUtil.roundToBase(mapStartZ, 8) / 8 - 1;
        int markersEndX = MathUtil.roundToBase(mapEndX, 8) / 8 + 1;
        int markersEndZ = MathUtil.roundToBase(mapEndZ, 8) / 8 + 1;
        double iconScale = this.getIconScale();
        for (x = markersStartX; x <= markersEndX; ++x) {
            for (z = markersStartZ; z <= markersEndZ; ++z) {
                markers = this.globalMarkersData.getMarkersAtChunk(x, z);
                if (markers == null) continue;
                for (Marker marker : markers) {
                    this.renderMarker(mouseX, mouseY, marker, iconScale);
                }
            }
        }
        if (this.localMarkersData != null) {
            for (x = markersStartX; x <= markersEndX; ++x) {
                for (z = markersStartZ; z <= markersEndZ; ++z) {
                    markers = this.localMarkersData.getMarkersAtChunk(x, z);
                    if (markers == null) continue;
                    for (Marker marker : markers) {
                        this.renderMarker(mouseX, mouseY, marker, iconScale);
                    }
                }
            }
        }
        GL11.glDisable((int)3089);
        class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AtlasRenderHelper.drawFullTexture(Textures.BOOK_FRAME, this.getGuiX(), this.getGuiY(), 310, 218);
        this.renderScaleOverlay(matrix, deltaMillis);
        iconScale = this.getIconScale();
        if (!this.state.is(this.HIDING_MARKERS)) {
            int playerOffsetX = (int)(this.player.method_23317() * this.mapScale) + this.mapOffsetX;
            int playerOffsetZ = (int)(this.player.method_23321() * this.mapScale) + this.mapOffsetY;
            if (playerOffsetX < -138) {
                playerOffsetX = -138;
            }
            if (playerOffsetX > 138) {
                playerOffsetX = 138;
            }
            if (playerOffsetZ < -97) {
                playerOffsetZ = -97;
            }
            if (playerOffsetZ > 95) {
                playerOffsetZ = 95;
            }
            class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.state.is(this.PLACING_MARKER) ? 0.5f : 1.0f));
            class_4493.method_21926();
            class_4493.method_21999((float)(this.getGuiX() + 155 + playerOffsetX), (float)(this.getGuiY() + 109 + playerOffsetZ), (float)0.0f);
            float playerRotation = (float)Math.round(this.player.field_6031 / 360.0f * 16.0f) / 16.0f * 360.0f;
            class_4493.method_21981((float)(180.0f + playerRotation), (float)0.0f, (float)0.0f, (float)1.0f);
            class_4493.method_21999((float)((float)(-3.0 * iconScale)), (float)((float)(-4.0 * iconScale)), (float)0.0f);
            AtlasRenderHelper.drawFullTexture(Textures.PLAYER, 0.0, 0.0, (int)Math.round(7.0 * iconScale), (int)Math.round(8.0 * iconScale));
            class_4493.method_21928();
            class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        super.method_25394(matrix, mouseX, mouseY, par3);
        class_4493.method_22056();
        class_4493.method_21984((int)770, (int)771);
        if (this.state.is(this.PLACING_MARKER)) {
            class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            this.markerFinalizer.selectedType.calculateMip(iconScale, this.mapScale, this.screenScale);
            MarkerRenderInfo renderInfo = this.markerFinalizer.selectedType.getRenderInfo(iconScale, this.mapScale, this.screenScale);
            this.markerFinalizer.selectedType.resetMip();
            AtlasRenderHelper.drawFullTexture(renderInfo.tex, (double)mouseX + renderInfo.x, (double)mouseY + renderInfo.y, renderInfo.width, renderInfo.height);
            class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.state.is(this.EXPORTING_IMAGE)) {
            this.method_25420(matrix);
            this.progressBar.draw(matrix, (this.field_22789 - 100) / 2, this.field_22790 / 2 - 34);
        }
    }

    private void renderScaleOverlay(class_4587 matrix, long deltaMillis) {
        if (this.scaleAlpha > 0) {
            int textWidth;
            class_4493.method_21999((float)(this.getGuiX() + 310 - 13), (float)(this.getGuiY() + 12), (float)0.0f);
            String text = "x";
            int xWidth = textWidth = this.field_22793.method_1727(text);
            ++xWidth;
            this.field_22793.method_1729(matrix, text, (float)(-textWidth), 0.0f, this.scaleAlpha << 24);
            text = this.zoomNames[this.zoomLevel];
            if (text.contains("/")) {
                String[] parts = text.split("/");
                text = parts[0];
                int centerXtranslate = Math.max(this.field_22793.method_1727(parts[0]), this.field_22793.method_1727(parts[1])) / 2;
                float f = -xWidth - centerXtranslate;
                this.field_22793.getClass();
                class_4493.method_21999((float)f, (float)(-9 / 2), (float)0.0f);
                class_4493.method_21912();
                class_289 t = class_289.method_1348();
                class_287 vb = t.method_1349();
                vb.method_1328(7, class_290.field_1592);
                double d = centerXtranslate;
                this.field_22793.getClass();
                vb.method_22912(d, (double)(9 - 1), 0.0).method_1344();
                double d2 = -centerXtranslate - 1;
                this.field_22793.getClass();
                vb.method_22912(d2, (double)(9 - 1), 0.0).method_1344();
                double d3 = -centerXtranslate - 1;
                this.field_22793.getClass();
                vb.method_22912(d3, 9.0, 0.0).method_1344();
                double d4 = centerXtranslate;
                this.field_22793.getClass();
                vb.method_22912(d4, 9.0, 0.0).method_1344();
                t.method_1350();
                class_4493.method_21910();
                textWidth = this.field_22793.method_1727(text);
                this.field_22793.method_1729(matrix, text, (float)(-textWidth / 2), 0.0f, this.scaleAlpha << 24);
                text = parts[1];
                this.field_22793.getClass();
                class_4493.method_21999((float)0.0f, (float)(9 + 1), (float)0.0f);
                textWidth = this.field_22793.method_1727(text);
                this.field_22793.method_1729(matrix, text, (float)(-textWidth / 2), 0.0f, this.scaleAlpha << 24);
                float f2 = xWidth + centerXtranslate;
                this.field_22793.getClass();
                class_4493.method_21999((float)f2, (float)(-9 / 2 - 2), (float)0.0f);
            } else {
                textWidth = this.field_22793.method_1727(text);
                this.field_22793.method_1729(matrix, text, (float)(-textWidth - xWidth + 1), 1.0f, this.scaleAlpha << 24);
            }
            class_4493.method_21999((float)(-(this.getGuiX() + 310 - 13)), (float)(-(this.getGuiY() + 12)), (float)0.0f);
            int deltaScaleAlpha = (int)((double)deltaMillis * 0.256);
            if (deltaScaleAlpha == 0) {
                deltaScaleAlpha = 1;
            }
            this.scaleAlpha -= 20 * deltaScaleAlpha;
            if (this.scaleAlpha < 0) {
                this.scaleAlpha = 0;
            }
        }
    }

    private void renderMarker(int mouseX, int mouseY, Marker marker, double scale) {
        MarkerType type = MarkerRegistry.find(marker.getType());
        if (type == null) {
            Log.warn("Could not find marker data for %s. Is it in the config file?\n", marker.getType());
            return;
        }
        if (type.shouldHide(this.state.is(this.HIDING_MARKERS), this.scaleClipIndex)) {
            return;
        }
        int markerX = this.worldXToScreenX(marker.getX());
        int markerY = this.worldZToScreenY(marker.getZ());
        if (!marker.isVisibleAhead() && !this.biomeData.hasTileAt(marker.getChunkX(), marker.getChunkZ())) {
            return;
        }
        type.calculateMip(scale, this.mapScale, this.screenScale);
        MarkerRenderInfo info = type.getRenderInfo(scale, this.mapScale, this.screenScale);
        boolean mouseIsOverMarker = type.shouldHover((this.getMouseX() - ((double)markerX + info.x)) / (double)info.width, (this.getMouseY() - ((double)markerY + info.y)) / (double)info.height);
        type.resetMip();
        if (mouseIsOverMarker) {
            class_4493.method_22000((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            this.hoveredMarker = marker;
            ((MarkerHoveredCallback)MarkerHoveredCallback.EVENT.invoker()).onHovered(this.player, marker);
        } else {
            class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.hoveredMarker == marker) {
                this.hoveredMarker = null;
            }
        }
        if (this.state.is(this.PLACING_MARKER)) {
            class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        } else if (this.state.is(this.DELETING_MARKER) && marker.isGlobal()) {
            class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        } else {
            class_4493.method_22000((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (SettingsConfig.performance.debugRender) {
            System.out.println("Rendering Marker: " + info.tex);
        }
        AtlasRenderHelper.drawFullTexture(info.tex, (double)markerX + info.x, (double)markerY + info.y, info.width, info.height);
        if (this.isMouseOver && mouseIsOverMarker && marker.getLabel().length() > 0) {
            this.drawTooltip(Collections.singletonList(marker.getLocalizedLabel()), this.field_22793);
        }
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    public void method_25419() {
        super.method_25419();
        this.removeChild(this.markerFinalizer);
        this.removeChild(this.blinkingIcon);
        this.biomeData.setBrowsingPosition(this.mapOffsetX, this.mapOffsetY, this.mapScale);
        PacketDispatcher.sendToServer(new BrowsingPositionPacket(this.getAtlasID(), (class_5321<class_2874>)this.player.field_6002.method_29287(), this.mapOffsetX, this.mapOffsetY, this.mapScale));
    }

    private int screenXToWorldX(int mouseX) {
        return (int)Math.round((double)(mouseX - this.field_22789 / 2 - this.mapOffsetX) / this.mapScale);
    }

    private int screenYToWorldZ(int mouseY) {
        return (int)Math.round((double)(mouseY - this.field_22790 / 2 - this.mapOffsetY) / this.mapScale);
    }

    private int worldXToScreenX(int x) {
        return (int)Math.round((double)x * this.mapScale + (double)((float)this.field_22789 / 2.0f) + (double)this.mapOffsetX);
    }

    private int worldZToScreenY(int z) {
        return (int)Math.round((double)z * this.mapScale + (double)((float)this.field_22790 / 2.0f) + (double)this.mapOffsetY);
    }

    @Override
    protected void onChildClosed(GuiComponent child) {
        if (((Object)((Object)child)).equals((Object)this.markerFinalizer)) {
            this.setInterceptKeyboard(true);
            this.removeChild(this.blinkingIcon);
        }
    }

    public void updateL18n() {
        this.btnExportPng.setTitle((class_2561)new class_2588("gui.antiqueatlas.exportImage"));
        this.btnMarker.setTitle((class_2561)new class_2588("gui.antiqueatlas.addMarker"));
    }

    private double getIconScale() {
        return SettingsConfig.userInterface.doScaleMarkers ? (this.mapScale < 0.5 ? 0.5 : (this.mapScale > 1.0 ? 2.0 : 1.0)) : 1.0;
    }

    private int getAtlasID() {
        return SettingsConfig.gameplay.itemNeeded ? ((ItemAtlas)this.stack.method_7909()).getAtlasID(this.stack) : this.player.method_5667().hashCode();
    }
}

