/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.core.BiomeDetectorBase;
import hunternif.mc.atlas.core.BiomeDetectorEnd;
import hunternif.mc.atlas.core.BiomeDetectorNether;
import hunternif.mc.atlas.core.DimensionData;
import hunternif.mc.atlas.core.IBiomeDetector;
import hunternif.mc.atlas.core.TileInfo;
import hunternif.mc.atlas.core.TileKind;
import hunternif.mc.atlas.core.TileKindFactory;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.client.MapDataPacket;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.ShortVec2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5321;

public class AtlasData
extends class_18 {
    public static final int VERSION = 3;
    public static final String TAG_VERSION = "aaVersion";
    public static final String TAG_DIMENSION_MAP_LIST = "qDimensionMap";
    public static final String TAG_DIMENSION_ID = "qDimensionID";
    public static final String TAG_VISITED_CHUNKS = "qVisitedChunks";
    public static final String TAG_BROWSING_X = "qBrowseX";
    public static final String TAG_BROWSING_Y = "qBrowseY";
    public static final String TAG_BROWSING_ZOOM = "qBrowseZoom";
    private final Map<class_5321<class_2874>, IBiomeDetector> biomeAnalyzers = new HashMap<class_5321<class_2874>, IBiomeDetector>();
    private final BiomeDetectorBase biomeDetectorOverworld = new BiomeDetectorBase();
    private final BiomeDetectorNether biomeDetectorNether = new BiomeDetectorNether();
    private final BiomeDetectorEnd biomeDetectorEnd = new BiomeDetectorEnd();
    private final Map<class_5321<class_2874>, DimensionData> dimensionMap = new ConcurrentHashMap<class_5321<class_2874>, DimensionData>(2, 0.75f, 2);
    private final Set<class_1657> playersSentTo = new HashSet<class_1657>();
    private class_2487 nbt;

    public AtlasData(String key) {
        super(key);
        this.biomeDetectorOverworld.setScanPonds(SettingsConfig.performance.doScanPonds);
        this.biomeDetectorOverworld.setScanRavines(SettingsConfig.performance.doScanRavines);
        this.setBiomeDetectorForDimension((class_5321<class_2874>)class_2874.field_24753, this.biomeDetectorOverworld);
        this.setBiomeDetectorForDimension((class_5321<class_2874>)class_2874.field_24754, this.biomeDetectorNether);
        this.setBiomeDetectorForDimension((class_5321<class_2874>)class_2874.field_24755, this.biomeDetectorEnd);
    }

    public void method_77(class_2487 compound) {
        this.nbt = compound;
        int version = compound.method_10550(TAG_VERSION);
        if (version < 3) {
            Log.warn("Outdated atlas data format! Was %d but current is %d. Updating.", version, 3);
            this.readFromNBT2(compound);
            return;
        }
        class_2499 dimensionMapList = compound.method_10554(TAG_DIMENSION_MAP_LIST, 10);
        for (int d = 0; d < dimensionMapList.size(); ++d) {
            class_2487 dimTag = dimensionMapList.method_10602(d);
            class_5321 dimensionID = class_5321.method_29179((class_5321)class_2378.field_25095, (class_2960)new class_2960(dimTag.method_10558(TAG_DIMENSION_ID)));
            class_2499 dimensionTag = (class_2499)dimTag.method_10580(TAG_VISITED_CHUNKS);
            DimensionData dimData = this.getDimensionData((class_5321<class_2874>)dimensionID);
            dimData.readFromNBT(dimensionTag);
            double zoom = (double)dimTag.method_10550(TAG_BROWSING_ZOOM) / 1024.0;
            if (zoom == 0.0) {
                zoom = 0.5;
            }
            dimData.setBrowsingPosition(dimTag.method_10550(TAG_BROWSING_X), dimTag.method_10550(TAG_BROWSING_Y), zoom);
        }
    }

    public void readFromNBT2(class_2487 compound) {
        this.nbt = compound;
        int version = compound.method_10550(TAG_VERSION);
        if (version < 2) {
            Log.warn("Loading map with version 2 failed", new Object[0]);
            this.method_80();
            return;
        }
        class_2499 dimensionMapList = compound.method_10554(TAG_DIMENSION_MAP_LIST, 10);
        for (int d = 0; d < dimensionMapList.size(); ++d) {
            class_2487 dimTag = dimensionMapList.method_10602(d);
            class_5321 dimensionID = class_5321.method_29179((class_5321)class_2378.field_25095, (class_2960)new class_2960(dimTag.method_10558(TAG_DIMENSION_ID)));
            int[] intArray = dimTag.method_10561(TAG_VISITED_CHUNKS);
            DimensionData dimData = this.getDimensionData((class_5321<class_2874>)dimensionID);
            for (int i = 0; i < intArray.length; i += 3) {
                if (dimData.getTile(intArray[i], intArray[i + 1]) != null) {
                    Log.warn("Duplicate tile at " + intArray[i] + ", " + intArray[i], new Object[0]);
                }
                dimData.setTile(intArray[i], intArray[i + 1], TileKindFactory.get(intArray[i + 2]));
            }
            Log.info("Updated " + intArray.length / 3 + " chunks", new Object[0]);
            double zoom = (double)dimTag.method_10550(TAG_BROWSING_ZOOM) / 1024.0;
            if (zoom == 0.0) {
                zoom = 0.5;
            }
            dimData.setBrowsingPosition(dimTag.method_10550(TAG_BROWSING_X), dimTag.method_10550(TAG_BROWSING_Y), zoom);
        }
    }

    public class_2487 method_75(class_2487 compound) {
        return this.writeToNBT(compound, true);
    }

    public class_2487 writeToNBT(class_2487 compound, boolean includeTileData) {
        class_2499 dimensionMapList = new class_2499();
        compound.method_10569(TAG_VERSION, 3);
        for (Map.Entry<class_5321<class_2874>, DimensionData> dimensionEntry : this.dimensionMap.entrySet()) {
            class_2487 dimTag = new class_2487();
            dimTag.method_10582(TAG_DIMENSION_ID, dimensionEntry.getKey().method_29177().toString());
            DimensionData dimData = dimensionEntry.getValue();
            if (includeTileData) {
                dimTag.method_10566(TAG_VISITED_CHUNKS, (class_2520)dimData.writeToNBT());
            }
            dimTag.method_10569(TAG_BROWSING_X, dimData.getBrowsingX());
            dimTag.method_10569(TAG_BROWSING_Y, dimData.getBrowsingY());
            dimTag.method_10569(TAG_BROWSING_ZOOM, (int)Math.round(dimData.getBrowsingZoom() * 1024.0));
            dimensionMapList.add((Object)dimTag);
        }
        compound.method_10566(TAG_DIMENSION_MAP_LIST, (class_2520)dimensionMapList);
        return compound;
    }

    private void setBiomeDetectorForDimension(class_5321<class_2874> dimension, IBiomeDetector biomeAnalyzer) {
        this.biomeAnalyzers.put(dimension, biomeAnalyzer);
    }

    private IBiomeDetector getBiomeDetectorForDimension(class_5321<class_2874> dimension) {
        IBiomeDetector biomeAnalyzer = this.biomeAnalyzers.get(dimension);
        return biomeAnalyzer == null ? this.biomeDetectorOverworld : biomeAnalyzer;
    }

    public Collection<TileInfo> updateMapAroundPlayer(class_1657 player) {
        int newScanInterval = Math.round(SettingsConfig.performance.newScanInterval * 20.0f);
        int rescanInterval = newScanInterval * SettingsConfig.performance.rescanRate;
        if (player.method_5770().method_8510() % (long)newScanInterval != 0L) {
            return Collections.emptyList();
        }
        ArrayList<TileInfo> updatedTiles = new ArrayList<TileInfo>();
        int playerX = class_3532.method_15357((double)player.method_23317()) >> 4;
        int playerZ = class_3532.method_15357((double)player.method_23321()) >> 4;
        DimensionData seenChunks = this.getDimensionData((class_5321<class_2874>)player.method_5770().method_29287());
        IBiomeDetector biomeDetector = this.getBiomeDetectorForDimension((class_5321<class_2874>)player.field_6002.method_29287());
        int scanRadius = SettingsConfig.performance.scanRadius;
        boolean rescanRequired = SettingsConfig.performance.doRescan && player.method_5770().method_8510() % (long)rescanInterval == 0L;
        int scanRadiusSq = scanRadius * scanRadius;
        for (double dx = (double)(-scanRadius); dx <= (double)scanRadius; dx += 1.0) {
            for (double dz = (double)(-scanRadius); dz <= (double)scanRadius; dz += 1.0) {
                if (dx * dx + dz * dz > (double)scanRadiusSq) continue;
                int x = (int)((double)playerX + dx);
                int z = (int)((double)playerZ + dz);
                TileKind oldTile = seenChunks.getTile(x, z);
                TileKind tile = null;
                int customTileId = AntiqueAtlasMod.extBiomeData.getData().getBiomeAt((class_5321<class_2874>)player.field_6002.method_29287(), x, z);
                if (customTileId != -1) {
                    tile = TileKindFactory.get(customTileId);
                }
                if (tile == null) {
                    class_2791 chunk;
                    if (oldTile != null && !rescanRequired || (chunk = player.method_5770().method_8402(x, z, class_2806.field_12803, SettingsConfig.performance.forceChunkLoading)) == null) continue;
                    if (oldTile != null) {
                        tile = biomeDetector.getBiomeID(player.method_5770(), chunk);
                        if (tile == null) {
                            this.removeTile((class_5321<class_2874>)player.field_6002.method_29287(), x, z);
                            continue;
                        }
                        if (oldTile == tile) continue;
                        this.setTile((class_5321<class_2874>)player.field_6002.method_29287(), x, z, tile);
                        updatedTiles.add(new TileInfo(x, z, tile));
                        continue;
                    }
                    tile = biomeDetector.getBiomeID(player.method_5770(), chunk);
                    if (tile == null) continue;
                    this.setTile((class_5321<class_2874>)player.field_6002.method_29287(), x, z, tile);
                    updatedTiles.add(new TileInfo(x, z, tile));
                    continue;
                }
                if (oldTile != null && oldTile == tile) continue;
                this.setTile((class_5321<class_2874>)player.field_6002.method_29287(), x, z, tile);
                updatedTiles.add(new TileInfo(x, z, tile));
                this.method_80();
            }
        }
        return updatedTiles;
    }

    public void setTile(class_5321<class_2874> dimension, int x, int y, TileKind tile) {
        DimensionData dimData = this.getDimensionData(dimension);
        dimData.setTile(x, y, tile);
    }

    private TileKind removeTile(class_5321<class_2874> dimension, int x, int y) {
        DimensionData dimData = this.getDimensionData(dimension);
        return dimData.removeTile(x, y);
    }

    public Set<class_5321<class_2874>> getVisitedDimensions() {
        return this.dimensionMap.keySet();
    }

    public DimensionData getDimensionData(class_5321<class_2874> dimension) {
        return this.dimensionMap.computeIfAbsent(dimension, k -> new DimensionData(this, dimension));
    }

    public Map<ShortVec2, TileKind> getSeenChunksInDimension(class_5321<class_2874> dimension) {
        return this.getDimensionData(dimension).getSeenChunks();
    }

    public Collection<class_1657> getSyncedPlayers() {
        return Collections.unmodifiableCollection(this.playersSentTo);
    }

    public boolean isSyncedOnPlayer(class_1657 player) {
        return this.playersSentTo.contains(player);
    }

    public void syncOnPlayer(int atlasID, class_1657 player) {
        if (this.nbt == null) {
            this.nbt = new class_2487();
        }
        this.writeToNBT(this.nbt, false);
        PacketDispatcher.sendTo(new MapDataPacket(atlasID, this.nbt), (class_3222)player);
        for (class_5321<class_2874> i : this.dimensionMap.keySet()) {
            this.dimensionMap.get(i).syncOnPlayer(atlasID, player);
        }
        Log.info("Sent Atlas #%d data to player %s", atlasID, player.method_5671().method_9214());
        this.playersSentTo.add(player);
    }

    public boolean isEmpty() {
        return this.dimensionMap.isEmpty();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AtlasData)) {
            return false;
        }
        AtlasData other = (AtlasData)((Object)obj);
        if (other.dimensionMap.size() != this.dimensionMap.size()) {
            return false;
        }
        for (class_5321<class_2874> key : this.dimensionMap.keySet()) {
            if (this.dimensionMap.get(key).equals(other.dimensionMap.get(key))) continue;
            return false;
        }
        return true;
    }
}

