/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.core.BiomeDetectorBase;
import hunternif.mc.atlas.core.IBiomeDetector;
import hunternif.mc.atlas.core.TileKind;
import hunternif.mc.atlas.core.TileKindFactory;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import java.util.HashMap;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_4548;

public class BiomeDetectorEnd
extends BiomeDetectorBase
implements IBiomeDetector {
    @Override
    public TileKind getBiomeID(class_1937 world, class_2791 chunk) {
        class_4548 chunkBiomes = chunk.method_12036();
        HashMap<class_1959, Integer> biomeOccurrences = new HashMap<class_1959, Integer>(class_2378.field_11153.method_10235().size());
        int islandOccurences = 0;
        int plantOccurences = 0;
        int voidOccurences = 0;
        class_1959 endID = class_1972.field_9411;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                class_1959 biomeID = chunkBiomes.method_16359(x, 0, z);
                if (biomeID == endID) {
                    int top = chunk.method_12032(class_2902.class_2903.field_13203).method_12603(x, z);
                    class_2680 topBlock = chunk.method_8320(new class_2338(x, top - 1, z));
                    if (topBlock.method_26204() == class_2246.field_10471) {
                        ++islandOccurences;
                        class_2680 rootBlock = chunk.method_8320(new class_2338(x, top, z));
                        if (rootBlock.method_26204() != class_2246.field_10528 && rootBlock.method_26204() != class_2246.field_10021) continue;
                        ++plantOccurences;
                        continue;
                    }
                    if (!topBlock.method_26215()) continue;
                    ++voidOccurences;
                    continue;
                }
                biomeOccurrences.put(biomeID, biomeOccurrences.getOrDefault(biomeID, 0) + this.priorityForBiome(biomeID));
            }
        }
        TileKind meanBiomeId = null;
        int meanBiomeOccurences = 0;
        for (class_1959 biome : biomeOccurrences.keySet()) {
            int occ = (Integer)biomeOccurrences.get(biome);
            if ((Integer)biomeOccurrences.get(biome) <= meanBiomeOccurences) continue;
            meanBiomeId = TileKindFactory.get(biome);
            meanBiomeOccurences = occ;
        }
        if (meanBiomeOccurences < islandOccurences) {
            meanBiomeId = plantOccurences == 0 ? TileKindFactory.get(ExtTileIdMap.TILE_END_ISLAND) : TileKindFactory.get(ExtTileIdMap.TILE_END_ISLAND_PLANTS);
        } else if (meanBiomeOccurences < voidOccurences) {
            meanBiomeId = TileKindFactory.get(ExtTileIdMap.TILE_END_VOID);
        }
        return meanBiomeId;
    }
}

