/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.core.BiomeDetectorBase;
import hunternif.mc.atlas.core.IBiomeDetector;
import hunternif.mc.atlas.core.TileKind;
import hunternif.mc.atlas.core.TileKindFactory;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import java.util.HashMap;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_4548;

public class BiomeDetectorNether
extends BiomeDetectorBase
implements IBiomeDetector {
    private static final int airProbeLevel = 50;
    private static final int lavaSeaLevel = 31;
    private static final int priorityLava = 1;

    @Override
    public TileKind getBiomeID(class_1937 world, class_2791 chunk) {
        int biomesCount = class_2378.field_11153.method_10235().size();
        class_4548 chunkBiomes = chunk.method_12036();
        HashMap<class_1959, Integer> biomeOccurrences = new HashMap<class_1959, Integer>(class_2378.field_11153.method_10235().size());
        int lavaOccurences = 0;
        int groundOccurences = 0;
        class_1959 hellID = class_1972.field_9461;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                class_1959 biomeID = chunkBiomes.method_16359(x, 0, z);
                if (biomeID == hellID) {
                    class_2248 netherBlock = chunk.method_8320(new class_2338(x, 31, z)).method_26204();
                    if (netherBlock == class_2246.field_10164) {
                        ++lavaOccurences;
                        continue;
                    }
                    class_2680 netherBlockState = chunk.method_8320(new class_2338(x, 50, z));
                    if (netherBlockState.method_26215()) {
                        ++groundOccurences;
                        continue;
                    }
                    biomeOccurrences.put(biomeID, biomeOccurrences.getOrDefault(biomeID, 0) + 1);
                    continue;
                }
                biomeOccurrences.put(biomeID, biomeOccurrences.getOrDefault(biomeID, 0) + this.priorityForBiome(biomeID));
            }
        }
        TileKind meanBiomeId = null;
        int meanBiomeOccurences = 0;
        for (class_1959 biome : biomeOccurrences.keySet()) {
            int occ = (Integer)biomeOccurrences.get(biome);
            if ((Integer)biomeOccurrences.get(biome) <= meanBiomeOccurences) continue;
            meanBiomeId = TileKindFactory.get(biome);
            meanBiomeOccurences = occ;
        }
        if (meanBiomeOccurences < lavaOccurences) {
            meanBiomeId = TileKindFactory.get(ExtTileIdMap.TILE_LAVA);
        } else if (meanBiomeOccurences < groundOccurences) {
            meanBiomeId = TileKindFactory.get(ExtTileIdMap.TILE_LAVA_SHORE);
        }
        return meanBiomeId;
    }
}

