/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.core;

import hunternif.mc.atlas.core.TileKind;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public final class TileKindFactory {
    private static final Map<class_1959, TileKind> biomeKinds = new IdentityHashMap<class_1959, TileKind>();
    private static final Int2ObjectMap<TileKind> extKinds = new Int2ObjectOpenHashMap();

    private TileKindFactory() {
    }

    public static TileKind get(int id) {
        if (id < 0) {
            return (TileKind)extKinds.get(id);
        }
        class_1959 biome = (class_1959)class_2378.field_11153.method_10200(id);
        if (biome != null) {
            return TileKindFactory.get(biome);
        }
        return null;
    }

    public static TileKind get(class_1959 biome) {
        return biomeKinds.computeIfAbsent(biome, BiomeKind::new);
    }

    public static TileKind get(class_2960 extTile) {
        int id = ExtTileIdMap.instance().getOrCreatePseudoBiomeID(extTile);
        return (TileKind)extKinds.computeIfAbsent(id, ExtKind::new);
    }

    private static class BiomeKind
    implements TileKind {
        private final class_1959 biome;

        BiomeKind(class_1959 biome) {
            this.biome = biome;
        }

        @Override
        public int getId() {
            return class_2378.field_11153.method_10249((Object)this.biome);
        }

        @Override
        @Nullable
        public class_1959 getBiome() {
            return this.biome;
        }

        @Override
        @Nullable
        public class_2960 getExtTile() {
            return null;
        }

        public String toString() {
            return "BiomeTile{" + class_2378.field_11153.method_10221((Object)this.biome) + "}";
        }
    }

    private static class ExtKind
    implements TileKind {
        private final int id;

        ExtKind(int id) {
            this.id = id;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        @Nullable
        public class_1959 getBiome() {
            return null;
        }

        @Override
        @Nullable
        public class_2960 getExtTile() {
            return ExtTileIdMap.instance().getPseudoBiomeName(this.id);
        }

        public String toString() {
            return "ExtTile{" + this.getExtTile() + "}";
        }
    }
}

