/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.ext.watcher.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.ext.watcher.IStructureWatcher;
import hunternif.mc.atlas.ext.watcher.StructureWatcher;
import hunternif.mc.atlas.ext.watcher.WatcherPos;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.registry.MarkerRegistry;
import hunternif.mc.atlas.registry.MarkerType;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.MathUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_5321;
import org.apache.commons.lang3.tuple.Pair;

public class StructureWatcherVillage
implements IStructureWatcher {
    public static final String MARKER = "village";
    private static final String LIBRARY = "ViBH";
    private static final String SMITHY = "ViS";
    private static final String L_HOUSE = "ViTRH";
    private static final String FARMLAND_LARGE = "ViDF";
    private static final String FARMLAND_SMALL = "ViF";
    private static final String PATH = "ViSR";
    private static final String TORCH = "ViL";
    private static final String WELL = "ViW";
    private static final String START = "ViStart";
    private static final String BUTCHERS = "ViPH";
    private static final String HUT = "ViSmH";
    private static final String HOUSE_SMALL = "ViSH";
    private static final String CHURCH = "ViST";
    private static final Map<String, class_2960> partToTileMap;
    private static final Map<class_2960, Integer> tilePriority;
    private final Set<WatcherPos> visited = new HashSet<WatcherPos>();

    public StructureWatcherVillage() {
        StructureWatcher.INSTANCE.addWatcher(this);
    }

    @Override
    @Nonnull
    public Set<WatcherPos> getVisited() {
        return this.visited;
    }

    @Override
    public boolean isDimensionValid(class_5321<class_2874> type) {
        return type == class_2874.field_24753;
    }

    @Override
    @Nullable
    public class_2487 getStructureData(@Nonnull class_1937 world) {
        return null;
    }

    @Override
    @Nonnull
    public Set<Pair<WatcherPos, String>> visitStructure(@Nonnull class_1937 world, @Nonnull class_2487 structureTag) {
        Set tagSet = structureTag.method_10541();
        HashSet visits = Sets.newHashSet();
        for (String coords : tagSet) {
            WatcherPos pos;
            if (!WatcherPos.POS_PATTERN.matcher(coords).matches() || this.visited.contains(pos = new WatcherPos(coords))) continue;
            class_2487 tag = structureTag.method_10562(coords);
            this.visitVillage(world, tag);
            this.visited.add(pos);
            visits.add(Pair.of((Object)pos, (Object)"Village"));
        }
        return visits;
    }

    private void visitVillage(class_1937 world, class_2487 tag) {
        if (!tag.method_10577("Valid")) {
            StructureWatcherVillage.removeVillage(world, tag);
            return;
        }
        MarkerType villageType = MarkerRegistry.find("antiqueatlas:village");
        if (villageType == null) {
            return;
        }
        class_2499 children = tag.method_10554("Children", 10);
        for (int i = 0; i < children.size(); ++i) {
            class_2960 tileName;
            class_2487 child = children.method_10602(i);
            String childID = child.method_10558("id");
            class_3341 boundingBox = new class_3341(child.method_10561("BB"));
            int x = MathUtil.getCenter(boundingBox).method_10263();
            int z = MathUtil.getCenter(boundingBox).method_10260();
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            if (START.equals(childID)) {
                boolean foundMarker = false;
                for (int j = -1; j <= 1; ++j) {
                    block2: for (int k = -1; k <= 1; ++k) {
                        List<Marker> markers = AntiqueAtlasMod.globalMarkersData.getData().getMarkersAtChunk((class_5321<class_2874>)world.method_29287(), j + chunkX / 8, k + chunkZ / 8);
                        if (markers == null) continue;
                        for (Marker marker : markers) {
                            if (!marker.getType().equals(villageType)) continue;
                            foundMarker = true;
                            continue block2;
                        }
                    }
                }
                if (!foundMarker && SettingsConfig.gameplay.autoVillageMarkers) {
                    AtlasAPI.markers.putGlobalMarker(world, false, MarkerRegistry.getId(villageType).toString(), "gui.antiqueatlas.marker.village", x, z);
                }
            }
            if ((tileName = partToTileMap.get(childID)) == null) continue;
            Integer curTilePriority = tilePriority.get(tileName);
            Integer prevTilePriority = tilePriority.get(StructureWatcherVillage.tileAt(chunkX, chunkZ));
            if (curTilePriority != null && prevTilePriority != null) {
                if (curTilePriority < prevTilePriority) continue;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX, chunkZ);
                continue;
            }
            AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX, chunkZ);
        }
    }

    private static class_2960 tileAt(int chunkX, int chunkZ) {
        int biomeID = AntiqueAtlasMod.extBiomeData.getData().getBiomeAt((class_5321<class_2874>)class_2874.field_24753, chunkX, chunkZ);
        return ExtTileIdMap.instance().getPseudoBiomeName(biomeID);
    }

    private static void removeVillage(class_1937 world, class_2487 tag) {
        class_2499 children = tag.method_10554("Children", 10);
        for (int i = 0; i < children.size(); ++i) {
            List<Marker> markers;
            class_2487 child = children.method_10602(i);
            String childID = child.method_10558("id");
            class_3341 boundingBox = new class_3341(child.method_10561("BB"));
            int x = MathUtil.getCenter(boundingBox).method_10263();
            int z = MathUtil.getCenter(boundingBox).method_10260();
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            if (START.equals(childID) && (markers = AntiqueAtlasMod.globalMarkersData.getData().getMarkersAtChunk((class_5321<class_2874>)world.method_29287(), chunkX / 8, chunkZ / 8)) != null) {
                for (Marker marker : markers) {
                    if (!marker.getType().equals("antiqueatlas:village")) continue;
                    AtlasAPI.markers.deleteGlobalMarker(world, marker.getId());
                    Log.info("Removed faux village marker", new Object[0]);
                    break;
                }
            }
            AtlasAPI.tiles.deleteCustomGlobalTile(world, chunkX, chunkZ);
            Log.info("Removed faux village tile", new Object[0]);
        }
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)LIBRARY, (Object)ExtTileIdMap.TILE_VILLAGE_LIBRARY);
        builder.put((Object)SMITHY, (Object)ExtTileIdMap.TILE_VILLAGE_SMITHY);
        builder.put((Object)L_HOUSE, (Object)ExtTileIdMap.TILE_VILLAGE_L_HOUSE);
        builder.put((Object)FARMLAND_LARGE, (Object)ExtTileIdMap.TILE_VILLAGE_FARMLAND_LARGE);
        builder.put((Object)FARMLAND_SMALL, (Object)ExtTileIdMap.TILE_VILLAGE_FARMLAND_SMALL);
        builder.put((Object)TORCH, (Object)ExtTileIdMap.TILE_VILLAGE_TORCH);
        builder.put((Object)WELL, (Object)ExtTileIdMap.TILE_VILLAGE_WELL);
        builder.put((Object)START, (Object)ExtTileIdMap.TILE_VILLAGE_WELL);
        builder.put((Object)BUTCHERS, (Object)ExtTileIdMap.TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)HOUSE_SMALL, (Object)ExtTileIdMap.TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)HUT, (Object)ExtTileIdMap.TILE_VILLAGE_HUT);
        builder.put((Object)CHURCH, (Object)ExtTileIdMap.TILE_VILLAGE_CHURCH);
        partToTileMap = builder.build();
        builder = new ImmutableMap.Builder();
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_LIBRARY, (Object)5);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_SMITHY, (Object)6);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_L_HOUSE, (Object)5);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_FARMLAND_LARGE, (Object)3);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_FARMLAND_SMALL, (Object)3);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_TORCH, (Object)1);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_WELL, (Object)7);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_BUTCHERS_SHOP, (Object)4);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_SMALL_HOUSE, (Object)4);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_HUT, (Object)3);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_CHURCH, (Object)6);
        tilePriority = builder.build();
    }
}

