/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.marker;

import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.marker.DimensionMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.client.MarkersPacket;
import hunternif.mc.atlas.util.Log;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class MarkersData
extends class_18 {
    private static final int VERSION = 3;
    private static final String TAG_VERSION = "aaVersion";
    private static final String TAG_DIMENSION_MAP_LIST = "dimMap";
    private static final String TAG_DIMENSION_ID = "dimID";
    private static final String TAG_MARKERS = "markers";
    private static final String TAG_MARKER_ID = "id";
    private static final String TAG_MARKER_TYPE = "markerType";
    private static final String TAG_MARKER_LABEL = "label";
    private static final String TAG_MARKER_X = "x";
    private static final String TAG_MARKER_Y = "y";
    private static final String TAG_MARKER_VISIBLE_AHEAD = "visAh";
    public static final int CHUNK_STEP = 8;
    private final Set<class_1657> playersSentTo = new HashSet<class_1657>();
    private final AtomicInteger largestID = new AtomicInteger(0);
    private final Map<Integer, Marker> idMap = new ConcurrentHashMap<Integer, Marker>(2, 0.75f, 2);
    private final Map<class_5321<class_2874>, DimensionMarkersData> dimensionMap = new ConcurrentHashMap<class_5321<class_2874>, DimensionMarkersData>(2, 0.75f, 2);

    private int getNewID() {
        return this.largestID.incrementAndGet();
    }

    public MarkersData(String key) {
        super(key);
    }

    public void method_77(class_2487 compound) {
        int version = compound.method_10550(TAG_VERSION);
        if (version < 3) {
            Log.warn("Outdated atlas data format! Was %d but current is %d", version, 3);
            this.method_80();
        }
        class_2499 dimensionMapList = compound.method_10554(TAG_DIMENSION_MAP_LIST, 10);
        for (int d = 0; d < dimensionMapList.size(); ++d) {
            class_2487 tag = dimensionMapList.method_10602(d);
            class_5321 dimensionID = class_5321.method_29179((class_5321)class_2378.field_25095, (class_2960)new class_2960(tag.method_10558(TAG_DIMENSION_ID)));
            class_2499 tagList = tag.method_10554(TAG_MARKERS, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                int id;
                class_2487 markerTag = tagList.method_10602(i);
                boolean visibleAhead = true;
                if (version < 2) {
                    Log.warn("Marker is visible ahead by default", new Object[0]);
                } else {
                    visibleAhead = markerTag.method_10577(TAG_MARKER_VISIBLE_AHEAD);
                }
                if (version < 3) {
                    id = this.getNewID();
                } else {
                    id = markerTag.method_10550(TAG_MARKER_ID);
                    if (this.getMarkerByID(id) != null) {
                        Log.warn("Loading marker with duplicate id %d. Getting new id", id);
                        id = this.getNewID();
                    }
                    this.method_80();
                }
                if (this.largestID.intValue() < id) {
                    this.largestID.set(id);
                }
                Marker marker = new Marker(id, markerTag.method_10558(TAG_MARKER_TYPE), markerTag.method_10558(TAG_MARKER_LABEL), (class_5321<class_2874>)dimensionID, markerTag.method_10550(TAG_MARKER_X), markerTag.method_10550(TAG_MARKER_Y), visibleAhead);
                this.loadMarker(marker);
            }
        }
    }

    public class_2487 method_75(class_2487 compound) {
        Log.info("Saving local markers data to NBT", new Object[0]);
        compound.method_10569(TAG_VERSION, 3);
        class_2499 dimensionMapList = new class_2499();
        for (class_5321<class_2874> dimension : this.dimensionMap.keySet()) {
            class_2487 tag = new class_2487();
            tag.method_10582(TAG_DIMENSION_ID, dimension.method_29177().toString());
            DimensionMarkersData data = this.getMarkersDataInDimension(dimension);
            class_2499 tagList = new class_2499();
            for (Marker marker : data.getAllMarkers()) {
                class_2487 markerTag = new class_2487();
                markerTag.method_10569(TAG_MARKER_ID, marker.getId());
                markerTag.method_10582(TAG_MARKER_TYPE, marker.getType());
                markerTag.method_10582(TAG_MARKER_LABEL, marker.getLabel());
                markerTag.method_10569(TAG_MARKER_X, marker.getX());
                markerTag.method_10569(TAG_MARKER_Y, marker.getZ());
                markerTag.method_10556(TAG_MARKER_VISIBLE_AHEAD, marker.isVisibleAhead());
                tagList.add((Object)markerTag);
            }
            tag.method_10566(TAG_MARKERS, (class_2520)tagList);
            dimensionMapList.add((Object)tag);
        }
        compound.method_10566(TAG_DIMENSION_MAP_LIST, (class_2520)dimensionMapList);
        return compound;
    }

    public Set<class_5321<class_2874>> getVisitedDimensions() {
        return this.dimensionMap.keySet();
    }

    public Collection<Marker> getMarkersInDimension(class_5321<class_2874> dimension) {
        return this.getMarkersDataInDimension(dimension).getAllMarkers();
    }

    public DimensionMarkersData getMarkersDataInDimension(class_5321<class_2874> dimension) {
        return this.dimensionMap.computeIfAbsent(dimension, k -> new DimensionMarkersData(this, dimension));
    }

    public List<Marker> getMarkersAtChunk(class_5321<class_2874> dimension, int x, int z) {
        return this.getMarkersDataInDimension(dimension).getMarkersAtChunk(x, z);
    }

    private Marker getMarkerByID(int id) {
        return this.idMap.get(id);
    }

    public Marker removeMarker(int id) {
        Marker marker = this.getMarkerByID(id);
        if (marker == null) {
            return null;
        }
        if (this.idMap.remove(id) != null) {
            this.getMarkersDataInDimension(marker.getDimension()).removeMarker(marker);
            this.method_80();
        }
        return marker;
    }

    public Marker createAndSaveMarker(String type, String label, class_5321<class_2874> dimension, int x, int z, boolean visibleAhead) {
        Marker marker = new Marker(this.getNewID(), type, label, dimension, x, z, visibleAhead);
        Log.info("Created new marker %s", marker.toString());
        this.idMap.put(marker.getId(), marker);
        this.getMarkersDataInDimension(marker.getDimension()).insertMarker(marker);
        this.method_80();
        return marker;
    }

    public Marker loadMarker(Marker marker) {
        if (!this.idMap.containsKey(marker.getId())) {
            this.idMap.put(marker.getId(), marker);
            int totalMarkers = 0;
            for (Map.Entry<class_5321<class_2874>, DimensionMarkersData> e : this.dimensionMap.entrySet()) {
                totalMarkers += e.getValue().getAllMarkers().size();
            }
            if (totalMarkers < SettingsConfig.performance.markerLimit) {
                this.getMarkersDataInDimension(marker.getDimension()).insertMarker(marker);
            } else {
                Log.warn("Could not add new marker. Atlas is at it's limit of %d markers", SettingsConfig.performance.markerLimit);
            }
        }
        return marker;
    }

    public boolean isSyncedOnPlayer(class_1657 player) {
        return this.playersSentTo.contains(player);
    }

    public void syncOnPlayer(int atlasID, class_1657 player) {
        for (class_5321<class_2874> dimension : this.dimensionMap.keySet()) {
            MarkersPacket packet = this.newMarkersPacket(atlasID, dimension);
            DimensionMarkersData data = this.getMarkersDataInDimension(dimension);
            for (Marker marker : data.getAllMarkers()) {
                packet.putMarker(marker);
            }
            PacketDispatcher.sendTo(packet, (class_3222)player);
        }
        Log.info("Sent markers data #%d to player %s", atlasID, player.method_5671().method_9214());
        this.playersSentTo.add(player);
    }

    MarkersPacket newMarkersPacket(int atlasID, class_5321<class_2874> dimension) {
        return new MarkersPacket(atlasID, dimension, new Marker[0]);
    }

    public boolean isEmpty() {
        return this.idMap.isEmpty();
    }
}

