/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.network.AbstractMessage;
import hunternif.mc.atlas.network.bidirectional.DeleteMarkerPacket;
import hunternif.mc.atlas.network.bidirectional.PutTilePacket;
import hunternif.mc.atlas.network.client.DeleteCustomGlobalTilePacket;
import hunternif.mc.atlas.network.client.DimensionUpdatePacket;
import hunternif.mc.atlas.network.client.MapDataPacket;
import hunternif.mc.atlas.network.client.MarkersPacket;
import hunternif.mc.atlas.network.client.TileGroupsPacket;
import hunternif.mc.atlas.network.client.TileNameIDPacket;
import hunternif.mc.atlas.network.client.TilesPacket;
import hunternif.mc.atlas.network.server.AddMarkerPacket;
import hunternif.mc.atlas.network.server.BrowsingPositionPacket;
import hunternif.mc.atlas.network.server.RegisterTileIdPacket;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.api.server.PlayerStream;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class PacketDispatcher {
    private static final BiMap<class_2960, Class<?>> packets = HashBiMap.create();
    private static final Set<class_2960> clientPackets = new HashSet<class_2960>();
    private static final Set<class_2960> serverPackets = new HashSet<class_2960>();

    private PacketDispatcher() {
    }

    public static void registerPackets() {
        PacketDispatcher.registerMessage(new class_2960("antiqueatlas", "delete_marker"), DeleteMarkerPacket.class);
        PacketDispatcher.registerMessage(new class_2960("antiqueatlas", "put_tile"), PutTilePacket.class);
        PacketDispatcher.registerMessage(new class_2960("antiqueatlas", "map_data"), MapDataPacket.class);
        PacketDispatcher.registerMessage(new class_2960("antiqueatlas", "tile_groups"), TileGroupsPacket.class);
        PacketDispatcher.registerMessage(new class_2960("antiqueatlas", "dimension_update"), DimensionUpdatePacket.class);
        PacketDispatcher.registerMessage(new class_2960("antiqueatlas", "tile_name_id"), TileNameIDPacket.class);
        PacketDispatcher.registerMessage(new class_2960("antiqueatlas", "tiles"), TilesPacket.class);
        PacketDispatcher.registerMessage(new class_2960("antiqueatlas", "markers"), MarkersPacket.class);
        PacketDispatcher.registerMessage(new class_2960("antiqueatlas", "delete_custom_global_tile"), DeleteCustomGlobalTilePacket.class);
        PacketDispatcher.registerMessage(new class_2960("antiqueatlas", "add_marker"), AddMarkerPacket.class);
        PacketDispatcher.registerMessage(new class_2960("antiqueatlas", "register_tile_id"), RegisterTileIdPacket.class);
        PacketDispatcher.registerMessage(new class_2960("antiqueatlas", "browsing_position"), BrowsingPositionPacket.class);
        AntiqueAtlasMod.proxy.registerPackets(clientPackets, serverPackets, id -> (context, buffer) -> {
            Class c = (Class)packets.get(id);
            try {
                AbstractMessage message = (AbstractMessage)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                message.read(buffer);
                if (message.requiresMainThread()) {
                    context.getTaskQueue().execute(() -> message.process(context.getPlayer(), context.getPacketEnvironment()));
                } else {
                    message.process(context.getPlayer(), context.getPacketEnvironment());
                }
            }
            catch (Exception e) {
                AntiqueAtlasMod.logger.warn("Error receiving packet " + id + "!", (Throwable)e);
            }
        });
    }

    private static class_2540 toByteBuf(AbstractMessage<?> message) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        try {
            message.write(buf);
        }
        catch (IOException e) {
            AntiqueAtlasMod.logger.warn("Error sending packet", (Throwable)e);
        }
        return buf;
    }

    private static <T extends AbstractMessage<T>> void registerMessage(class_2960 id, Class<T> clazz) {
        packets.put((Object)id, clazz);
        if (AbstractMessage.AbstractClientMessage.class.isAssignableFrom(clazz)) {
            clientPackets.add(id);
        } else if (AbstractMessage.AbstractServerMessage.class.isAssignableFrom(clazz)) {
            serverPackets.add(id);
        } else {
            clientPackets.add(id);
            serverPackets.add(id);
        }
    }

    public static void sendToAll(MinecraftServer server, AbstractMessage<?> message) {
        PlayerStream.all((MinecraftServer)server).forEach(p -> ServerSidePacketRegistry.INSTANCE.sendToPlayer((class_1657)p, (class_2960)packets.inverse().get(message.getClass()), PacketDispatcher.toByteBuf(message)));
    }

    public static void sendTo(AbstractMessage<?> message, class_3222 player) {
        ServerSidePacketRegistry.INSTANCE.sendToPlayer((class_1657)player, (class_2960)packets.inverse().get(message.getClass()), PacketDispatcher.toByteBuf(message));
    }

    private static void sendToAllAround(AbstractMessage<?> message, class_1937 world, double x, double y, double z, double range) {
        PlayerStream.around((class_1937)world, (class_243)new class_243(x, y, z), (double)range).forEach(p -> ServerSidePacketRegistry.INSTANCE.sendToPlayer(p, (class_2960)packets.inverse().get(message.getClass()), PacketDispatcher.toByteBuf(message)));
    }

    public static void sendToAllAround(AbstractMessage<?> message, class_1657 player, double range) {
        PacketDispatcher.sendToAllAround(message, player.method_5770(), player.method_23317(), player.method_23318(), player.method_23321(), range);
    }

    public static void sendToDimension(AbstractMessage<?> message, class_1937 world) {
        PlayerStream.world((class_1937)world).forEach(p -> ServerSidePacketRegistry.INSTANCE.sendToPlayer(p, (class_2960)packets.inverse().get(message.getClass()), PacketDispatcher.toByteBuf(message)));
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(AbstractMessage<?> message) {
        ClientSidePacketRegistry.INSTANCE.sendToServer((class_2960)packets.inverse().get(message.getClass()), PacketDispatcher.toByteBuf(message));
    }
}

