/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network.bidirectional;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.core.AtlasData;
import hunternif.mc.atlas.core.TileKind;
import hunternif.mc.atlas.core.TileKindFactory;
import hunternif.mc.atlas.network.AbstractMessage;
import hunternif.mc.atlas.util.Log;
import java.io.IOException;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class PutTilePacket
extends AbstractMessage<PutTilePacket> {
    private int atlasID;
    private int x;
    private int z;
    private class_5321<class_2874> dimension;
    private TileKind kind;

    public PutTilePacket() {
    }

    public PutTilePacket(int atlasID, class_5321<class_2874> dimension, int x, int z, TileKind kind) {
        this.atlasID = atlasID;
        this.dimension = dimension;
        this.x = x;
        this.z = z;
        this.kind = kind;
    }

    @Override
    protected void read(class_2540 buffer) throws IOException {
        this.atlasID = buffer.method_10816();
        this.dimension = class_5321.method_29179((class_5321)class_2378.field_25095, (class_2960)buffer.method_10810());
        this.x = buffer.method_10816();
        this.z = buffer.method_10816();
        this.kind = TileKindFactory.get(buffer.method_10816());
    }

    @Override
    protected void write(class_2540 buffer) throws IOException {
        buffer.method_10804(this.atlasID);
        buffer.method_10812(this.dimension.method_29177());
        buffer.method_10804(this.x);
        buffer.method_10804(this.z);
        buffer.method_10804(this.kind.getId());
    }

    @Override
    protected void process(class_1657 player, EnvType side) {
        if (side == EnvType.SERVER) {
            if (SettingsConfig.gameplay.itemNeeded && !AtlasAPI.getPlayerAtlases(player).contains(this.atlasID)) {
                Log.warn("Player %s attempted to modify someone else's Atlas #%d", player.method_5671().method_9214(), this.atlasID);
                return;
            }
            if (this.kind.getId() >= 0) {
                AtlasAPI.tiles.putBiomeTile(player.method_5770(), this.atlasID, this.kind.getBiome(), this.x, this.z);
            } else {
                AtlasAPI.tiles.putCustomTile(player.method_5770(), this.atlasID, this.kind.getExtTile(), this.x, this.z);
            }
        } else {
            AtlasData data = AntiqueAtlasMod.atlasData.getAtlasData(this.atlasID, player.method_5770());
            data.setTile(this.dimension, this.x, this.z, this.kind);
        }
    }
}

